\name{GOLOCUSID2ALLGO}
\alias{GOLOCUSID2ALLGO}
\title{Annotation of LocusLink identifiers by specific and derived gene
  ontology information regarding the genes corresponding to the
  LocusLink identifiers} 
\description{
  This is an R environment (hash table) mapping LocusLink ids to gene
  ontology information regarding the genes represented by the LocusLink
  identifiers. Gene ontology information includes those stated directly
  by NCBI and those derived based on the directed acyclic GO graph defined by
  Gene Ontology Consortium    
}
\details{
  LocusLink ids are keys and the corresponding GO information are
  values. Association of LocusLink ids to GO information were obtained
  by including those reported by NCBI (specific) and those that were
  derived through the parent-child relations among GO nodes on the
  directed acyclic GO graph. If a given GO node had been reported to be
  associated with a LocusLink id, all the offspring of that GO node were
  considered to be associated with the LocusLink id as well. 

  Each locusLink id is mapped to a list with one (mapped to none or one GO id)
  or more (mapped to more than one GO ids) sub lits. Each sub list contains
  three elements named "GOID", "Ontology", and "Evidence". The value for
  element "GOID" gives the Gene Ontology identifier the key LocusLink id 
  corresponds to. The value for element "Ontology" can be an
  abbreviation of MF (mocular function), BP (biological process),or CC
  (cellular component) for the GO category the GO id belongs to. The
  values for element "Evidence" contains an evidence code indicating
  what kind of evidence is found to support the association of the GO id
  to the LocusLink id. The evidence codes in use include:

  IMP - inferred from mutant phenotype  

  IGI - inferred from genetic interaction

  IPI - inferred from physical interaction  

  ISS - inferred from sequence similarity  

  IDA - inferred from direct assay  

  IEP - inferred from expression pattern  

  IEA - inferred from electronic annotation  

  TAS - traceable author statement  

  NAS - non-traceable author statement  

  ND - no biological data available  

  IC - inferred by curator
  
  NA is assigned to LocusLink id that can not be mapped to any GO id at
  this time.

  Mappings were based on data provided by:

  #LLSOURCE#
  
  Package built: #DATE#
}
\references{
    \url{http://www.ncbi.nlm.nih.gov/LocusLink} 
}
\examples{
  	require("GO") || stop("GO unavailable")
        # Convert the environment object to a list
	xx <- as.list(GOLOCUSID2ALLGO)
        # Remove LocusLink ids that are not mapped to any GO id
        xx <- xx[!is.na(xx)]
	if(length(xx) > 0){
		# Get the GO ids for the first two elents of xx
		goids  <- xx[1:2]
                # Get the evidence code goids
                evds <- sapply(goids, names)
	}
}
\keyword{datasets}




