### Name: smooth.hexbin
### Title: Hexagon Bin Smoothing
### Aliases: smooth.hexbin
### Keywords: misc

### ** Examples

x <- rnorm(10000)
y <- rnorm(10000)
bin <- hexbin(x,y)
# show the smooth counts in gray level
smbin  <- smooth.hexbin(bin)
plot.hexbin(smbin)
# Compare the smooth and the origin
smbin1 <- smbin
smbin1$cnts <- ceiling(smbin$cnts/sum(smbin$wts))
plot.hexbin(smbin1)
smbin2 <- smooth.hexbin(bin,wts=c(1,0,0))  # expand the domain for comparability
plot.hexbin(smbin2)



