### Name: hmatplot
### Title: Draw Matrix of 2-D Boxplots For Hexbin Objects
### Aliases: hmatplot
### Keywords: hplot

### ** Examples

# nhanes data set
# remove missing data, and extract variable of interest
# make this so you can do data(nh)

data(NHANES)# pretty large data set!
good <- !(is.na(NHANES$Albumin) | is.na(NHANES$Transferin))
NH.vars <- NHANES[good, c("Age","Sex","Albumin","Transferin")]

# extract dependent variables and find  ranges for global binning
x <- NH.vars[,"Albumin"]
rx <- range(x)
y <- NH.vars[,"Transferin"]
ry <- range(y)

# define index for the twoway layout
age <- cut(NH.vars$Age,c(1,45,65,200))
sex <- NH.vars$Sex
subs <- tapply(age,list(age,sex))

#  bivariate bins for each factor combination
for (i in 1:length(unique(subs))) {
  good <- subs==i
  assign(paste("nam",i,sep=""),
         erode.hexbin(hexbin(x[good],y[good],xbins=23,xbnds=rx,ybnds=ry)))
}

# define arguments to hmatplot
nam <- matrix(paste("nam",1:6,sep=""),ncol=3,byrow=TRUE)
rlabels <-c("Females","Males")
clabels  <- c("Age <= 45","45 < Age <= 65","Age > 65")
zoom <- hmatplot(nam,rlabels,clabels,border=list(hbox=c("black","white"),hdiff=rep("white",6)))

# enlarged legend
hboxplot(nam1, zoom$xbnds,zoom$ybnds, reshape=TRUE, xlab= "Albumin (mg/dl)",
         ylab="Transferrin Sat. (\)", cex=1.2)

str(lapply(NHANES, function(x){if(
is.numeric(x)){cat(names(x),": NA ", sum(is.na(x))," Obs: ",sum(!is.na(x)),"\n")}}))



