### Name: findFClog
### Title: A function to find the fold change between two experimental
###   conditions in a factorial experiment based on the linear model
###   parameter estimates for the data that has been log-transformed.
### Aliases: findFClog
### Keywords: models design

### ** Examples

data(estrogen)
ES <- pData(estrogen)[["ES"]]
TIME <- pData(estrogen)[["TIME"]]
fit <- lm(log(exprs(estrogen)[6,]) ~ ES + TIME + ES*TIME)
betaNames <- names(fit[["coef"]])
betas <- list(c("(Intercept)","ESP","TIME48h","ESP:TIME48h"),
                                        c("(Intercept)","ESP"))
coefs <- list(c(1,1),c(1,1))
lambda <- par2lambda(betaNames,betas,coefs)
findFClog(fit,lambda[1,],lambda[2,])






