/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui.sequence;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import org.biojava.bio.gui.sequence.SequenceRenderContext;
import org.biojava.bio.gui.sequence.SequenceRenderer;
import org.biojava.bio.gui.sequence.SequenceViewerEvent;
import org.biojava.bio.gui.sequence.SequenceViewerListener;
import org.biojava.bio.gui.sequence.SequenceViewerMotionListener;
import org.biojava.bio.gui.sequence.SequenceViewerMotionSupport;
import org.biojava.bio.gui.sequence.SequenceViewerSupport;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeAdapter;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.Changeable;

public class SequencePoster
extends JComponent
implements SwingConstants,
SequenceRenderContext,
Changeable {
    public static final ChangeType RENDERER = new ChangeType("The renderer for this SequencePoster has changed", "org.biojava.bio.gui.sequence.SequencePoster", "RENDERER", SequenceRenderContext.LAYOUT);
    private SymbolList sequence;
    private int direction = 0;
    private double scale = 12.0;
    private int lines = 1;
    private int spacer = 0;
    private SequenceRenderContext.Border leadingBorder;
    private SequenceRenderContext.Border trailingBorder;
    private SequenceRenderer renderer;
    private double[] offsets;
    private int realLines;
    private double alongDim = 0.0;
    private double acrossDim = 0.0;
    private int symbolsPerLine = 0;
    private RendererMonitor theMonitor;
    private transient ChangeSupport changeSupport = null;
    private SequenceViewerSupport svSupport = new SequenceViewerSupport();
    private MouseListener mouseListener = new MouseAdapter(){

        public void mouseClicked(MouseEvent mouseEvent) {
            if (!SequencePoster.this.isActive()) {
                return;
            }
            int[] nArray = SequencePoster.this.calcLineExtent(mouseEvent);
            mouseEvent.translatePoint(-nArray[2], -nArray[3]);
            SequenceViewerEvent sequenceViewerEvent = SequencePoster.this.renderer.processMouseEvent(SequencePoster.this, mouseEvent, new ArrayList(), new RangeLocation(nArray[0], nArray[1]));
            mouseEvent.translatePoint(nArray[2], nArray[3]);
            SequencePoster.this.svSupport.fireMouseClicked(sequenceViewerEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!SequencePoster.this.isActive()) {
                return;
            }
            int[] nArray = SequencePoster.this.calcLineExtent(mouseEvent);
            mouseEvent.translatePoint(-nArray[2], -nArray[3]);
            SequenceViewerEvent sequenceViewerEvent = SequencePoster.this.renderer.processMouseEvent(SequencePoster.this, mouseEvent, new ArrayList(), new RangeLocation(nArray[0], nArray[1]));
            mouseEvent.translatePoint(nArray[2], nArray[3]);
            SequencePoster.this.svSupport.fireMousePressed(sequenceViewerEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!SequencePoster.this.isActive()) {
                return;
            }
            int[] nArray = SequencePoster.this.calcLineExtent(mouseEvent);
            mouseEvent.translatePoint(-nArray[2], -nArray[3]);
            SequenceViewerEvent sequenceViewerEvent = SequencePoster.this.renderer.processMouseEvent(SequencePoster.this, mouseEvent, new ArrayList(), new RangeLocation(nArray[0], nArray[1]));
            mouseEvent.translatePoint(nArray[2], nArray[3]);
            SequencePoster.this.svSupport.fireMouseReleased(sequenceViewerEvent);
        }
    };
    private SequenceViewerMotionSupport svmSupport = new SequenceViewerMotionSupport();
    private MouseMotionListener mouseMotionListener = new MouseMotionListener(){

        public void mouseDragged(MouseEvent mouseEvent) {
            if (!SequencePoster.this.isActive()) {
                return;
            }
            int[] nArray = SequencePoster.this.calcLineExtent(mouseEvent);
            mouseEvent.translatePoint(-nArray[2], -nArray[3]);
            SequenceViewerEvent sequenceViewerEvent = SequencePoster.this.renderer.processMouseEvent(SequencePoster.this, mouseEvent, new ArrayList(), new RangeLocation(nArray[0], nArray[1]));
            mouseEvent.translatePoint(nArray[2], nArray[3]);
            SequencePoster.this.svmSupport.fireMouseDragged(sequenceViewerEvent);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (!SequencePoster.this.isActive()) {
                return;
            }
            int[] nArray = SequencePoster.this.calcLineExtent(mouseEvent);
            mouseEvent.translatePoint(-nArray[2], -nArray[3]);
            SequenceViewerEvent sequenceViewerEvent = SequencePoster.this.renderer.processMouseEvent(SequencePoster.this, mouseEvent, new ArrayList(), new RangeLocation(nArray[0], nArray[1]));
            mouseEvent.translatePoint(nArray[2], nArray[3]);
            SequencePoster.this.svmSupport.fireMouseMoved(sequenceViewerEvent);
        }
    };
    private ChangeListener layoutListener = new ChangeAdapter(){

        public void postChange(ChangeEvent changeEvent) {
            SequencePoster.this.resizeAndValidate();
        }
    };
    private ChangeListener repaintListener = new ChangeAdapter(){

        public void postChange(ChangeEvent changeEvent) {
            SequencePoster.this.repaint();
        }
    };

    public SequencePoster() {
        this.theMonitor = new RendererMonitor();
        this.leadingBorder = new SequenceRenderContext.Border();
        this.trailingBorder = new SequenceRenderContext.Border();
        if (this.getFont() == null) {
            this.setFont(new Font("Times New Roman", 0, 12));
        }
        this.addPropertyChangeListener(this.theMonitor);
        this.addMouseListener(this.mouseListener);
        this.addMouseMotionListener(this.mouseMotionListener);
    }

    protected void _setRenderer(SequenceRenderer sequenceRenderer) {
        Changeable changeable;
        if (this.renderer != null && this.renderer instanceof Changeable) {
            changeable = (Changeable)((Object)this.renderer);
            changeable.removeChangeListener(this.layoutListener, SequenceRenderContext.LAYOUT);
            changeable.removeChangeListener(this.repaintListener, SequenceRenderContext.REPAINT);
        }
        this.renderer = sequenceRenderer;
        if (sequenceRenderer != null && sequenceRenderer instanceof Changeable) {
            changeable = (Changeable)((Object)sequenceRenderer);
            changeable.addChangeListener(this.layoutListener, SequenceRenderContext.LAYOUT);
            changeable.addChangeListener(this.repaintListener, SequenceRenderContext.REPAINT);
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.addChangeListener(changeListener, ChangeType.UNKNOWN);
    }

    public void addChangeListener(ChangeListener changeListener, ChangeType changeType) {
        ChangeSupport changeSupport;
        ChangeSupport changeSupport2 = changeSupport = this.getChangeSupport(changeType);
        synchronized (changeSupport2) {
            changeSupport.addChangeListener(changeListener);
        }
    }

    public void addSequenceViewerListener(SequenceViewerListener sequenceViewerListener) {
        this.svSupport.addSequenceViewerListener(sequenceViewerListener);
    }

    public void addSequenceViewerMotionListener(SequenceViewerMotionListener sequenceViewerMotionListener) {
        this.svmSupport.addSequenceViewerMotionListener(sequenceViewerMotionListener);
    }

    protected int[] calcLineExtent(MouseEvent mouseEvent) {
        int n;
        int n2;
        int n3 = this.direction == 0 ? mouseEvent.getY() : mouseEvent.getX();
        int n4 = Arrays.binarySearch(this.offsets, (double)n3);
        if (n4 < 0) {
            n4 = -n4 - 1;
        }
        int n5 = 1 + (int)((double)n4 * (double)this.symbolsPerLine);
        int n6 = n5 + this.symbolsPerLine - 1;
        double d = n4 > 0 ? this.offsets[n4 - 1] : 0.0;
        double d2 = this.alongDim * (double)n4;
        if (this.direction == 0) {
            n2 = (int)(-d2);
            n = (int)d;
        } else {
            n2 = (int)d;
            n = (int)(-d2);
        }
        return new int[]{n5, n6, n2, n};
    }

    protected ChangeSupport getChangeSupport(ChangeType changeType) {
        if (this.changeSupport == null) {
            this.changeSupport = new ChangeSupport();
        }
        return this.changeSupport;
    }

    public int getDirection() {
        return this.direction;
    }

    public SequenceRenderContext.Border getLeadingBorder() {
        return this.leadingBorder;
    }

    public int getLines() {
        return this.lines;
    }

    public double getScale() {
        return this.scale;
    }

    public SymbolList getSequence() {
        return this.sequence;
    }

    public int getSpacer() {
        return this.spacer;
    }

    public SequenceRenderContext.Border getTrailingBorder() {
        return this.trailingBorder;
    }

    public int graphicsToSequence(double d) {
        return (int)(d / this.scale) + 1;
    }

    public int graphicsToSequence(Point point) {
        if (this.direction == 0) {
            return this.graphicsToSequence(point.getX());
        }
        return this.graphicsToSequence(point.getY());
    }

    protected boolean hasChangeListeners() {
        return this.changeSupport != null;
    }

    protected boolean isActive() {
        return this.sequence != null && this.renderer != null;
    }

    public void paintComponent(Graphics graphics) {
        double d;
        double d2;
        if (!this.isActive()) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Rectangle2D rectangle2D = graphics2D.getClip().getBounds2D();
        if (this.direction == 0) {
            d2 = rectangle2D.getMinY();
            d = rectangle2D.getMaxY();
        } else {
            d2 = rectangle2D.getMinX();
            d = rectangle2D.getMaxX();
        }
        int n = Arrays.binarySearch(this.offsets, d2);
        if (n < 0) {
            n = -n - 1;
        }
        double d3 = n == 0 ? 0.0 : this.offsets[n - 1];
        int n2 = 1 + (int)((double)n * (double)this.symbolsPerLine);
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        if (this.direction == 0) {
            double_.width = this.alongDim;
            double_.height = this.acrossDim;
            graphics2D.translate(this.leadingBorder.getSize() - this.alongDim * (double)n, d3);
        } else {
            double_.width = this.acrossDim;
            double_.height = this.alongDim;
            graphics2D.translate(d3, this.leadingBorder.getSize() - this.alongDim * (double)n);
        }
        int n3 = n2;
        int n4 = n;
        while (n4 < this.realLines) {
            int n5 = Math.min(n3 + this.symbolsPerLine - 1, this.sequence.length());
            RangeLocation rangeLocation = new RangeLocation(n3, n5);
            if (this.direction == 0) {
                double_.x = (double)n4 * this.alongDim;
                double_.y = 0.0;
            } else {
                double_.x = 0.0;
                double_.y = (double)n4 * this.alongDim;
            }
            double d4 = this.offsets[n4] - (double)this.spacer;
            if (n4 != 0) {
                d4 -= this.offsets[n4 - 1];
            }
            if (this.direction == 0) {
                double_.height = d4;
            } else {
                double_.width = d4;
            }
            Shape shape = graphics2D.getClip();
            graphics2D.clip(double_);
            this.renderer.paint(graphics2D, this, rangeLocation);
            graphics2D.setClip(shape);
            if (this.direction == 0) {
                graphics2D.translate(-this.alongDim, (double)this.spacer + d4);
            } else {
                graphics2D.translate((double)this.spacer + d4, -this.alongDim);
            }
            if ((n3 += this.symbolsPerLine) > this.sequence.length() || this.offsets[n4] > d) break;
            ++n4;
        }
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.removeChangeListener(changeListener, ChangeType.UNKNOWN);
    }

    public void removeChangeListener(ChangeListener changeListener, ChangeType changeType) {
        ChangeSupport changeSupport;
        ChangeSupport changeSupport2 = changeSupport = this.getChangeSupport(changeType);
        synchronized (changeSupport2) {
            changeSupport.removeChangeListener(changeListener);
        }
    }

    public void removeSequenceViewerListener(SequenceViewerListener sequenceViewerListener) {
        this.svSupport.removeSequenceViewerListener(sequenceViewerListener);
    }

    public void removeSequenceViewerMotionListener(SequenceViewerMotionListener sequenceViewerMotionListener) {
        this.svmSupport.removeSequenceViewerMotionListener(sequenceViewerMotionListener);
    }

    public void resizeAndValidate() {
        Dimension dimension = null;
        if (!this.isActive()) {
            System.out.println("No sequence");
            this.alongDim = 0.0;
            double d = 0.0;
            this.realLines = 0;
            this.leadingBorder.setSize(0.0);
            this.trailingBorder.setSize(0.0);
            dimension = new Dimension(0, 0);
        } else {
            System.out.println("Fitting to sequence");
            Dimension dimension2 = this.getParent() != null ? this.getParent().getSize() : new Dimension(500, 400);
            int n = this.direction == 0 ? dimension2.width : dimension2.height;
            System.out.println("Initial width: " + n);
            this.alongDim = this.scale * (double)this.sequence.length();
            System.out.println("alongDim (pixles needed for sequence only): " + this.alongDim);
            double d = 0.0;
            RangeLocation rangeLocation = new RangeLocation(1, this.sequence.length());
            double d2 = this.renderer.getMinimumLeader(this, rangeLocation);
            double d3 = this.renderer.getMinimumTrailer(this, rangeLocation);
            this.leadingBorder.setSize(d2);
            this.trailingBorder.setSize(d3);
            double d4 = d2 + d3;
            if (this.lines > 0) {
                this.realLines = this.lines;
                n = (int)Math.ceil(d4 + this.alongDim / (double)this.lines);
            } else {
                double d5 = n;
                d5 -= d4;
                this.realLines = (int)Math.ceil(this.alongDim / (double)n);
                n = (int)Math.ceil(d4 + this.alongDim / (double)this.realLines);
            }
            d = 0.0;
            this.symbolsPerLine = (int)Math.ceil((double)n / this.scale);
            if (this.symbolsPerLine < 1) {
                throw new Error("Pants");
            }
            int n2 = 1;
            this.offsets = new double[this.realLines];
            int n3 = 0;
            while (n2 <= this.sequence.length()) {
                int n4 = n2 + this.symbolsPerLine - 1;
                RangeLocation rangeLocation2 = new RangeLocation(n2, n4);
                double d6 = this.renderer.getDepth(this, rangeLocation2);
                this.offsets[n3] = d += d6 + (double)this.spacer;
                n2 = n4 + 1;
                ++n3;
            }
            this.alongDim = (double)this.symbolsPerLine * this.scale;
            dimension = this.direction == 0 ? new Dimension((int)Math.ceil(this.alongDim + d2 + d3), (int)d) : new Dimension((int)(d += (double)(this.spacer * (this.realLines - 1))), (int)Math.ceil(this.alongDim + d2 + d3));
        }
        this.setMinimumSize(dimension);
        this.setPreferredSize(dimension);
        this.revalidate();
    }

    public double sequenceToGraphics(int n) {
        return (double)(n - 1) * this.scale;
    }

    public void setDirection(int n) throws IllegalArgumentException {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Direction must be either HORIZONTAL or VERTICAL");
        }
        int n2 = this.direction;
        this.direction = n;
        this.resizeAndValidate();
        this.firePropertyChange("direction", n2, this.direction);
    }

    public void setLines(int n) {
        int n2 = this.lines;
        this.lines = n;
        this.resizeAndValidate();
        this.firePropertyChange("lines", n2, n);
    }

    public void setRenderer(SequenceRenderer sequenceRenderer) throws ChangeVetoException {
        if (this.hasChangeListeners()) {
            ChangeSupport changeSupport;
            ChangeEvent changeEvent = new ChangeEvent(this, RENDERER, sequenceRenderer, this.renderer);
            ChangeSupport changeSupport2 = changeSupport = this.getChangeSupport(RENDERER);
            synchronized (changeSupport2) {
                changeSupport.firePreChangeEvent(changeEvent);
                this._setRenderer(sequenceRenderer);
                changeSupport.firePostChangeEvent(changeEvent);
            }
        } else {
            this._setRenderer(sequenceRenderer);
        }
        this.resizeAndValidate();
    }

    public void setScale(double d) {
        double d2 = this.scale;
        this.scale = d;
        this.resizeAndValidate();
        this.firePropertyChange("scale", d2, d);
    }

    public void setSequence(SymbolList symbolList) {
        SymbolList symbolList2 = this.sequence;
        if (symbolList2 != null) {
            symbolList2.removeChangeListener(this.layoutListener);
        }
        this.sequence = symbolList;
        this.sequence.addChangeListener(this.layoutListener);
        this.resizeAndValidate();
        this.firePropertyChange("sequence", symbolList2, symbolList);
    }

    public void setSpacer(int n) {
        int n2 = this.spacer;
        this.spacer = n;
        this.resizeAndValidate();
        this.firePropertyChange("spacer", n2, n);
    }

    private class RendererMonitor
    implements PropertyChangeListener {
        RendererMonitor() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            SequencePoster.this.repaint();
        }
    }

    public class Border
    implements Serializable,
    SwingConstants {
        protected final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
        private double size = 0.0;
        private int alignment = 0;

        private Border() {
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.pcs.addPropertyChangeListener(propertyChangeListener);
        }

        public int getAlignment() {
            return this.alignment;
        }

        public double getSize() {
            return this.size;
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.pcs.removePropertyChangeListener(propertyChangeListener);
        }

        public void setAlignment(int n) throws IllegalArgumentException {
            if (n != 10 && n != 11 && n != 0) {
                throw new IllegalArgumentException("Alignment must be one of the constants LEADING, TRAILING or CENTER");
            }
            int n2 = this.alignment;
            this.alignment = n;
            this.pcs.firePropertyChange("alignment", n2, n);
        }

        private void setSize(double d) {
            this.size = d;
        }
    }
}

