/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dist;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.DistributionTrainer;
import org.biojava.bio.dist.DistributionTrainerContext;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.ChangeVetoException;

public class SimpleDistributionTrainerContext
implements DistributionTrainerContext,
Serializable {
    private final Map distToTrainer = new HashMap();
    private final Set trainers = new HashSet();
    private double nullModelWeight;

    public void addCount(Distribution distribution, Symbol symbol, double d) throws IllegalSymbolException {
        DistributionTrainer distributionTrainer = this.getTrainer(distribution);
        if (distributionTrainer == null) {
            throw new NullPointerException("No trainer associated with distribution " + distribution);
        }
        if (symbol instanceof AtomicSymbol) {
            distributionTrainer.addCount(this, (AtomicSymbol)symbol, d);
        } else {
            Distribution distribution2 = distribution.getNullModel();
            double d2 = distribution2.getWeight(symbol);
            Iterator iterator = ((FiniteAlphabet)symbol.getMatches()).iterator();
            while (iterator.hasNext()) {
                AtomicSymbol atomicSymbol = (AtomicSymbol)iterator.next();
                distributionTrainer.addCount(this, atomicSymbol, d * (distribution2.getWeight(atomicSymbol) / d2));
            }
        }
    }

    public void clearCounts() {
        Iterator iterator = this.trainers.iterator();
        while (iterator.hasNext()) {
            ((DistributionTrainer)iterator.next()).clearCounts();
        }
    }

    public double getNullModelWeight() {
        return this.nullModelWeight;
    }

    public DistributionTrainer getTrainer(Distribution distribution) {
        return (DistributionTrainer)this.distToTrainer.get(distribution);
    }

    public void registerDistribution(Distribution distribution) {
        if (!this.distToTrainer.keySet().contains(distribution)) {
            distribution.registerWithTrainer(this);
        }
    }

    public void registerTrainer(Distribution distribution, DistributionTrainer distributionTrainer) {
        this.distToTrainer.put(distribution, distributionTrainer);
        this.trainers.add(distributionTrainer);
    }

    public void setNullModelWeight(double d) {
        this.nullModelWeight = d;
    }

    public void train() throws ChangeVetoException {
        Iterator iterator = this.trainers.iterator();
        while (iterator.hasNext()) {
            ((DistributionTrainer)iterator.next()).train(this.getNullModelWeight());
        }
    }
}

