
		NAME	BootLinux

MainSeg		SEGMENT PUBLIC 'TEXT'
		ASSUME cs:MainSeg, ds:MainSeg, es:MainSeg

		ORG 0100h		; it is going to be a COM file

BootlinVersion	EQU "1.7d"

FileNameSize	EQU 80			; also length of command line
StackSize	EQU 2048
PlusSize	EQU (FileNameSize+StackSize)
PageOrder	EQU 12			; 4K pages ; max is 14 (16K)
DotOrder	EQU 14			; print a dot every 16K loaded
PageLength	EQU (1 SHL PageOrder)
PageSegInc	EQU (PageLength SHR 4)
KernelStart	EQU 1000h
KernelEnd	EQU 9000h
SetupPage	EQU 9000h
SetupStack	EQU PageLength*2	; multiple of PageLength
					; startpoint of stack pointer
StackLength	EQU (2*200h)		; 2 sectors
CmdLineLength	EQU 256
CmdLineOfs	EQU (SetupStack-StackLength-CmdLineLength)
SetupSpaceSect	EQU (((SetupStack-1) SHR 9)+1)
					; in sectors of 512 bytes
SetupSpaceInc	EQU (((SetupStack-1) SHR 4)+1)
					; in page segment increments
BootLoad	EQU 9000h
BootLength	EQU 200h
SetupLoad	EQU (BootLoad + 20h)
SetupLength	EQU 800h		; this is only a default since
					; linux v1.1
MaxMemory	EQU 0A000h
MinExtended	EQU 1024
BootlinPage	EQU (MaxMemory-PageSegInc)
VideoVGA	EQU 0FFFFh		; 80x25
VideoVGAext	EQU 0FFFEh		; 80x50
VideoASK	EQU 0FFFDh
VideoUnspec	EQU 8000h
;	StatusLine	EQU 10
StatusLine	EQU 9
BootFlag	EQU 0AA55h
CmdLineFlag	EQU 0A33Fh
; Boot Sector Offsets (to the end of bootsector)
bsoBootFlag	EQU 2
bsoRootDev	EQU 4
bsoVideo	EQU 6
bsoRamDiskSize	EQU 8
bsoSwapDev	EQU 10
bsoCmdLineFlag	EQU (200h-20h)
bsoCmdLineOfs	EQU (200h-22h)
; These are for very old images only
;	bsoSwapDev	EQU 8
;	bsoRamDiskSize	EQU 10
; These are are since linux v1.1
bsoSysSize	EQU 12
bsoRootRdOnly	EQU 14
bsoSetupSectors	EQU 15
waitLaunch	EQU 20
waitLoaded	EQU 10

;**********************************************************
; Here is the relocated part of BootLinux
;**********************************************************

JumpStart	PROC FAR
		jmp TheStart
JumpStart	ENDP

		ASSUME cs:MainSeg, ds:NOTHING, es:NOTHING
NewInt13	PROC FAR
		cmp ax,1500h
		je nobypass
bypass:		jmp dword ptr cs:oldint

nobypass:	cmp byte ptr cs:[doRelocate],0
		je bypass	; linux v1.1 calls 13,..15,..13,11

		push bp
		mov bp,sp
		push word ptr [bp+6]
		call dword ptr cs:oldint
		pop bp
		cli
		pushf
		push ds
		push es
		push si
		push di
		push ax
		push bx
		push cx
		push dx

		mov si,cs:pageToMove
		mov di,KernelStart

domove:		call MovePage
		cmp si,cs:lastToMove
		je endmove
		cmp di,SetupPage
		je endmove
		cmp si,SetupPage
		jne domove
		add si,SetupSpaceInc
		jmp short domove	; skip the setup page
endmove:

		pop dx
		pop cx
		pop bx
		pop ax
		pop di
		pop si
		pop es
		pop ds
		popf
		ret 2

oldint		dd 0
pageToMove	dw 0
lastToMove	dw 0
doRelocate	db 0
NewInt13	ENDP

NewInt15	PROC FAR		; to simulate untouched Int 15h
		cmp ah,88h
		je next15
		jmp dword ptr cs:oldint15

next15:		mov byte ptr cs:[doRelocate],1
		mov ax,cs:[extmem]
		iret

oldint15	dd 0
extmem		dw 0
NewInt15	ENDP

NewInt11	PROC FAR		; to simulate untouched Int 11h
		cli
		mov ax,cs:[equip]
		iret

equip		dw 0
NewInt11	ENDP

		ASSUME cs:MainSeg, ds:NOTHING, es:NOTHING
MovePage	PROC NEAR		; moves page at si:0 to frame at di:0
		push ds
		push es
		push cx
		mov ds,si
		mov es,di
		xor si,si
		xor di,di
		mov cx,(PageLength SHR 1)
		cld
		rep movsw
		mov si,ds
		mov di,es
		add si,PageSegInc
		add di,PageSegInc
		pop cx
		pop es
		pop ds
		ret
MovePage	ENDP			; returns di and si on next pages

;**********************************************************
; Here the static part of BootLinux
;**********************************************************

		ASSUME cs:MainSeg, ds:MainSeg, es:MainSeg

BiosWait	PROC NEAR ; (cx=1/18th of seconds to wait)
		push cx
		mov ah,0
		int 1Ah
		pop cx
		add cx,dx
w1:		push cx
		mov ah,0
		int 1Ah
		pop cx
		cmp dx,cx
		jc w1
		ret
BiosWait	ENDP

InitScr		PROC NEAR ; () -> ()
		mov ah,0Fh	; get BIOS video mode
		int 10h
		and al,7Fh	; and set it again, this clears screen,
		mov ah,0	; and preserves video mode (mono/color)
		int 10h
		mov ax,500h
		int 10h
		ret
InitScr		ENDP

WrChar		PROC NEAR ; (al=char to write) -> ()
		mov ah,0Eh	; this is "teletype" output
		mov bx,7	; handles CR, LF
		int 10h
		ret
WrChar		ENDP

WrCharRep	PROC NEAR ; (al=char to write;cx=times) -> ()
		jcxz eWrCharRep
aWrCharRep:	mov ah,0Eh
		mov bx,7
		push cx
		int 10h
		pop cx
		loop aWrCharRep
eWrCharRep:	ret
WrCharRep	ENDP

WrStr		PROC NEAR ; (ds:dx=ASCIIZ string to write) -> ()
		mov bx,7
		mov si,dx
		cld
aWrStr:		lodsb
		cmp al,0
		je eWrStr
		push si
		push bx
		mov ah,0Eh	; teletype output (CR, LF are OK)
		int 10h
		pop bx
		pop si
		jmp short aWrStr
eWrStr:		ret
WrStr		ENDP

SetCursor	PROC NEAR ; (ah=column; al=row) -> ()
		push ax
		mov dh,al
		mov dl,ah
		mov ah,2
		mov bh,0
		int 10h
		pop ax
		ret
SetCursor	ENDP

ClrStatus	PROC NEAR ; () -> ()
		mov ax,0600h	; clears lines 12 down to 24 (last of screen)
		mov bh,7
		mov cx,(StatusLine SHL 8)
		mov dx,184Fh
		int 10h
		mov ax,StatusLine
		jmp SetCursor
ClrStatus	ENDP

WrStatus	PROC NEAR ; (ds:dx=message) -> () cursor is not replaced to its original position
		push dx
		call ClrStatus
		pop dx
		jmp WrStr
WrStatus	ENDP

WrNum		PROC NEAR ; (ax=number to print) -> ()
		mov bx,offset numbuf
		mov word ptr [bx],2020h
		mov word ptr [bx+2],2020h
		mov byte ptr [bx+4],'0'
		add bx,5
		mov cx,10
		mov dl,'0'-'0'
aNum:		dec bx
		or ax,ax
		jz nNum
		xor dx,dx
		div cx
nNum:		push ax
		mov al,dl
		mov dl,' '-'0'
		add al,'0'
		mov [bx],al
		pop ax
		cmp bx,offset numbuf
		jne aNum
		mov dx,bx
		jmp WrStr
numbuf		db 5 dup (' '),0
WrNum		ENDP

ShowGrid	PROC NEAR
		xor ax,ax
		call SetCursor
		mov al,201
		call WrChar
		mov al,205
		mov cx,77
		call WrCharRep
		mov al,187
		call WrChar
		mov al,1
aShowGrid:	push ax
		mov ah,0
		call SetCursor
		mov al,186
		call WrChar
		pop ax
		push ax
		mov ah,39
		call SetCursor
		mov al,179
		call WrChar
		pop ax
		push ax
		mov ah,78
		call SetCursor
		mov al,186
		call WrChar
		pop ax
		inc al
		cmp al,(StatusLine-2)
		jc aShowGrid
		mov ah,0
		call SetCursor
		mov al,200
		call WrChar
		mov al,205
		mov cx,38
		call WrCharRep
		mov al,207
		call WrChar
		mov al,205
		mov cx,38
		call WrCharRep
		mov al,188
		call WrChar
		mov ax,2
		call SetCursor
		mov al,204
		call WrChar
		mov al,205
		mov cx,38
		call WrCharRep
		mov al,209
		call WrChar
		mov al,205
		mov cx,38
		call WrCharRep
		mov al,185
		call WrChar
		mov ax,1401h
		call SetCursor
		mov dx,offset Copyright
		call WrStr
ShowGrid	ENDP

Memory		PROC NEAR ; () -> ()
		mov	al,18h
		out	70h,al
		in	al,71h
		mov	ah,al
		mov	al,17h
		out	70h,al
		in	al,71h
		mov extmem,ax
		int 12h
		mov basemem,ax
		ret
basemem		dw 0
Memory		ENDP

ShowMachine	PROC NEAR ; () -> ()
		call ClrStatus
		mov ax,0203h
		call SetCursor
		mov dx,offset nCPU
		call WrStr
		mov ax,0204h
		call SetCursor
		mov dx,offset nBase
		call WrStr
		mov ax,0205h
		call SetCursor
		mov dx,offset nExtended
		call WrStr
		call Memory
		mov ax,2004h
		call SetCursor
		mov ax,basemem
		call WrNum
		mov al,'K'
		call WrChar
		mov ax,2005h
		call SetCursor
		mov ax,extmem
		mov dx,offset nNone
		or ax,ax
		jz mach1
		call WrNum
		mov al,'K'
		call WrChar
		jmp short mach2
mach1:		call WrStr
mach2:		mov ax,1703h
		call SetCursor
		call CheckCPU
		cmp ax,offset Cpu386
		jc mach3
		cmp word ptr basemem,(MaxMemory SHR 6)
		jc mach4
		cmp word ptr extmem,MinExtended
		jc mach5
		mov ax,StatusLine
		jmp SetCursor
mach3:		mov dx,offset eCpu
Infinite:	push cs
		pop ds
		call WrStatus
		mov dx,offset eReboot
		call WrStr
		sti
infinite:	mov ah,8
		int 21h
		jmp short infinite
mach4:		mov dx,offset eBasMem
		jmp Infinite
mach5:		mov dx,offset eExtMem
		jmp Infinite
ShowMachine	ENDP

WrDev		PROC NEAR ; (ax=dev major/minor) -> ()
		or ax,ax
		jnz wd0
		mov dx,offset nNone
		jmp WrStr
wd0:		cmp ah,2		; floppies
		jne wd1
		push ax
		mov al,' '
		mov cx,3
		call WrCharRep
		mov al,'f'
		call WrChar
		mov al,'d'
		call WrChar
		pop ax
		and al,1
		add al,'0'
		jmp WrChar
wd1:		cmp ah,3		; AT hard disks
		jne wd2
		push ax
		mov al,' '
		mov cx,2
		call WrCharRep
		mov al,'h'
		call WrChar
		mov al,'d'
		call WrChar
		pop ax
		push ax
		mov cl,6
		shr al,cl
		add al,'a'
		call WrChar
		pop ax
		and al,1Fh
		add al,'0'
		jmp WrChar
wd2:		cmp ah,8		; SCSI hard disks
		jne wd3
		push ax
		mov al,' '
		mov cx,2
		call WrCharRep
		mov al,'s'
		call WrChar
		mov al,'d'
		call WrChar
		pop ax
		push ax
		mov cl,4
		shr al,cl
		add al,'a'
		call WrChar
		pop ax
		and al,0Fh
		add al,'0'
		jmp WrChar
wd3:		cmp ah,22
		jne wdunknown
		push ax
		mov al,' '
		mov cx,2
		call WrCharRep
		mov al,'h'
		call WrChar
		mov al,'d'
		call WrChar
		pop ax
		push ax
		mov cl,6
		shr al,cl
		add al,'c'
		call WrChar
		pop ax
		and al,1Fh
		add al,'0'
		jmp WrChar
wdunknown:	; unknown
		mov dx,offset nUnknown
		jmp WrStr

WrDev		ENDP

ShowLinux	PROC NEAR ; () -> ()
		call ClrStatus
		mov ax,2903h
		call SetCursor
		mov dx,offset nSize
		call WrStr
		mov ax,4703h
		call SetCursor
		mov ax,lastToMove
		cmp ax,SetupPage
		jbe sl1
		sub ax,PageSegInc
sl1:		sub ax,pageToMove
		mov klen,ax
		mov cl,6
		shr ax,cl
		call WrNum
		mov al,'K'
		call WrChar
		mov ax,2904h
		call SetCursor
		mov dx,offset nRootDev
		call WrStr
		mov ax,2905h
		call SetCursor
		mov dx,offset nVideo
		call WrStr
;		mov ax,2906h
;		call SetCursor
;		mov dx,offset nSwapDev
;		call WrStr
		mov ax,2906h
;		mov ax,2907h
		call SetCursor
		mov dx,offset nRamDisk
		call WrStr
		push es
		mov ax,BootLoad
		mov es,ax
		mov ax,4704h
		call SetCursor
		mov ax,word ptr es:[200h-bsoRootDev]
		call WrDev
;		mov ax,4706h
;		call SetCursor
;		mov ax,word ptr es:[200h-bsoSwapDev]
;		call WrDev
		mov ax,4706h
;		mov ax,4707h
		call SetCursor
		mov ax,word ptr es:[200h-bsoRamDiskSize]
		mov dx,offset nNone
		or ax,ax
		jz sl2
		call WrNum
		mov al,'K'
		call WrChar
		jmp short sl3
sl2:		call WrStr
sl3:		mov ax,4805h
		call SetCursor
		mov ax,word ptr es:[200h-bsoVideo]
		pop es
		cmp ax,VideoVGA
		jne sl4
		mov dx,offset n80x25
		jmp WrStr
sl4:		cmp ax,VideoVGAext
		jne sl5
		mov dx,offset n80x50
		jmp WrStr
sl5:		cmp ax,VideoASK
		jne sl6
		mov dx,offset nAsk
		jmp WrStr
sl6:		cmp ax,10
		jae sl7
		push ax
		mov dx,offset nSVGA
		call WrStr
		pop ax
		add al,'0'
		jmp WrChar
sl7:		mov dx,offset nUnknownSp
		jmp WrStr
klen		dw 0
ShowLinux	ENDP

UpdateBoot	PROC NEAR ; () -> ()
		push es
		mov ax,BootLoad
		mov es,ax
		mov ax,rootdevice
		or ax,ax
		jz ub1
		mov word ptr es:[200h-bsoRootDev],ax
ub1:;		mov ax,swapdevice
;		or ax,ax
;		jz ub2
;		mov word ptr es:[200h-bsoSwapDev],ax
ub2:		mov ax,videomode
		cmp ax,VideoUnspec
		je ub3
		mov word ptr es:[200h-bsoVideo],ax
ub3:		mov ax,ramdisksize
		or ax,ax
		jz ub4
		mov word ptr es:[200h-bsoRamDiskSize],ax
ub4:		mov ax,cmdline
		or ax,ax
		jz ub5
		mov word ptr es:[200h-bsoCmdLineOfs],ax
		mov word ptr es:[200h-bsoCmdLineFlag],CmdLineFlag
ub5:		pop es
		ret
UpdateBoot	ENDP

CheckBootDev	PROC NEAR
		push es
		mov ax,BootLoad
		mov es,ax
		mov bx,200h-bsoRootDev
		cmp word ptr es:[bx],0
		jnz cbd1
		push es
		push bx
		call GetRootDevice
		pop bx
		pop es
		mov word ptr es:[bx],ax
		call ShowLinux
cbd1:		pop es
		ret
CheckBootDev	ENDP

TheStart	PROC NEAR
		call InitScr
		call ShowGrid
		call ShowMachine

		mov bx,offset TheEnd
		add bx,PlusSize		; compute start of the new stack

		cli
		push cs
		pop ss
		mov sp,bx
		sti			; sets the new stack

		mov cl,4
		dec bx
		shr bx,cl
		inc bx
		mov ax,ss
		add ax,bx		; compute the segment after the stack
		mov si,KernelStart
		cmp ax,si
		jae ts1
		mov ax,si
ts1:		mov pageToMove,ax	; save it, this may be the load addr

		push ax
		call ParseOptions
		pop ax
		push ax
		call ReadLinux
		mov lastToMove,ax
		call UpdateBoot
		call ShowLinux
		mov dx,offset e512
		cmp word ptr klen,8000h
		ja ts1a
		call CheckBootDev
		call CheckCmdLine
		mov dx,offset mEmpty
		call WrStatus
		mov cx,waitLaunch
		cmp byte ptr launchWait,0
		je ts2
		mov dx,offset mLaunch
		call WrStatus
		mov ah,8
		int 21h
		xor cx,cx
ts2:		call BiosWait
		call InitScr
		pop ax

		cmp ax,KernelStart	; and check it doesn't overlap
		ja moreComplicated

		mov ax,3515h
		int 21h
		mov word ptr oldint15,bx
		mov word ptr [oldint15+2],es
		mov dx,offset NewInt15
		mov ax,2515h
		int 21h
		jmp short RunLinux
		
ts1a:		jmp Infinite

moreComplicated:
		int 11h
		mov equip,ax
		mov ax,3513h
		int 21h
		mov word ptr oldint,bx
		mov word ptr [oldint+2],es
		mov ax,3515h
		int 21h
		mov word ptr oldint15,bx
		mov word ptr [oldint15+2],es
		mov si,cs
		mov di,BootlinPage
		push ds
		push di
		call MovePage
		pop ds
		mov dx,offset NewInt11
		mov ax,2511h
		int 21h
		mov dx,offset NewInt13
		mov ax,2513h
		int 21h
		mov dx,offset NewInt15
		mov ax,2515h
		int 21h
		pop ds

RunLinux:
		cli
		mov bx,SetupPage
		mov ds,bx
		mov es,bx
		mov ss,bx
		mov sp,SetupStack	; the setup stack ; no space for
		sti			; disk param table, because no need

		mov bx,SetupLoad 	; here I made a mistake last time
		push bx
		xor bx,bx
		push bx
		retf
TheStart	ENDP

		ASSUME cs:MainSeg, ds:MainSeg, es:MainSeg
ReadLinux	PROC NEAR ; (ax=page where to start loading) -> (ax=just after the last page loaded)
		push ax
TryAgain:
		mov ax,03d00h		; tries to open the specified file
		mov dx,offset filename	; in READ-ONLY mode
		int 21h
		jnc OpenIsOk

		mov dx,offset mFile	; fail: print error msg and
		call WrStatus
		call AskLineBuff	; asks for another file name
		jmp short TryAgain	; and try again until it succeeds

OpenIsOk:	mov filehandle,ax	; save file handle

		mov dx,offset mBoot	; bootsect load message
		call WrStatus

		mov di,BootLoad		; target:= 9000:0
		mov cx,BootLength	; size:= 1 sector = 512 bytes
		call sectread		; reads boot sector
		jne Image		; fail => bad length

		call bootcheck		; checks for 0AA55h at the end
		jne BootError

		mov dx,offset mSetup	; setup load message
		call WrStr

		mov di,SetupLoad	; target:= 9000:200
; This is no more true since linux v1.1: the number of setup sectors
; to load is now indicated in the boot sector, offset 497
; (named here bsoSetupSectors)
;
;		mov cx,SetupLength	; size:= 4 sectors = 2K
;
; Replaced with a definition check at this offset, embedded in a call
		call setSetupLength	; preserves di
		call sectread		; reads setup
		jne Image		; fail => bad length

		mov dx,offset mKernel	; kernel load message
		call WrStr

		pop di			; start kernel loading at ????:0
		mov cx,PageLength	; read it by pages

kernrd:
		cmp di,SetupPage
		jne rl1
		add di,SetupSpaceInc	; oh oh, there was a bug here (was PageSegInc)
		jmp short readpage
rl1:		cmp di,BootlinPage
		jne readpage
		mov dx,offset eBig
		jmp Infinite
readpage:

		call sectread		; reads the page

		pushf			; save useful flags
		add di,PageSegInc	; next page
		push cx
		push di
		mov cl,(PageOrder-4)
		shr di,cl
		and di,((1 SHL (DotOrder-PageOrder))-1)
		jnz rl2
		mov al,'.'		; print one dot
		call WrChar
rl2:		pop di
		pop cx
		popf			; and restore flags (Z interesting)

		jnz close		; if the whole page has been read,
					; continue, else close file
		jmp short kernrd

BootError:
		mov dx,offset eBoot
		jmp Infinite

Image:		mov dx,offset eShort
		jmp Infinite

close:		push di
		mov ah,3eh
		mov bx,filehandle
		int 21h			; otherwise, close the file

		mov dx,offset mDone	; done message
		call WrStr

		mov cx,waitLoaded
		call BiosWait

		pop ax
		ret
ReadLinux	ENDP

		ASSUME ds:MainSeg
sectread	PROC NEAR		; tries to read cx bytes at di:0
		push ds			; returns ZF set if all bytes read
		push bx
		push cx
		mov bx,word ptr filehandle
		mov ds,di
		xor dx,dx
		mov ah,03fh
		int 21h
		mov di,ds
		pop cx
		pop bx
		pop ds
		jc dumbError
		cmp ax,cx
		ret
dumbError:	mov dx,offset eRead
		jmp Infinite
sectread	ENDP

		ASSUME ds:NOTHING
bootcheck	PROC NEAR
		push ds
		mov ax,BootLoad
		mov ds,ax
		mov ax,word ptr ds:[200h-bsoBootFlag]
		pop ds
		cmp ax,BootFlag
		ret
bootcheck	ENDP

setSetupLength	PROC NEAR
		push di
		push ds
		mov ax,BootLoad
		mov ds,ax
		mov al,byte ptr ds:[200h-bsoSetupSectors]
		mov di,SetupLength	; This is the default value
		cmp al,4		; n<4 is not surely not valid
		jc dftSetupLength
		cmp al,SetupSpaceSect-1-((StackLength+CmdLineLength+1FFh) SHR 9)
		; setup space (?) - boot sector (1) - setup stack (2) - cmdline (1)
		ja dftSetupLength	; will this be enough ?!
		xor ah,ah
		mov cl,9		; multiply by 512 to have the real size
		shl ax,cl
		mov di,ax
dftSetupLength:	mov cx,di
		pop ds
		pop di
		ret
setSetupLength	ENDP

		ASSUME ds:MainSeg
AskLineBuff	PROC NEAR
		mov bx,cs:linebuff
		push bx
		xor cx,cx
checkEnd:	cmp byte ptr [bx],0
		je proceed
		cmp cx,FileNameSize-1
		je proceed
		inc cx
		inc bx
		jmp short checkEnd
proceed:	mov byte ptr [bx],'$'
		pop dx
		mov ah,9
int21call:	push bx
		push cx
		int 21h
		pop cx
		pop bx
input:		call Inkey
		cmp ax,127
		jae input
		cmp ax,8
		je backspace
		cmp ax,13
		je return
		cmp ax,31
		jbe input
		cmp cx,FileNameSize-1
		jae beep
		mov byte ptr [bx],al
		inc bx
		inc cx
		mov dl,al
prchar:		mov ah,2
		jmp short int21call
beep:		mov dl,7
		jmp short prchar
backspace:	jcxz beep
		dec bx
		dec cx
		push bx
		push cx
		mov ah,2
		mov dl,8
		int 21h
		mov dl,' '
		int 21h
		pop cx
		pop bx
		mov dl,8
		jmp short prchar
return:		mov byte ptr [bx],0
		mov dx,offset SomeCrLfs
		jmp WrStr
AskLineBuff	ENDP

Inkey		PROC NEAR
		push bx
		push cx
		mov ah,7
		int 21h
		mov ah,0
		cmp al,0
		jne endkey
		mov ah,0bh
		int 21h
		mov ah,0
		cmp al,0
		je endkey
		mov ah,7
		int 21h
		mov ah,1
endkey:		pop cx
		pop bx
		ret
Inkey		ENDP

ParseArgs	PROC NEAR
		mov si,0080h
		cld
		lodsb
		xor ch,ch
		mov cl,al
		mov di,offset argv
		xor dx,dx
pa0:		jcxz paEnd
pa1:		lodsb
		cmp al,' '
		loope pa1		
		je paEnd
		dec si
		inc cx
		mov ax,si
		stosw
		inc dx
pa2:		lodsb
		cmp al,'a'
		jb pa2a
		cmp al,'z'
		ja pa2a
		add al,('A'-'a')
		mov byte ptr [si-1],al
pa2a:		cmp al,' '
		loopne pa2
		jcxz paEnd
		mov byte ptr [si-1],0
		jmp short pa1
paEnd:		mov byte ptr [si],0
		mov argc,dx
		ret
ParseArgs	ENDP

ParseOptions	PROC NEAR
		call ParseArgs
		cld
		mov si,offset argv
		mov cx,argc
		jmp short po1
po0:		ret
po0a:		mov dx,offset eMissing
po0b:		jmp Infinite
po1:		jcxz po0
		lodsw
		dec cx
		mov bx,ax
		cmp byte ptr [bx],'-'
		je po3
		; parse filename
		push si
		mov si,bx
		mov di,offset filename
po2:		lodsb
		stosb
		cmp al,0
		jne po2
		pop si
		jmp short po1

po3z:		jmp po4

po3:		; parse options
		mov al,[bx+1]
		cmp al,'R'
		jne po3z
		; -Root {hd[ab][1-9],sd[a-f][1-8],fd[01]}
		jcxz po0a
		lodsw
		dec cx
		mov bx,si
		mov si,ax
		call parsedev
		mov si,bx
		mov rootdevice,di
		jmp short po1
parsedev:	mov dx,offset eRootOpt
		lodsb
		cmp al,'F'
		jne po3a
		; floppies
		mov di,0200h ; 2 is floppies dev's major
		lodsb
		cmp al,'D'
		jne po0b
		lodsb
		sub al,'0'
		cmp al,2
		jae po0b
		xor ah,ah
		add di,ax
		lodsb
		cmp al,0
		jne po0b
		ret

po3a:		cmp al,'H'
		jne po3b
		; hard disks
		mov di,0300h ; 3 is hard disks dev's major
		lodsb
		cmp al,'D'
		jne po0b
		lodsb
		sub al,'A'
		cmp al,4	; max number of units
		jae po0b
		cmp al,2	; if 'C' or 'D', then
		jb po3aa	; secondary i/f: maj=22
		mov di,1600h
		sub al,2
po3aa:		push cx
		mov cl,6
		shl al,cl
		pop cx
		xor ah,ah
		add di,ax
		lodsb
		sub al,'1'
		cmp al,9
		jae po0B
		inc al
		add di,ax
		lodsb
		cmp al,0
		jne po0B
		ret

po3b:		cmp al,'S'
		jne po0B
		; scsi disks
		mov di,0800h ; 8 is scsi disks dev's major
		lodsb
		cmp al,'D'
		jne po0B
		lodsb
		sub al,'A'
		cmp al,6
		jae po0B
		push cx
		mov cl,4
		shl al,cl
		pop cx
		xor ah,ah
		add di,ax
		lodsb
		sub al,'1'
		cmp al,8
		jae po0B
		inc al
		add di,ax
		lodsb
		cmp al,0
		jne po0B
		ret

po0A:		mov dx,offset eMissing
po0B:		jmp Infinite

po4:;		cmp al,'S'
;		jne po5
;		; -Swap ... (idem -Root)
;		jcxz po0A
;		lodsw
;		dec cx
;		mov bx,si
;		mov si,ax
;		call parsedev
;		mov si,bx
;		mov swapdevice,di
;		jmp po1

po5:		cmp al,'D'
		jne po6
		; -Disk n is ram disk size
		jcxz po0A
		lodsw
		dec cx
		mov bx,si
		mov si,ax
		mov dx,offset eDiskOpt
		call parsenum
		mov ramdisksize,di
		mov si,bx
		jmp po1
parsenum:	xor di,di
po5a:		lodsb
		cmp al,0
		je po5b
		sub al,'0'
		cmp al,10
		jae po0B
		push ax
		mov ax,di
		mov ch,10
		mul ch
		xor ch,ch
		mov di,ax
		pop ax
		xor ah,ah
		add di,ax
		jmp short po5a
po5b:		ret

po6:		cmp al,'W'
		jne po8
		mov byte ptr launchWait,1
		jmp po1
		
po8:		cmp al,'E'
		jne po9
		mov byte ptr editCmdLine,1
		mov bx,CmdLineOfs
		mov cmdline,bx
		push ds
		mov ax,SetupPage
		mov ds,ax
		mov byte ptr [bx],0
		pop ds
		jmp po1

po9:		cmp al,'-'
		jne po7
		cmp byte ptr [bx+2],0
		jne po7
		jmp po9a

po7:		mov dx,offset eUnknown
		cmp al,'V'
		jne po0B
		; -Video 80*25 or 80*50 or SVGA[1-9] or ASK
		jcxz po0A
		lodsw
		dec cx
		mov bx,si
		mov si,ax
		mov dx,offset eVideoOpt
		push cx
		mov ax,VideoVGA
		mov cx,3
		mov di,offset n80x25
		push si
		repe cmpsw
		pop si
		je po6a
		mov ax,VideoVGAext
		mov cx,3
		mov di,offset n80x50
		push si
		repe cmpsw
		pop si
		je po6a
		mov ax,VideoASK
		mov cx,2
		mov di,2+offset nAsk
		push si
		repe cmpsw
		pop si
		je po6a
		xor ax,ax
		mov cx,2
		mov di,offset nSVGA
		repe cmpsw
		jne po6B
		lodsb
		sub al,'1'
		cmp al,9
		jae po6B
		push ax
		lodsb
		or al,al
		pop ax
		jnz po6B
		inc ax
po6a:		pop cx
		mov si,bx
		mov videomode,ax
		jmp po1
po6B:		jmp Infinite

po9a:		; the rest is linux-kernel command line
		push es
		mov ax,SetupPage
		mov es,ax
		mov di,CmdLineOfs
		mov cmdline,di
		cld
		jcxz po9f
po9b:		lodsw
		dec cx
		mov bx,ax
po9c:		mov al,[bx]
		cmp al,0
		je po9d
		cmp al,'A'
		jb po9e
		cmp al,'Z'
		ja po9e
		add al,'a'-'A'
po9e:		stosb
		inc bx
		jmp po9c
po9d:		jcxz po9f
		mov al,' '
		stosb
		jmp po9b
po9f:		mov al,0
		stosb
		pop es
		ret
ParseOptions	ENDP
		
GetRootDevice	PROC NEAR
		push ds
		push es
		mov ax,cs
		mov ds,ax
		mov es,ax
		cld
		mov si,defaultRoot
		mov di,offset filename
cpyRootDft:	lodsb
		stosb
		cmp al,0
		jne cpyRootDft
AskRoot:	mov dx,offset mRoot
		call WrStatus
		call AskLineBuff
		mov si,offset filename
		mov di,si
		push si
upcRootDev:	lodsb
		cmp al,'a'
		jc noUpcRootDev
		cmp al,'z'
		ja noUpcRootDev
		add al,('A'-'a')
noUpcRootDev:	stosb
		cmp al,0
		jne upcRootDev
		pop si
		call parsedev
		mov ax,di
		pop es
		pop ds
		ret
GetRootDevice	ENDP

CheckCPU	PROC NEAR ; () -> (ax=message addr)
		pushf
		mov dx,offset Cpu86
		xor ax,ax
		push ax
		popf
		pushf
		pop ax
		and ax,0F000h
		cmp ax,0F000h
		je cpuend	; 8086
		mov dx,offset Cpu286
		mov ax,0F000h
		push ax
		popf
		pushf
		pop ax
		and ax,0F000h
		jz cpuend	; 80286
		mov dx,offset Cpu386
cpuend:		popf
		push dx
		call WrStr
		pop ax
		ret
CheckCPU	ENDP

CheckCmdLine	PROC NEAR
		cmp byte ptr [editCmdLine],0
		jz cclEnd
		mov dx,offset mCmdLine
		call WrStatus

		mov ax,cmdline
		mov linebuff,ax
		push ds
		mov ax,SetupPage
		mov ds,ax
		call AskLineBuff
		pop ds

cclEnd:		ret
CheckCmdLine	ENDP


Copyright	db "BOOTLINUX v"
		db BootlinVersion
		db " (C) 1992-1995 F.COUTANT",0
nCPU		db "Processor",0
nBase		db "Conventional Memory",0
nExtended	db "Extended Memory",0
nSize		db "Linux kernel size",0
nRootDev	db "Root FS device",0
nVideo		db "Startup Video Mode",0
;nSwapDev	db "Swap device",0
nRamDisk	db "Ram Disk Size",0
Cpu86		db "           8086",0
Cpu286		db "    80186/80286",0
Cpu386		db "80386 or higher",0
nNone		db "(none)",0
nUnknownSp	db " "
nUnknown	db " (?)",0
n80x25		db "80*25",0
n80x50		db "80*50",0
nAsk		db "  ASK",0
nSVGA		db "SVGA",0
mFile		db "Could not open Image file. Please enter new file name"
		db 13,10,"or press Ctrl-Alt-Del to reboot:",13,10,10,0
mBoot		db "BootSector: ... ",0
mSetup		db "done",13,10,"Setup: ... ",0
mKernel		db "done",13,10,"Kernel: ",0
mDone		db " done",13,10,10,0
mRoot		db 10,"Root device is not defined. Please choose one of: ",13,10,10
		db "    FD[0-1]         floppies",13,10
		db "    HD[A-D][1-9]    AT hard disks partitions",13,10
		db "                    ([1-4] are BIOS, [5-9] are DOS-extended)",13,10
		db "    SD[A-F][1-8]    SCSI hard disks partitions",13,10
		db 10,"root device -> ",0
mCmdLine	db "Please edit here the Linux kernel command line parameters:",13,10,10,0
mLaunch		db "About to launch Linux. Press a key to proceed...",0
SomeCrLfs	db 10		; this line and the following should be
mEmpty		db 13,10,0	; together and in this order
eBoot		db "file is not a LINUX BOOT-DISK IMAGE !",13,10,0
eCpu		db "Linux requires a 80386 or higher to run.",13,10,0
eBasMem		db "640K base memory is required to load Linux Kernel.",13,10,0
eExtMem		db "A minimum of 2M total memory is required to run Linux.",13,10
		db "(4M is preferred for normal use, 8M if using X11)",13,10,0
eShort		db "file is too short to be a correct image",13,10,0
eRead		db " (read error)",13,10,0
eBig		db " not enough memory to load the kernel.",13,10
		db "Run BootLinux with less residents or build a compressed kernel.",13,10,0
e512		db "Kernel is more than 512K, so it will never load correctly.",13,10
		db "You have to build an auto-uncompressing kernel.",13,10,0
eMissing	db "missing argument for an option",13,10,0
eUnknown	db "unknown option. Recognized options are (case insensitive):",13,10
		db "    -R*    <root device>",13,10
;		db "    -S*    <swap device>",13,10
		db "    -D*    <ramdisksizeK>",13,10
		db "    -V*    80*25 or 80*50 or SVGA[1-9] or ASK",13,10
		db "    -E*    edit the kernel command line",13,10
		db "    -W*    waits for a key before lauching Linux",13,10
		db "    -- ... everything after '--' gives the command line",13,10,0
eRootOpt	db "option -Root expects 'HD[A-D][1-9]', 'SD[A-F][1-8]' or 'FD[01]' as argument",13,10,0
eDiskOpt	db "option -Disk expects a numeric size in K as argument",13,10,0
eVideoOpt	db "option -Video expects '80*25' or '80*50' or 'SVGA[1-9]' or 'ASK' as argument",13,10,0
eReboot		db 10,"I can't do anything now.",13,10
		db "Please press Ctrl-Alt-Del to reboot...",13,10,10
		db "NB: if you ran BOOTLIN from the DOS command line,",13,10
		db "    you can also press Ctrl-Break here and you will",13,10
		db "    return to the DOS prompt.",13,10,10,0

defaultRoot	dw defaultRootTxt
defaultRootTxt	db "fd0",0

videomode	dw VideoUnspec
rootdevice	dw 0
swapdevice	dw 0
ramdisksize	dw 0

launchWait	db 0
editCmdLine	db 0

argc		dw 0
argv		dw 32 dup (0)
linebuff	dw filename
cmdline		dw 0

filehandle	dw 0
filename	db 0

TheEnd		LABEL BYTE

MainSeg		ENDS


		END MainSeg:JumpStart

