package net.sourceforge.ganttproject.importer;

import java.io.File;
import java.io.IOException;

import net.sourceforge.ganttproject.GanttProject;
import net.sourceforge.ganttproject.document.Document;
import net.sourceforge.ganttproject.document.FileDocument;
import net.sourceforge.ganttproject.gui.GanttDialogInfo;
import net.sourceforge.ganttproject.io.GanttXMLOpen;
import net.sourceforge.ganttproject.parser.AllocationTagHandler;
import net.sourceforge.ganttproject.parser.DependencyTagHandler;
import net.sourceforge.ganttproject.parser.ResourceTagHandler;
import net.sourceforge.ganttproject.resource.ResourceManager;
import net.sourceforge.ganttproject.roles.RoleManager;

public class ImporterFromGanttFile extends ImporterBase implements Importer {

    public void run(GanttProject project, File selectedFile) {
        if (acceptImport(project)) {
            Document document = getDocument(selectedFile);
            openDocument(project, document);
        }

    }

    protected Document getDocument(File selectedFile) {
    	return new FileDocument(selectedFile);
    }
    
    protected void openDocument(GanttProject project, Document document) {
        try 
        {
            GanttXMLOpen opener = new GanttXMLOpen(project.getTree(), project,
                project.getResourcePanel(), project.getArea(), project.getTaskManager(),true);
            opener.addTagHandler(opener.getDefaultTagHandler());
            //opener.addTagHandler(resourceHandler);
            //opener.addTagHandler(dependencyHandler);
            //opener.addTagHandler(allocationHandler);
            //opener.addParsingListener(dependencyHandler);
            opener.load(document.getInputStream());
        } catch (IOException e)
        {
            GanttDialogInfo gdi = new GanttDialogInfo(project,
                    GanttDialogInfo.ERROR, GanttDialogInfo.YES_OPTION,
                    project.getLanguage().getText("msg2") + "\n"
                            + document.getDescription(), project.getLanguage()
                            .getText("error"));
            gdi.show();
        }
        
    	
    }
}
