package net.sourceforge.ganttproject.document;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class TransformingDocument extends FileDocument {

    private final Transformer myTransformer;

    public TransformingDocument(File file, Transformer transformer) {
        super(file);
        myTransformer = transformer;
    }

    public InputStream getInputStream() throws IOException {
        InputStream fileStream = super.getInputStream();
        StreamSource source = new StreamSource(fileStream);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(outputStream);
        try {
			myTransformer.transform(source, result);
		} catch (TransformerException e) {
			e.printStackTrace();
			throw new IOException("TransformException has occured when running a transformer="+myTransformer+":\n"+e.getMessageAndLocation());
		}
        return new ByteArrayInputStream(outputStream.toByteArray());
    }

    public OutputStream getOutputStream() throws IOException {
        // TODO Auto-generated method stub
        return null;
    }


}
