/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.script.rhino;

import org.apache.batik.script.rhino.RhinoClassLoader;
import org.apache.batik.util.BatikSecurityManager;
import org.mozilla.javascript.SecuritySupport;

public class BatikSecuritySupport
implements SecuritySupport {
    public Class defineClass(String name, byte[] data, Object securityDomain) {
        RhinoClassLoader rcl = (RhinoClassLoader)securityDomain;
        return rcl.defineClass(name, data);
    }

    public Class[] getClassContext() {
        Class[] cc;
        SecurityManager sm = System.getSecurityManager();
        if (sm == null || !(sm instanceof BatikSecurityManager)) {
            return null;
        }
        BatikSecurityManager bsm = (BatikSecurityManager)sm;
        Class[] result = cc = bsm.getClassContext();
        if (cc != null && cc.length > 0) {
            result = new Class[cc.length - 1];
            System.arraycopy(cc, 1, result, 0, cc.length - 1);
        }
        return result;
    }

    public Object getSecurityDomain(Class cl) {
        return cl.getClassLoader();
    }

    public boolean visibleToScripts(String fullClassName) {
        return true;
    }
}

