/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import java.net.URL;
import java.util.Locale;
import java.util.MissingResourceException;
import org.apache.batik.css.dom.CSSOMSVGViewCSS;
import org.apache.batik.css.engine.CSSContext;
import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.SVGCSSEngine;
import org.apache.batik.css.parser.ExtendedParser;
import org.apache.batik.css.parser.ExtendedParserWrapper;
import org.apache.batik.dom.AbstractDOMImplementation;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.GenericElement;
import org.apache.batik.dom.GenericElementNS;
import org.apache.batik.dom.StyleSheetFactory;
import org.apache.batik.dom.events.DocumentEventSupport;
import org.apache.batik.dom.svg.SVGOMAElement;
import org.apache.batik.dom.svg.SVGOMAltGlyphDefElement;
import org.apache.batik.dom.svg.SVGOMAltGlyphElement;
import org.apache.batik.dom.svg.SVGOMAltGlyphItemElement;
import org.apache.batik.dom.svg.SVGOMAnimateColorElement;
import org.apache.batik.dom.svg.SVGOMAnimateElement;
import org.apache.batik.dom.svg.SVGOMAnimateMotionElement;
import org.apache.batik.dom.svg.SVGOMAnimateTransformElement;
import org.apache.batik.dom.svg.SVGOMCircleElement;
import org.apache.batik.dom.svg.SVGOMClipPathElement;
import org.apache.batik.dom.svg.SVGOMColorProfileElement;
import org.apache.batik.dom.svg.SVGOMCursorElement;
import org.apache.batik.dom.svg.SVGOMDefinitionSrcElement;
import org.apache.batik.dom.svg.SVGOMDefsElement;
import org.apache.batik.dom.svg.SVGOMDescElement;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.svg.SVGOMEllipseElement;
import org.apache.batik.dom.svg.SVGOMEvent;
import org.apache.batik.dom.svg.SVGOMFEBlendElement;
import org.apache.batik.dom.svg.SVGOMFEColorMatrixElement;
import org.apache.batik.dom.svg.SVGOMFEComponentTransferElement;
import org.apache.batik.dom.svg.SVGOMFECompositeElement;
import org.apache.batik.dom.svg.SVGOMFEConvolveMatrixElement;
import org.apache.batik.dom.svg.SVGOMFEDiffuseLightingElement;
import org.apache.batik.dom.svg.SVGOMFEDisplacementMapElement;
import org.apache.batik.dom.svg.SVGOMFEDistantLightElement;
import org.apache.batik.dom.svg.SVGOMFEFloodElement;
import org.apache.batik.dom.svg.SVGOMFEFuncAElement;
import org.apache.batik.dom.svg.SVGOMFEFuncBElement;
import org.apache.batik.dom.svg.SVGOMFEFuncGElement;
import org.apache.batik.dom.svg.SVGOMFEFuncRElement;
import org.apache.batik.dom.svg.SVGOMFEGaussianBlurElement;
import org.apache.batik.dom.svg.SVGOMFEImageElement;
import org.apache.batik.dom.svg.SVGOMFEMergeElement;
import org.apache.batik.dom.svg.SVGOMFEMergeNodeElement;
import org.apache.batik.dom.svg.SVGOMFEMorphologyElement;
import org.apache.batik.dom.svg.SVGOMFEOffsetElement;
import org.apache.batik.dom.svg.SVGOMFEPointLightElement;
import org.apache.batik.dom.svg.SVGOMFESpecularLightingElement;
import org.apache.batik.dom.svg.SVGOMFESpotLightElement;
import org.apache.batik.dom.svg.SVGOMFETileElement;
import org.apache.batik.dom.svg.SVGOMFETurbulenceElement;
import org.apache.batik.dom.svg.SVGOMFilterElement;
import org.apache.batik.dom.svg.SVGOMFontElement;
import org.apache.batik.dom.svg.SVGOMFontFaceElement;
import org.apache.batik.dom.svg.SVGOMFontFaceFormatElement;
import org.apache.batik.dom.svg.SVGOMFontFaceNameElement;
import org.apache.batik.dom.svg.SVGOMFontFaceSrcElement;
import org.apache.batik.dom.svg.SVGOMFontFaceUriElement;
import org.apache.batik.dom.svg.SVGOMForeignObjectElement;
import org.apache.batik.dom.svg.SVGOMGElement;
import org.apache.batik.dom.svg.SVGOMGlyphElement;
import org.apache.batik.dom.svg.SVGOMGlyphRefElement;
import org.apache.batik.dom.svg.SVGOMHKernElement;
import org.apache.batik.dom.svg.SVGOMImageElement;
import org.apache.batik.dom.svg.SVGOMLineElement;
import org.apache.batik.dom.svg.SVGOMLinearGradientElement;
import org.apache.batik.dom.svg.SVGOMMPathElement;
import org.apache.batik.dom.svg.SVGOMMarkerElement;
import org.apache.batik.dom.svg.SVGOMMaskElement;
import org.apache.batik.dom.svg.SVGOMMetadataElement;
import org.apache.batik.dom.svg.SVGOMMissingGlyphElement;
import org.apache.batik.dom.svg.SVGOMPathElement;
import org.apache.batik.dom.svg.SVGOMPatternElement;
import org.apache.batik.dom.svg.SVGOMPolygonElement;
import org.apache.batik.dom.svg.SVGOMPolylineElement;
import org.apache.batik.dom.svg.SVGOMRadialGradientElement;
import org.apache.batik.dom.svg.SVGOMRectElement;
import org.apache.batik.dom.svg.SVGOMSVGElement;
import org.apache.batik.dom.svg.SVGOMScriptElement;
import org.apache.batik.dom.svg.SVGOMSetElement;
import org.apache.batik.dom.svg.SVGOMStopElement;
import org.apache.batik.dom.svg.SVGOMStyleElement;
import org.apache.batik.dom.svg.SVGOMSwitchElement;
import org.apache.batik.dom.svg.SVGOMSymbolElement;
import org.apache.batik.dom.svg.SVGOMTRefElement;
import org.apache.batik.dom.svg.SVGOMTSpanElement;
import org.apache.batik.dom.svg.SVGOMTextElement;
import org.apache.batik.dom.svg.SVGOMTextPathElement;
import org.apache.batik.dom.svg.SVGOMTitleElement;
import org.apache.batik.dom.svg.SVGOMUseElement;
import org.apache.batik.dom.svg.SVGOMVKernElement;
import org.apache.batik.dom.svg.SVGOMViewElement;
import org.apache.batik.dom.util.CSSStyleDeclarationFactory;
import org.apache.batik.dom.util.DOMUtilities;
import org.apache.batik.dom.util.HashTable;
import org.apache.batik.i18n.Localizable;
import org.apache.batik.i18n.LocalizableSupport;
import org.apache.batik.util.SVGConstants;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.Parser;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.css.DOMImplementationCSS;
import org.w3c.dom.css.ViewCSS;
import org.w3c.dom.events.Event;
import org.w3c.dom.stylesheets.StyleSheet;

public class SVGDOMImplementation
extends AbstractDOMImplementation
implements Localizable,
DOMImplementationCSS,
CSSStyleDeclarationFactory,
StyleSheetFactory,
SVGConstants {
    public static final String SVG_NAMESPACE_URI = "http://www.w3.org/2000/svg";
    protected static final DOMImplementation DOM_IMPLEMENTATION;
    protected static final String RESOURCES = "org.apache.batik.dom.svg.resources.Messages";
    protected LocalizableSupport localizableSupport = new LocalizableSupport("org.apache.batik.dom.svg.resources.Messages");
    protected HashTable factories = new HashTable();

    public static DOMImplementation getDOMImplementation() {
        return DOM_IMPLEMENTATION;
    }

    public SVGDOMImplementation() {
        this.factories.put("a", new AElementFactory());
        this.factories.put("altGlyph", new AltGlyphElementFactory());
        this.factories.put("altGlyphDef", new AltGlyphDefElementFactory());
        this.factories.put("altGlyphItem", new AltGlyphItemElementFactory());
        this.factories.put("animate", new AnimateElementFactory());
        this.factories.put("animateColor", new AnimateColorElementFactory());
        this.factories.put("animateMotion", new AnimateMotionElementFactory());
        this.factories.put("animateTransform", new AnimateTransformElementFactory());
        this.factories.put("circle", new CircleElementFactory());
        this.factories.put("clipPath", new ClipPathElementFactory());
        this.factories.put("color-profile", new ColorProfileElementFactory());
        this.factories.put("cursor", new CursorElementFactory());
        this.factories.put("definition-src", new DefinitionSrcElementFactory());
        this.factories.put("defs", new DefsElementFactory());
        this.factories.put("desc", new DescElementFactory());
        this.factories.put("ellipse", new EllipseElementFactory());
        this.factories.put("feBlend", new FeBlendElementFactory());
        this.factories.put("feColorMatrix", new FeColorMatrixElementFactory());
        this.factories.put("feComponentTransfer", new FeComponentTransferElementFactory());
        this.factories.put("feComposite", new FeCompositeElementFactory());
        this.factories.put("feConvolveMatrix", new FeConvolveMatrixElementFactory());
        this.factories.put("feDiffuseLighting", new FeDiffuseLightingElementFactory());
        this.factories.put("feDisplacementMap", new FeDisplacementMapElementFactory());
        this.factories.put("feDistantLight", new FeDistantLightElementFactory());
        this.factories.put("feFlood", new FeFloodElementFactory());
        this.factories.put("feFuncA", new FeFuncAElementFactory());
        this.factories.put("feFuncR", new FeFuncRElementFactory());
        this.factories.put("feFuncG", new FeFuncGElementFactory());
        this.factories.put("feFuncB", new FeFuncBElementFactory());
        this.factories.put("feGaussianBlur", new FeGaussianBlurElementFactory());
        this.factories.put("feImage", new FeImageElementFactory());
        this.factories.put("feMerge", new FeMergeElementFactory());
        this.factories.put("feMergeNode", new FeMergeNodeElementFactory());
        this.factories.put("feMorphology", new FeMorphologyElementFactory());
        this.factories.put("feOffset", new FeOffsetElementFactory());
        this.factories.put("fePointLight", new FePointLightElementFactory());
        this.factories.put("feSpecularLighting", new FeSpecularLightingElementFactory());
        this.factories.put("feSpotLight", new FeSpotLightElementFactory());
        this.factories.put("feTile", new FeTileElementFactory());
        this.factories.put("feTurbulence", new FeTurbulenceElementFactory());
        this.factories.put("filter", new FilterElementFactory());
        this.factories.put("font", new FontElementFactory());
        this.factories.put("font-face", new FontFaceElementFactory());
        this.factories.put("font-face-format", new FontFaceFormatElementFactory());
        this.factories.put("font-face-name", new FontFaceNameElementFactory());
        this.factories.put("font-face-src", new FontFaceSrcElementFactory());
        this.factories.put("font-face-uri", new FontFaceUriElementFactory());
        this.factories.put("foreignObject", new ForeignObjectElementFactory());
        this.factories.put("g", new GElementFactory());
        this.factories.put("glyph", new GlyphElementFactory());
        this.factories.put("glyphRef", new GlyphRefElementFactory());
        this.factories.put("hkern", new HkernElementFactory());
        this.factories.put("image", new ImageElementFactory());
        this.factories.put("line", new LineElementFactory());
        this.factories.put("linearGradient", new LinearGradientElementFactory());
        this.factories.put("marker", new MarkerElementFactory());
        this.factories.put("mask", new MaskElementFactory());
        this.factories.put("metadata", new MetadataElementFactory());
        this.factories.put("missing-glyph", new MissingGlyphElementFactory());
        this.factories.put("mpath", new MpathElementFactory());
        this.factories.put("path", new PathElementFactory());
        this.factories.put("pattern", new PatternElementFactory());
        this.factories.put("polygon", new PolygonElementFactory());
        this.factories.put("polyline", new PolylineElementFactory());
        this.factories.put("radialGradient", new RadialGradientElementFactory());
        this.factories.put("rect", new RectElementFactory());
        this.factories.put("set", new SetElementFactory());
        this.factories.put("script", new ScriptElementFactory());
        this.factories.put("stop", new StopElementFactory());
        this.factories.put("style", new StyleElementFactory());
        this.factories.put("svg", new SvgElementFactory());
        this.factories.put("switch", new SwitchElementFactory());
        this.factories.put("symbol", new SymbolElementFactory());
        this.factories.put("text", new TextElementFactory());
        this.factories.put("textPath", new TextPathElementFactory());
        this.factories.put("title", new TitleElementFactory());
        this.factories.put("tref", new TrefElementFactory());
        this.factories.put("tspan", new TspanElementFactory());
        this.factories.put("use", new UseElementFactory());
        this.factories.put("view", new ViewElementFactory());
        this.factories.put("vkern", new VkernElementFactory());
        this.registerFeature("CSS", "2.0");
        this.registerFeature("StyleSheets", "2.0");
        this.registerFeature("SVG", "1.0");
        this.registerFeature("SVGEvents", "1.0");
    }

    public CSSEngine createCSSEngine(SVGOMDocument doc, CSSContext ctx) {
        Parser p;
        String pn = XMLResourceDescriptor.getCSSParserClassName();
        try {
            p = (Parser)Class.forName(pn).newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new DOMException(15, this.formatMessage("css.parser.class", new Object[]{pn}));
        }
        catch (InstantiationException e) {
            throw new DOMException(15, this.formatMessage("css.parser.creation", new Object[]{pn}));
        }
        catch (IllegalAccessException e) {
            throw new DOMException(15, this.formatMessage("css.parser.access", new Object[]{pn}));
        }
        ExtendedParser ep = ExtendedParserWrapper.wrap(p);
        SVGCSSEngine result = new SVGCSSEngine(doc, doc.getURLObject(), ep, ctx);
        URL url = this.getClass().getResource("resources/UserAgentStyleSheet.css");
        if (url != null) {
            InputSource is = new InputSource(url.toString());
            result.setUserAgentStyleSheet(result.parseStyleSheet(is, url, "all"));
        }
        doc.setCSSEngine(result);
        return result;
    }

    public ViewCSS createViewCSS(SVGOMDocument doc) {
        return new CSSOMSVGViewCSS(doc.getCSSEngine());
    }

    public DocumentType createDocumentType(String qualifiedName, String publicId, String systemId) {
        throw new DOMException(9, this.formatMessage("doctype.not.supported", null));
    }

    public Document createDocument(String namespaceURI, String qualifiedName, DocumentType doctype) throws DOMException {
        SVGOMDocument result = new SVGOMDocument(doctype, this);
        result.appendChild(result.createElementNS(namespaceURI, qualifiedName));
        return result;
    }

    public CSSStyleSheet createCSSStyleSheet(String title, String media) {
        throw new InternalError("Not implemented");
    }

    public CSSStyleDeclaration createCSSStyleDeclaration() {
        throw new InternalError("Not implemented");
    }

    public void setLocale(Locale l) {
        this.localizableSupport.setLocale(l);
    }

    public Locale getLocale() {
        return this.localizableSupport.getLocale();
    }

    public String formatMessage(String key, Object[] args) throws MissingResourceException {
        return this.localizableSupport.formatMessage(key, args);
    }

    public StyleSheet createStyleSheet(Node n, HashTable attrs) {
        throw new InternalError("Not implemented");
    }

    public CSSStyleSheet getUserAgentStyleSheet() {
        throw new InternalError("Not implemented");
    }

    public Element createElementNS(AbstractDocument document, String namespaceURI, String qualifiedName) {
        String name;
        ElementFactory ef;
        if (namespaceURI == null) {
            return new GenericElement(qualifiedName.intern(), document);
        }
        if (namespaceURI.equals(SVG_NAMESPACE_URI) && (ef = (ElementFactory)this.factories.get(name = DOMUtilities.getLocalName(qualifiedName))) != null) {
            return ef.create(DOMUtilities.getPrefix(qualifiedName), document);
        }
        return new GenericElementNS(namespaceURI.intern(), qualifiedName.intern(), document);
    }

    public DocumentEventSupport createDocumentEventSupport() {
        DocumentEventSupport result = new DocumentEventSupport();
        result.registerEventFactory("SVGEvents", new DocumentEventSupport.EventFactory(){

            public Event createEvent() {
                return new SVGOMEvent();
            }
        });
        return result;
    }

    static {
        SVG_NAMESPACE_URI = SVG_NAMESPACE_URI;
        DOM_IMPLEMENTATION = new SVGDOMImplementation();
        RESOURCES = RESOURCES;
    }

    protected static class VkernElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMVKernElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class ViewElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMViewElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class UseElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMUseElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class TspanElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMTSpanElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class TrefElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMTRefElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class TitleElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMTitleElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class TextPathElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMTextPathElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class TextElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMTextElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class SymbolElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMSymbolElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class SwitchElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMSwitchElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class SvgElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMSVGElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class StyleElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMStyleElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class StopElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMStopElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class SetElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMSetElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class ScriptElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMScriptElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class RectElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMRectElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class RadialGradientElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMRadialGradientElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class PolylineElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMPolylineElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class PolygonElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMPolygonElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class PatternElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMPatternElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class PathElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMPathElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class MpathElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMMPathElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class MissingGlyphElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMMissingGlyphElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class MetadataElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMMetadataElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class MaskElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMMaskElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class MarkerElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMMarkerElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class LinearGradientElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMLinearGradientElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class LineElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMLineElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class ImageElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMImageElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class HkernElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMHKernElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class GlyphRefElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMGlyphRefElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class GlyphElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMGlyphElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class GElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMGElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class ForeignObjectElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMForeignObjectElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class FontFaceUriElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMFontFaceUriElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class FontFaceSrcElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMFontFaceSrcElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class FontFaceNameElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMFontFaceNameElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class FontFaceFormatElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMFontFaceFormatElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class FontFaceElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMFontFaceElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class FontElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMFontElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class FilterElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMFilterElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class FeTurbulenceElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMFETurbulenceElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class FeTileElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMFETileElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class FeSpotLightElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMFESpotLightElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class FeSpecularLightingElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMFESpecularLightingElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class FePointLightElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMFEPointLightElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class FeOffsetElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMFEOffsetElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class FeMorphologyElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMFEMorphologyElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class FeMergeNodeElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMFEMergeNodeElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class FeMergeElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMFEMergeElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class FeImageElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMFEImageElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class FeGaussianBlurElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMFEGaussianBlurElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class FeFuncBElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMFEFuncBElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class FeFuncGElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMFEFuncGElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class FeFuncRElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMFEFuncRElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class FeFuncAElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMFEFuncAElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class FeFloodElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMFEFloodElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class FeDistantLightElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMFEDistantLightElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class FeDisplacementMapElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMFEDisplacementMapElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class FeDiffuseLightingElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMFEDiffuseLightingElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class FeConvolveMatrixElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMFEConvolveMatrixElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class FeCompositeElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMFECompositeElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class FeComponentTransferElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMFEComponentTransferElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class FeColorMatrixElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMFEColorMatrixElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class FeBlendElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMFEBlendElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class EllipseElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMEllipseElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class DescElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMDescElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class DefsElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMDefsElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class DefinitionSrcElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMDefinitionSrcElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class CursorElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMCursorElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class ColorProfileElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMColorProfileElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class ClipPathElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMClipPathElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class CircleElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMCircleElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class AnimateTransformElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMAnimateTransformElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class AnimateMotionElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMAnimateMotionElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class AnimateColorElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMAnimateColorElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class AnimateElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMAnimateElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class AltGlyphItemElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMAltGlyphItemElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class AltGlyphDefElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMAltGlyphDefElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class AltGlyphElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMAltGlyphElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class AElementFactory
    implements ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMAElement(prefix, (AbstractDocument)doc);
        }
    }

    public static interface ElementFactory {
        public Element create(String var1, Document var2);
    }
}

