/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom;

import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.AbstractElement;
import org.apache.batik.dom.AbstractParentNode;
import org.apache.batik.dom.util.DOMUtilities;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractAttr
extends AbstractParentNode
implements Attr {
    protected String nodeName;
    protected boolean unspecified;
    protected AbstractElement ownerElement;

    protected AbstractAttr() {
    }

    protected AbstractAttr(String name, AbstractDocument owner) throws DOMException {
        this.ownerDocument = owner;
        if (!DOMUtilities.isValidName(name)) {
            throw this.createDOMException((short)5, "xml.name", new Object[]{name});
        }
    }

    public void setNodeName(String v) {
        this.nodeName = v;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public short getNodeType() {
        return 2;
    }

    public String getNodeValue() throws DOMException {
        Node first = this.getFirstChild();
        if (first == null) {
            return "";
        }
        Node n = first.getNextSibling();
        if (n == null) {
            return first.getNodeValue();
        }
        StringBuffer result = new StringBuffer(first.getNodeValue());
        do {
            result.append(n.getNodeValue());
        } while ((n = n.getNextSibling()) != null);
        return result.toString();
    }

    /*
     * WARNING - void declaration
     */
    public void setNodeValue(String nodeValue) throws DOMException {
        Node n;
        if (this.isReadonly()) {
            throw this.createDOMException((short)7, "readonly.node", new Object[]{new Integer(this.getNodeType()), this.getNodeName()});
        }
        String s = this.getNodeValue();
        while ((n = this.getFirstChild()) != null) {
            void var3_3;
            this.removeChild((Node)var3_3);
        }
        String val = nodeValue == null ? "" : nodeValue;
        n = this.getOwnerDocument().createTextNode(val);
        this.appendChild(n);
        if (this.ownerElement != null) {
            this.ownerElement.fireDOMAttrModifiedEvent(this.nodeName, this, s, val, (short)1);
        }
    }

    public String getName() {
        return this.getNodeName();
    }

    public boolean getSpecified() {
        return !this.unspecified;
    }

    public void setSpecified(boolean v) {
        this.unspecified = !v;
    }

    public String getValue() {
        return this.getNodeValue();
    }

    public void setValue(String value) throws DOMException {
        this.setNodeValue(value);
    }

    public void setOwnerElement(AbstractElement v) {
        this.ownerElement = v;
    }

    public Element getOwnerElement() {
        return this.ownerElement;
    }

    protected void nodeAdded(Node n) {
        this.setSpecified(true);
    }

    protected void nodeToBeRemoved(Node n) {
        this.setSpecified(true);
    }

    protected Node export(Node n, AbstractDocument d) {
        super.export(n, d);
        AbstractAttr aa = (AbstractAttr)n;
        aa.nodeName = this.nodeName;
        aa.unspecified = false;
        return n;
    }

    protected Node deepExport(Node n, AbstractDocument d) {
        super.deepExport(n, d);
        AbstractAttr aa = (AbstractAttr)n;
        aa.nodeName = this.nodeName;
        aa.unspecified = false;
        return n;
    }

    protected Node copyInto(Node n) {
        super.copyInto(n);
        AbstractAttr aa = (AbstractAttr)n;
        aa.nodeName = this.nodeName;
        aa.unspecified = this.unspecified;
        return n;
    }

    protected Node deepCopyInto(Node n) {
        super.deepCopyInto(n);
        AbstractAttr aa = (AbstractAttr)n;
        aa.nodeName = this.nodeName;
        aa.unspecified = this.unspecified;
        return n;
    }

    protected void checkChildType(Node n, boolean replace) {
        switch (n.getNodeType()) {
            case 3: 
            case 5: 
            case 11: {
                break;
            }
            default: {
                throw this.createDOMException((short)3, "child.type", new Object[]{new Integer(this.getNodeType()), this.getNodeName(), new Integer(n.getNodeType()), n.getNodeName()});
            }
        }
    }

    protected void fireDOMSubtreeModifiedEvent() {
        AbstractDocument doc = this.getCurrentDocument();
        if (doc.getEventsEnabled()) {
            super.fireDOMSubtreeModifiedEvent();
            if (this.getOwnerElement() != null) {
                ((AbstractElement)this.getOwnerElement()).fireDOMSubtreeModifiedEvent();
            }
        }
    }
}

