/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.lib.util;

import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DOMUtils {
    protected static Class[] getElementsByNSParameterTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = DOMUtils.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = DOMUtils.class$("java.lang.String")) : class$java$lang$String};
    static /* synthetic */ Class class$java$lang$String;

    public static String findDavPrefix(Document document) {
        Element multistatus = document.getDocumentElement();
        NamedNodeMap list = multistatus.getAttributes();
        String prefix = "DAV:";
        int i = 0;
        while (i < list.getLength()) {
            try {
                Attr attr = (Attr)list.item(i);
                if (attr.getName() != null && attr.getName().startsWith("xmlns") && attr.getValue().equals("DAV:")) {
                    int indx = attr.getName().indexOf(":");
                    prefix = indx >= 0 && indx < attr.getName().length() - 1 ? attr.getName().substring(indx + 1) + ":" : "";
                }
            }
            catch (ClassCastException e) {
                // empty catch block
            }
            ++i;
        }
        return prefix;
    }

    public static String getTextValue(Node node) {
        StringBuffer text = new StringBuffer();
        NodeList nodeList = node.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            if (nodeList.item(i).getNodeType() == 3) {
                text.append(((Text)nodeList.item(i)).getData());
            } else {
                text.append(DOMUtils.getTextValue(nodeList.item(i)));
            }
            ++i;
        }
        return text.toString();
    }

    public static int parseStatus(String statusString) {
        int status = -1;
        if (statusString != null) {
            StringTokenizer tokenizer = new StringTokenizer(statusString);
            if (tokenizer.countTokens() >= 2) {
                tokenizer.nextElement();
                String statusCode = tokenizer.nextElement().toString();
                try {
                    status = Integer.parseInt(statusCode);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Status code is not numeric");
                }
            } else {
                throw new IllegalArgumentException("There aren't enough words in the input argument");
            }
        }
        return status;
    }

    /*
     * Handled impossible loop by duplicating code
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getElementNamespaceURI(Element element) {
        String namespace;
        block9: {
            void var7_8;
            boolean found;
            String attribute;
            block8: {
                namespace = null;
                if (element == null) {
                    throw new IllegalArgumentException("The element cannot be null");
                }
                try {
                    return element.getNamespaceURI();
                }
                catch (NoSuchMethodError e) {
                    String tagName = element.getTagName();
                    attribute = "xmlns";
                    int index = tagName.indexOf(":");
                    if (index > 0 && index < tagName.length() - 1) {
                        attribute = attribute + ":" + tagName.substring(0, index);
                    }
                    found = false;
                    Element element2 = element;
                    if (!true) break block8;
                    if (found) return namespace;
                    if (var7_8 == null) break block9;
                }
            }
            do {
                try {
                    String tmp = ((Element)var7_8).getAttribute(attribute);
                    if (tmp != null && !tmp.equals("")) {
                        namespace = tmp;
                        found = true;
                    }
                }
                catch (ClassCastException f) {
                    // empty catch block
                }
                Node node = var7_8.getParentNode();
                if (found) return namespace;
            } while (var7_8 != null);
        }
        return namespace;
    }

    public static String getElementLocalName(Element element) {
        String localName;
        block3: {
            localName = null;
            if (element == null) {
                throw new IllegalArgumentException("The element cannot be null");
            }
            try {
                localName = element.getLocalName();
            }
            catch (NoSuchMethodError e) {
                localName = element.getTagName();
                int index = localName.indexOf(":");
                if (index <= 0 || index >= localName.length() - 1) break block3;
                localName = localName.substring(index + 1);
            }
        }
        return localName;
    }

    public static NodeList getElementsByTagNameNS(Node node, String tagName, String namespace) {
        NodeList list = null;
        if (node == null) {
            return null;
        }
        if (!(node instanceof Document) && !(node instanceof Element)) {
            throw new IllegalArgumentException("The node parameter must be an Element or a Document node");
        }
        try {
            list = ((Element)node).getElementsByTagNameNS(namespace, tagName);
        }
        catch (NoSuchMethodError e) {
            Vector vector = new Vector();
            DOMUtils.getChildElementsByTagNameNS(vector, node, tagName, namespace);
            list = new NodeListImpl(vector);
        }
        return list;
    }

    protected static void getChildElementsByTagNameNS(Vector vector, Node node, String tagName, String namespace) {
        NodeList list = node.getChildNodes();
        int i = 0;
        while (list != null && i < list.getLength()) {
            try {
                Element element = (Element)list.item(i);
                if (tagName.equals(DOMUtils.getElementLocalName(element)) && namespace.equals(DOMUtils.getElementNamespaceURI(element))) {
                    vector.addElement(element);
                } else {
                    DOMUtils.getChildElementsByTagNameNS(vector, element, tagName, namespace);
                }
            }
            catch (ClassCastException e) {
                // empty catch block
            }
            ++i;
        }
    }

    public static Element getFirstElement(Node node, String namespace, String name) {
        NodeList children = node.getChildNodes();
        if (children == null) {
            return null;
        }
        int i = 0;
        while (i < children.getLength()) {
            try {
                Element child = (Element)children.item(i);
                if (name.equals(DOMUtils.getElementLocalName(child)) && namespace.equals(DOMUtils.getElementNamespaceURI(child))) {
                    return child;
                }
            }
            catch (ClassCastException e) {
                // empty catch block
            }
            ++i;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class NodeListImpl
    implements NodeList {
        private Vector vector = null;

        NodeListImpl(Vector vector) {
            this.vector = vector;
        }

        public int getLength() {
            return this.vector.size();
        }

        public Node item(int i) {
            return (Node)this.vector.elementAt(i);
        }
    }
}

