/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.lib.properties;

import java.util.Vector;
import org.apache.webdav.lib.BaseProperty;
import org.apache.webdav.lib.ResponseEntity;
import org.apache.webdav.lib.util.DOMUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PrincipalCollectionSetProperty
extends BaseProperty {
    public static final String TAG_NAME = "principal-collection-set";
    private String[] hrefs = null;

    public PrincipalCollectionSetProperty(ResponseEntity response, Element element) {
        super(response, element);
    }

    private void init() {
        if (this.hrefs != null) {
            return;
        }
        Vector<String> hrefVector = new Vector<String>();
        NodeList hrefNodes = DOMUtils.getElementsByTagNameNS(this.element, "href", "DAV:");
        if (hrefNodes != null) {
            int i = 0;
            while (i < hrefNodes.getLength()) {
                Node hrefNode = hrefNodes.item(i);
                String href = DOMUtils.getTextValue(hrefNode);
                if (href != null && href.length() > 0) {
                    hrefVector.add(href);
                }
                ++i;
            }
        }
        this.hrefs = hrefVector.toArray(new String[hrefVector.size()]);
    }

    public String[] getHrefs() {
        this.init();
        return this.hrefs;
    }

    public String getPropertyAsString() {
        String[] hrefs = this.getHrefs();
        if (hrefs == null || hrefs.length == 0) {
            return "";
        }
        StringBuffer tmp = new StringBuffer(hrefs[0]);
        int i = 1;
        while (i < hrefs.length) {
            tmp.append(", ");
            tmp.append(hrefs[i]);
            ++i;
        }
        return tmp.toString();
    }
}

