/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.UnsupportedEncodingException;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFRectangle;
import org.apache.fop.pdf.PDFStream;

public class PDFFontDescriptor
extends PDFObject {
    protected int ascent;
    protected int capHeight;
    protected int descent;
    protected int flags;
    protected PDFRectangle fontBBox;
    protected String basefont;
    protected int italicAngle;
    protected int stemV;
    protected int stemH = 0;
    protected int xHeight = 0;
    protected int leading = 0;
    protected int avgWidth = 0;
    protected int maxWidth = 0;
    protected int missingWidth = 0;
    protected PDFStream fontfile;
    protected byte subtype;

    public PDFFontDescriptor(int number, String basefont, int ascent, int descent, int capHeight, int flags, PDFRectangle fontBBox, int italicAngle, int stemV) {
        super(number);
        this.basefont = basefont;
        this.ascent = ascent;
        this.descent = descent;
        this.capHeight = capHeight;
        this.flags = flags;
        this.fontBBox = fontBBox;
        this.italicAngle = italicAngle;
        this.stemV = stemV;
    }

    public void setMetrics(int avgWidth, int maxWidth, int missingWidth, int leading, int stemH, int xHeight) {
        this.avgWidth = avgWidth;
        this.maxWidth = maxWidth;
        this.missingWidth = missingWidth;
        this.leading = leading;
        this.stemH = stemH;
        this.xHeight = xHeight;
    }

    public void setFontFile(byte subtype, PDFStream fontfile) {
        this.subtype = subtype;
        this.fontfile = fontfile;
    }

    public byte[] toPDF() {
        StringBuffer p = new StringBuffer(this.number + " " + this.generation + " obj\n<< /Type /FontDescriptor" + "\n/FontName /" + this.basefont);
        p.append("\n/FontBBox ");
        p.append(this.fontBBox.toPDFString());
        p.append("\n/Flags ");
        p.append(this.flags);
        p.append("\n/CapHeight ");
        p.append(this.capHeight);
        p.append("\n/Ascent ");
        p.append(this.ascent);
        p.append("\n/Descent ");
        p.append(this.descent);
        p.append("\n/ItalicAngle ");
        p.append(this.italicAngle);
        p.append("\n/StemV ");
        p.append(this.stemV);
        if (this.stemH != 0) {
            p.append("\n/StemH ");
            p.append(this.stemH);
        }
        if (this.xHeight != 0) {
            p.append("\n/XHeight ");
            p.append(this.xHeight);
        }
        if (this.avgWidth != 0) {
            p.append("\n/AvgWidth ");
            p.append(this.avgWidth);
        }
        if (this.maxWidth != 0) {
            p.append("\n/MaxWidth ");
            p.append(this.maxWidth);
        }
        if (this.missingWidth != 0) {
            p.append("\n/MissingWidth ");
            p.append(this.missingWidth);
        }
        if (this.leading != 0) {
            p.append("\n/Leading ");
            p.append(this.leading);
        }
        if (this.fontfile != null) {
            switch (this.subtype) {
                case 1: {
                    p.append("\n/FontFile ");
                    break;
                }
                case 4: {
                    p.append("\n/FontFile2 ");
                    break;
                }
                case 0: {
                    p.append("\n/FontFile2 ");
                    break;
                }
                default: {
                    p.append("\n/FontFile2 ");
                }
            }
            p.append(this.fontfile.referencePDF());
        }
        this.fillInPDF(p);
        p.append("\n >>\nendobj\n");
        try {
            return p.toString().getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException ue) {
            return p.toString().getBytes();
        }
    }

    protected void fillInPDF(StringBuffer begin) {
    }
}

