/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.UnsupportedEncodingException;
import org.apache.fop.pdf.PDFArray;
import org.apache.fop.pdf.PDFEncoding;
import org.apache.fop.pdf.PDFFontDescriptor;
import org.apache.fop.pdf.PDFFontTrueType;
import org.apache.fop.pdf.PDFFontType0;
import org.apache.fop.pdf.PDFFontType1;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFStream;

public class PDFFont
extends PDFObject {
    public static final byte TYPE0 = 0;
    public static final byte TYPE1 = 1;
    public static final byte MMTYPE1 = 2;
    public static final byte TYPE3 = 3;
    public static final byte TRUETYPE = 4;
    protected static final String[] TYPE_NAMES = new String[]{"Type0", "Type1", "MMType1", "Type3", "TrueType"};
    protected String fontname;
    protected byte subtype;
    protected String basefont;
    protected Object encoding;

    public PDFFont(int number, String fontname, byte subtype, String basefont, Object encoding) {
        super(number);
        this.fontname = fontname;
        this.subtype = subtype;
        this.basefont = basefont;
        this.encoding = encoding;
    }

    public static PDFFont createFont(int number, String fontname, byte subtype, String basefont, Object encoding) {
        switch (subtype) {
            case 0: {
                return new PDFFontType0(number, fontname, subtype, basefont, encoding);
            }
            case 1: 
            case 2: {
                return new PDFFontType1(number, fontname, subtype, basefont, encoding);
            }
            case 4: {
                return new PDFFontTrueType(number, fontname, subtype, basefont, encoding);
            }
        }
        return null;
    }

    public static PDFFont createFont(int number, String fontname, byte subtype, String basefont, Object encoding, int firstChar, int lastChar, PDFArray widths, PDFFontDescriptor descriptor) {
        switch (subtype) {
            case 0: {
                PDFFontType0 font = new PDFFontType0(number, fontname, subtype, basefont, encoding);
                font.setDescriptor(descriptor);
                return font;
            }
            case 1: 
            case 2: {
                PDFFontType1 font = new PDFFontType1(number, fontname, subtype, basefont, encoding);
                font.setWidthMetrics(firstChar, lastChar, widths);
                font.setDescriptor(descriptor);
                return font;
            }
            case 3: {
                return null;
            }
            case 4: {
                PDFFontTrueType font = new PDFFontTrueType(number, fontname, subtype, basefont, encoding);
                font.setWidthMetrics(firstChar, lastChar, widths);
                font.setDescriptor(descriptor);
                return font;
            }
        }
        return null;
    }

    public String getName() {
        return this.fontname;
    }

    public byte[] toPDF() {
        StringBuffer p = new StringBuffer();
        p.append(this.number + " " + this.generation + " obj\n<< /Type /Font\n/Subtype /" + TYPE_NAMES[this.subtype] + "\n/Name /" + this.fontname + "\n/BaseFont /" + this.basefont);
        if (this.encoding != null) {
            p.append("\n/Encoding ");
            if (this.encoding instanceof PDFEncoding) {
                p.append(((PDFEncoding)this.encoding).referencePDF());
            } else if (this.encoding instanceof PDFStream) {
                p.append(((PDFStream)this.encoding).referencePDF());
            } else {
                p.append("/").append((String)this.encoding);
            }
        }
        this.fillInPDF(p);
        p.append(" >>\nendobj\n");
        try {
            return p.toString().getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException ue) {
            return p.toString().getBytes();
        }
    }

    protected void fillInPDF(StringBuffer begin) {
    }
}

