/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layout;

import java.util.ArrayList;
import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.IDReferences;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.flow.Block;
import org.apache.fop.fo.flow.BlockContainer;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.AreaContainer;
import org.apache.fop.layout.FontState;
import org.apache.fop.layout.SpanArea;
import org.apache.fop.render.Renderer;

public class BodyAreaContainer
extends Area {
    private int xPosition;
    private int yPosition;
    private int position;
    private int columnCount;
    private int columnGap;
    private AreaContainer mainReferenceArea;
    private AreaContainer beforeFloatReferenceArea;
    private AreaContainer footnoteReferenceArea;
    private int mainRefAreaHeight;
    private int mainYPosition;
    private int beforeFloatYPosition;
    private int footnoteYPosition;
    private FObj startFO;
    private boolean isNewSpanArea;
    private int footnoteState = 0;

    public BodyAreaContainer(FontState fontState, int xPosition, int yPosition, int allocationWidth, int maxHeight, int position, int columnCount, int columnGap) {
        super(fontState, allocationWidth, maxHeight);
        this.xPosition = xPosition;
        this.yPosition = yPosition;
        this.position = position;
        this.columnCount = columnCount;
        this.columnGap = columnGap;
        this.mainRefAreaHeight = maxHeight;
        this.beforeFloatReferenceArea = new AreaContainer(fontState, xPosition, yPosition, allocationWidth, 0, 1);
        this.beforeFloatReferenceArea.setAreaName("before-float-reference-area");
        this.addChild(this.beforeFloatReferenceArea);
        this.mainReferenceArea = new AreaContainer(fontState, xPosition, yPosition, allocationWidth, this.mainRefAreaHeight, 1);
        this.mainReferenceArea.setAreaName("main-reference-area");
        this.addChild(this.mainReferenceArea);
        this.footnoteReferenceArea = new AreaContainer(fontState, xPosition, yPosition - this.mainRefAreaHeight, allocationWidth, 0, 1);
        this.footnoteReferenceArea.setAreaName("footnote-reference-area");
        this.addChild(this.footnoteReferenceArea);
    }

    public void render(Renderer renderer) {
        renderer.renderBodyAreaContainer(this);
    }

    public int getPosition() {
        return this.position;
    }

    public int getXPosition() {
        return this.xPosition + this.getPaddingLeft() + this.getBorderLeftWidth();
    }

    public void setXPosition(int value) {
        this.xPosition = value;
    }

    public int getYPosition() {
        return this.yPosition + this.getPaddingTop() + this.getBorderTopWidth();
    }

    public void setYPosition(int value) {
        this.yPosition = value;
    }

    public AreaContainer getMainReferenceArea() {
        return this.mainReferenceArea;
    }

    public AreaContainer getBeforeFloatReferenceArea() {
        return this.beforeFloatReferenceArea;
    }

    public AreaContainer getFootnoteReferenceArea() {
        return this.footnoteReferenceArea;
    }

    public void setIDReferences(IDReferences idReferences) {
        this.mainReferenceArea.setIDReferences(idReferences);
    }

    public IDReferences getIDReferences() {
        return this.mainReferenceArea.getIDReferences();
    }

    public AreaContainer getNextArea(FObj fo) throws FOPException {
        this.isNewSpanArea = false;
        int span = 75;
        if (fo instanceof Block) {
            span = ((Block)fo).getSpan();
        } else if (fo instanceof BlockContainer) {
            span = ((BlockContainer)fo).getSpan();
        }
        if (this.mainReferenceArea.getChildren().isEmpty()) {
            if (span == 4) {
                return this.addSpanArea(1);
            }
            return this.addSpanArea(this.columnCount);
        }
        ArrayList spanAreas = this.mainReferenceArea.getChildren();
        SpanArea spanArea = (SpanArea)spanAreas.get(spanAreas.size() - 1);
        if (span == 4 && spanArea.getColumnCount() == 1) {
            return spanArea.getCurrentColumnArea();
        }
        if (span == 75 && spanArea.getColumnCount() == this.columnCount) {
            return spanArea.getCurrentColumnArea();
        }
        if (span == 4) {
            return this.addSpanArea(1);
        }
        if (span == 75) {
            return this.addSpanArea(this.columnCount);
        }
        throw new FOPException("BodyAreaContainer::getNextArea(): Span attribute messed up");
    }

    private AreaContainer addSpanArea(int numColumns) {
        this.resetHeights();
        int spanAreaYPosition = this.getYPosition() - this.mainReferenceArea.getContentHeight();
        SpanArea spanArea = new SpanArea(this.fontState, this.getXPosition(), spanAreaYPosition, this.allocationWidth, this.getRemainingHeight(), numColumns, this.columnGap);
        this.mainReferenceArea.addChild(spanArea);
        spanArea.setPage(this.getPage());
        this.isNewSpanArea = true;
        return spanArea.getCurrentColumnArea();
    }

    public boolean isBalancingRequired(FObj fo) {
        if (this.mainReferenceArea.getChildren().isEmpty()) {
            return false;
        }
        ArrayList spanAreas = this.mainReferenceArea.getChildren();
        SpanArea spanArea = (SpanArea)spanAreas.get(spanAreas.size() - 1);
        if (spanArea.isBalanced()) {
            return false;
        }
        int span = 75;
        if (fo instanceof Block) {
            span = ((Block)fo).getSpan();
        } else if (fo instanceof BlockContainer) {
            span = ((BlockContainer)fo).getSpan();
        }
        if (span == 4 && spanArea.getColumnCount() == 1) {
            return false;
        }
        if (span == 75 && spanArea.getColumnCount() == this.columnCount) {
            return false;
        }
        if (span == 4) {
            return true;
        }
        if (span == 75) {
            return false;
        }
        return false;
    }

    public void resetSpanArea() {
        ArrayList spanAreas = this.mainReferenceArea.getChildren();
        SpanArea spanArea = (SpanArea)spanAreas.get(spanAreas.size() - 1);
        if (spanArea.isBalanced()) {
            throw new IllegalStateException("Trying to balance balanced area");
        }
        int newHeight = spanArea.getTotalContentHeight() / spanArea.getColumnCount();
        this.mainReferenceArea.removeChild(spanArea);
        this.resetHeights();
        SpanArea newSpanArea = new SpanArea(this.fontState, this.getXPosition(), spanArea.getYPosition(), this.allocationWidth, newHeight += 31200, spanArea.getColumnCount(), this.columnGap);
        this.mainReferenceArea.addChild(newSpanArea);
        newSpanArea.setPage(this.getPage());
        newSpanArea.setIsBalanced();
        this.isNewSpanArea = true;
    }

    public int getRemainingHeight() {
        return this.mainReferenceArea.getMaxHeight() - this.mainReferenceArea.getContentHeight();
    }

    private void resetHeights() {
        int totalHeight = 0;
        ArrayList children = this.mainReferenceArea.getChildren();
        int i = 0;
        while (i < children.size()) {
            int spanMaxHeight;
            SpanArea spanArea = (SpanArea)children.get(i);
            int spanContentHeight = spanArea.getMaxContentHeight();
            totalHeight += spanContentHeight < (spanMaxHeight = spanArea.getMaxHeight()) ? spanContentHeight : spanMaxHeight;
            ++i;
        }
        this.mainReferenceArea.setHeight(totalHeight);
    }

    public boolean isLastColumn() {
        ArrayList spanAreas = this.mainReferenceArea.getChildren();
        SpanArea spanArea = (SpanArea)spanAreas.get(spanAreas.size() - 1);
        return spanArea.isLastColumn();
    }

    public boolean isNewSpanArea() {
        return this.isNewSpanArea;
    }

    public AreaContainer getCurrentColumnArea() {
        ArrayList spanAreas = this.mainReferenceArea.getChildren();
        SpanArea spanArea = (SpanArea)spanAreas.get(spanAreas.size() - 1);
        return spanArea.getCurrentColumnArea();
    }

    public int getFootnoteState() {
        return this.footnoteState;
    }

    public boolean needsFootnoteAdjusting() {
        this.footnoteYPosition = this.footnoteReferenceArea.getYPosition();
        switch (this.footnoteState) {
            case 0: {
                this.resetHeights();
                if (this.footnoteReferenceArea.getHeight() <= 0 || this.mainYPosition + this.mainReferenceArea.getHeight() <= this.footnoteYPosition) break;
                return true;
            }
        }
        return false;
    }

    public void adjustFootnoteArea() {
        ++this.footnoteState;
        if (this.footnoteState == 1) {
            this.mainReferenceArea.setMaxHeight(this.footnoteReferenceArea.getYPosition() - this.mainYPosition);
            this.footnoteYPosition = this.footnoteReferenceArea.getYPosition();
            this.footnoteReferenceArea.setMaxHeight(this.footnoteReferenceArea.getHeight());
            ArrayList children = this.footnoteReferenceArea.getChildren();
            int i = 0;
            while (i < children.size()) {
                Object obj = children.get(i);
                if (obj instanceof Area) {
                    Area childArea = (Area)obj;
                    this.footnoteReferenceArea.removeChild(childArea);
                }
                ++i;
            }
            this.getPage().setPendingFootnotes(null);
        }
    }

    protected static void resetMaxHeight(Area ar, int change) {
        ar.setMaxHeight(change);
        ArrayList childs = ar.getChildren();
        int i = 0;
        while (i < childs.size()) {
            Object obj = childs.get(i);
            if (obj instanceof Area) {
                Area childArea = (Area)obj;
                BodyAreaContainer.resetMaxHeight(childArea, change);
            }
            ++i;
        }
    }
}

