/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.fop.datatypes.ColorSpace;
import org.apache.fop.image.AbstractFopImage;
import org.apache.fop.image.FopImageException;
import org.apache.fop.image.analyser.ImageReader;

public class BmpImage
extends AbstractFopImage {
    public BmpImage(URL href) throws FopImageException {
        super(href);
    }

    public BmpImage(URL href, ImageReader imgReader) throws FopImageException {
        super(href, imgReader);
    }

    protected void loadImage() throws FopImageException {
        int bytes;
        int count2;
        int wpos = 18;
        int hpos = 22;
        int[] headermap = new int[54];
        int filepos = 0;
        InputStream file = null;
        byte[] palette = null;
        try {
            file = this.m_href.openStream();
            boolean eof = false;
            while (!eof && filepos < 54) {
                int input = file.read();
                if (input == -1) {
                    eof = true;
                    continue;
                }
                headermap[filepos++] = input;
            }
            if (headermap[28] == 4 || headermap[28] == 8) {
                int palettesize = 1 << headermap[28];
                palette = new byte[palettesize * 3];
                int countr = 0;
                while (!eof && countr < palettesize) {
                    count2 = 2;
                    while (!eof && count2 >= -1) {
                        int input = file.read();
                        if (input == -1) {
                            eof = true;
                        } else if (count2 >= 0) {
                            palette[countr * 3 + count2] = (byte)(input & 0xFF);
                        }
                        --count2;
                        ++filepos;
                    }
                    ++countr;
                }
            }
        }
        catch (IOException e) {
            throw new FopImageException("Error while loading image " + this.m_href.toString() + " : " + e.getClass() + " - " + e.getMessage());
        }
        this.m_width = headermap[wpos] + headermap[wpos + 1] * 256 + headermap[wpos + 2] * 256 * 256 + headermap[wpos + 3] * 256 * 256 * 256;
        this.m_height = headermap[hpos] + headermap[hpos + 1] * 256 + headermap[hpos + 2] * 256 * 256 + headermap[hpos + 3] * 256 * 256 * 256;
        int imagestart = headermap[10] + headermap[11] * 256 + headermap[12] * 256 * 256 + headermap[13] * 256 * 256 * 256;
        this.m_bitsPerPixel = headermap[28];
        this.m_colorSpace = new ColorSpace(2);
        if (this.m_bitsPerPixel == 1) {
            bytes = (this.m_width + 7) / 8;
        } else if (this.m_bitsPerPixel == 24) {
            bytes = this.m_width * 3;
        } else if (this.m_bitsPerPixel == 4 || this.m_bitsPerPixel == 8) {
            bytes = this.m_width / (8 / this.m_bitsPerPixel);
        } else {
            throw new FopImageException("Image (" + this.m_href.toString() + ") has " + this.m_bitsPerPixel + " which is not a supported BMP format.");
        }
        if ((bytes & 3) != 0) {
            bytes |= 3;
            ++bytes;
        }
        this.m_bitmapsSize = this.m_width * this.m_height * 3;
        this.m_bitmaps = new byte[this.m_bitmapsSize];
        int[] temp = new int[bytes * this.m_height];
        try {
            int input;
            int count = 0;
            file.skip(imagestart - filepos);
            while ((input = file.read()) != -1) {
                temp[count++] = count2;
            }
            file.close();
        }
        catch (IOException e) {
            throw new FopImageException("Error while loading image " + this.m_href.toString() + " : " + e.getClass() + " - " + e.getMessage());
        }
        int i = 0;
        while (i < this.m_height) {
            int x = 0;
            int j = 0;
            while (j < bytes) {
                int countr;
                int p = temp[(this.m_height - i - 1) * bytes + j];
                if (this.m_bitsPerPixel == 24 && x < this.m_width) {
                    countr = 2;
                    do {
                        this.m_bitmaps[3 * (i * this.m_width + x) + countr] = (byte)(temp[(this.m_height - i - 1) * bytes + j] & 0xFF);
                        ++j;
                    } while (--countr >= 0);
                    ++x;
                    continue;
                }
                if (this.m_bitsPerPixel == 1) {
                    countr = 0;
                    while (countr < 8 && x < this.m_width) {
                        if ((p & 0x80) != 0) {
                            this.m_bitmaps[3 * (i * this.m_width + x)] = -1;
                            this.m_bitmaps[3 * (i * this.m_width + x) + 1] = -1;
                            this.m_bitmaps[3 * (i * this.m_width + x) + 2] = -1;
                        } else {
                            this.m_bitmaps[3 * (i * this.m_width + x)] = 0;
                            this.m_bitmaps[3 * (i * this.m_width + x) + 1] = 0;
                            this.m_bitmaps[3 * (i * this.m_width + x) + 2] = 0;
                        }
                        p <<= 1;
                        ++x;
                        ++countr;
                    }
                    ++j;
                    continue;
                }
                if (this.m_bitsPerPixel == 4) {
                    countr = 0;
                    while (countr < 2 && x < this.m_width) {
                        int pal = ((p & 0xF0) >> 4) * 3;
                        this.m_bitmaps[3 * (i * this.m_width + x)] = palette[pal];
                        this.m_bitmaps[3 * (i * this.m_width + x) + 1] = palette[pal + 1];
                        this.m_bitmaps[3 * (i * this.m_width + x) + 2] = palette[pal + 2];
                        p <<= 4;
                        ++x;
                        ++countr;
                    }
                    ++j;
                    continue;
                }
                if (this.m_bitsPerPixel == 8) {
                    if (x < this.m_width) {
                        this.m_bitmaps[3 * (i * this.m_width + x)] = palette[p *= 3];
                        this.m_bitmaps[3 * (i * this.m_width + x) + 1] = palette[p + 1];
                        this.m_bitmaps[3 * (i * this.m_width + x) + 2] = palette[p + 2];
                        ++j;
                        ++x;
                        continue;
                    }
                    j = bytes;
                    continue;
                }
                ++j;
            }
            ++i;
        }
        this.m_bitsPerPixel = 8;
    }
}

