/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import java.util.ArrayList;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.flow.Marker;
import org.apache.fop.fo.pagination.PageSequence;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.AreaTree;
import org.apache.fop.layout.Page;

public class RetrieveMarker
extends FObj {
    private String retrieveClassName;
    private int retrievePosition;
    private int retrieveBoundary;
    private Marker bestMarker;

    public static FObj.Maker maker() {
        return new Maker();
    }

    public RetrieveMarker(FObj parent, PropertyList propertyList, String systemId, int line, int column) {
        super(parent, propertyList, systemId, line, column);
        this.retrieveClassName = this.properties.get("retrieve-class-name").getString();
        this.retrievePosition = this.properties.get("retrieve-position").getEnum();
        this.retrieveBoundary = this.properties.get("retrieve-boundary").getEnum();
    }

    public String getName() {
        return "fo:retrieve-marker";
    }

    public int layout(Area area) throws FOPException {
        if (this.marker == -1000) {
            this.marker = 0;
            Page containingPage = area.getPage();
            this.bestMarker = this.searchPage(containingPage);
            if (this.bestMarker != null) {
                this.bestMarker.resetMarkerContent();
                return this.bestMarker.layoutMarker(area);
            }
            AreaTree areaTree = containingPage.getAreaTree();
            if (this.retrieveBoundary == 84) {
                PageSequence pageSequence = areaTree.getCurrentPageSequence();
                if (pageSequence == containingPage.getPageSequence()) {
                    return this.layoutBestMarker(areaTree.getCurrentPageSequenceMarkers(), area);
                }
            } else {
                if (this.retrieveBoundary == 25) {
                    return this.layoutBestMarker(areaTree.getDocumentMarkers(), area);
                }
                if (this.retrieveBoundary != 83) {
                    throw new FOPException("Illegal 'retrieve-boundary' value", this.systemId, this.line, this.column);
                }
            }
        } else if (this.bestMarker != null) {
            return this.bestMarker.layoutMarker(area);
        }
        return 1;
    }

    private int layoutBestMarker(ArrayList markers, Area area) throws FOPException {
        if (markers != null) {
            int i = markers.size() - 1;
            while (i >= 0) {
                Marker currentMarker = (Marker)markers.get(i);
                if (currentMarker.getMarkerClassName().equals(this.retrieveClassName)) {
                    this.bestMarker = currentMarker;
                    this.bestMarker.resetMarkerContent();
                    return this.bestMarker.layoutMarker(area);
                }
                --i;
            }
        }
        return 1;
    }

    private Marker searchPage(Page page) throws FOPException {
        ArrayList pageMarkers = page.getMarkers();
        if (pageMarkers.isEmpty()) {
            return null;
        }
        if (this.retrievePosition == 37) {
            int i = 0;
            while (i < pageMarkers.size()) {
                Marker currentMarker = (Marker)pageMarkers.get(i);
                if (currentMarker.getMarkerClassName().equals(this.retrieveClassName)) {
                    return currentMarker;
                }
                ++i;
            }
        } else if (this.retrievePosition == 42) {
            int i = 0;
            while (i < pageMarkers.size()) {
                Marker currentMarker = (Marker)pageMarkers.get(i);
                if (currentMarker.getMarkerClassName().equals(this.retrieveClassName) && currentMarker.getRegistryArea().isFirst()) {
                    return currentMarker;
                }
                ++i;
            }
        } else if (this.retrievePosition == 61) {
            int i = pageMarkers.size() - 1;
            while (i >= 0) {
                Marker currentMarker = (Marker)pageMarkers.get(i);
                if (currentMarker.getMarkerClassName().equals(this.retrieveClassName) && currentMarker.getRegistryArea().isFirst()) {
                    return currentMarker;
                }
                --i;
            }
        } else if (this.retrievePosition == 57) {
            int i = pageMarkers.size() - 1;
            while (i >= 0) {
                Marker currentMarker = (Marker)pageMarkers.get(i);
                if (currentMarker.getMarkerClassName().equals(this.retrieveClassName) && currentMarker.getRegistryArea().isLast()) {
                    return currentMarker;
                }
                --i;
            }
        } else {
            throw new FOPException("Illegal 'retrieve-position' value", this.systemId, this.line, this.column);
        }
        return null;
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj parent, PropertyList propertyList, String systemId, int line, int column) throws FOPException {
            return new RetrieveMarker(parent, propertyList, systemId, line, column);
        }
    }
}

