from Package.PackageBase import *
from Source.SourceBase import *
from BuildSystem.BuildSystemBase import *
from Packager.PackagerBase import *
import portage
import InstallDB

class VirtualPackageBase( PackageBase, SourceBase, BuildSystemBase, PackagerBase ):
    """provides a base class for virtual packages"""
    def __init__( self ):
        utils.debug( "VirtualPackageBase.__init__ called", 2 )
        PackageBase.__init__( self )
        SourceBase.__init__( self )
        BuildSystemBase.__init__( self, "" )
        PackagerBase.__init__( self )

# from SourceBase:
    def fetch( self, dummyRepoSource=None):
        return True

    def unpack( self ):
        return True

    def createPatch( self ):
        return True

    def getUrls( self ):
        return True

    def repositoryUrl( self, dummyIndex=0 ):
        return ""

    def repositoryUrlCount( self ):
        return 0

    def localFileNamesBase( self ):
        return []

# from BuildSystemBase:
    def configure( self ):
        return True

    def install( self ):
        return True

    def uninstall( self ):
        return True

    def runTests( self ):
        return True

    def make( self ):
        return True

# from PackagerBase:
    def createPackage( self ):
        for dep in self.subinfo.dependencies:
            category,package = dep.split("/")            
            if not portage.getPackageInstance(category,package).createPackage():
                return False
        return True
