# This is a shell script that calls functions and scripts from
# tml@iki.fi's personal work environment. It is not expected to be
# usable unmodified by others, and is included only for reference.

MOD=libtiff
VER=3.8.2
REV=1
ARCH=win64

THIS=${MOD}_${VER}-${REV}_${ARCH}

RUNZIP=${MOD}_${VER}-${REV}_${ARCH}.zip
DEVZIP=${MOD}-dev_${VER}-${REV}_${ARCH}.zip

HEX=`echo $THIS | md5sum | cut -d' ' -f1`
TARGET=c:/devel/target/$HEX

usemingw64
usemsvs9x64

(

set -x

ZLIB=`latest --arch=${ARCH} zlib`
JPEG=`latest --arch=${ARCH} jpeg`

cd libtiff &&

cat >tiffconf.h <<'EOF' &&
/* libtiff/tiffconf.h.  Generated by configure.  */
/*
  Configuration defines for installed libtiff.
  This file maintained for backward compatibility. Do not use definitions
  from this file in your programs.
*/

#ifndef _TIFFCONF_
#define _TIFFCONF_

/* Define to 1 if the system has the type `int16'. */
/* #undef HAVE_INT16 */

/* Define to 1 if the system has the type `int32'. */
/* #undef HAVE_INT32 */

/* Define to 1 if the system has the type `int8'. */
/* #undef HAVE_INT8 */

/* The size of a `int', as computed by sizeof. */
#define SIZEOF_INT 4

/* The size of a `long', as computed by sizeof. */
#define SIZEOF_LONG 4

/* Compatibility stuff. */

/* Define as 0 or 1 according to the floating point format suported by the
   machine */
#define HAVE_IEEEFP 1

/* Set the native cpu bit order (FILLORDER_LSB2MSB or FILLORDER_MSB2LSB) */
#define HOST_FILLORDER FILLORDER_LSB2MSB

/* Native cpu byte order: 1 if big-endian (Motorola) or 0 if little-endian
   (Intel) */
#define HOST_BIGENDIAN 0

/* Support CCITT Group 3 & 4 algorithms */
#define CCITT_SUPPORT 1

/* Support JPEG compression (requires IJG JPEG library) */
#define JPEG_SUPPORT 1

/* Support LogLuv high dynamic range encoding */
#define LOGLUV_SUPPORT 1

/* Support LZW algorithm */
#define LZW_SUPPORT 1

/* Support NeXT 2-bit RLE algorithm */
#define NEXT_SUPPORT 1

/* Support Old JPEG compresson (read contrib/ojpeg/README first! Compilation
   fails with unpatched IJG JPEG library) */
/* #undef OJPEG_SUPPORT */

/* Support Macintosh PackBits algorithm */
#define PACKBITS_SUPPORT 1

/* Support Pixar log-format algorithm (requires Zlib) */
#define PIXARLOG_SUPPORT 1

/* Support ThunderScan 4-bit RLE algorithm */
#define THUNDER_SUPPORT 1

/* Support Deflate compression */
#define ZIP_SUPPORT 1

/* Support strip chopping (whether or not to convert single-strip uncompressed
   images to mutiple strips of ~8Kb to reduce memory usage) */
#define STRIPCHOP_DEFAULT TIFF_STRIPCHOP

/* Enable SubIFD tag (330) support */
#define SUBIFD_SUPPORT 1

/* Treat extra sample as alpha (default enabled). The RGBA interface will
   treat a fourth sample with no EXTRASAMPLE_ value as being ASSOCALPHA. Many
   packages produce RGBA files but don't mark the alpha properly. */
#define DEFAULT_EXTRASAMPLE_AS_ALPHA 1

/* Pick up YCbCr subsampling info from the JPEG data stream to support files
   lacking the tag (default enabled). */
#define CHECK_JPEG_YCBCR_SUBSAMPLING 1

/* Support MS MDI magic number files as TIFF */
#define MDI_SUPPORT 1

/*
 * Feature support definitions.
 * XXX: These macros are obsoleted. Don't use them in your apps!
 * Macros stays here for backward compatibility and should be always defined.
 */
#define COLORIMETRY_SUPPORT
#define YCBCR_SUPPORT
#define CMYK_SUPPORT
#define ICC_SUPPORT
#define PHOTOSHOP_SUPPORT
#define IPTC_SUPPORT

#endif /* _TIFFCONF_ */
EOF

cp tif_config.h.vc tif_config.h &&

x86_64-pc-mingw32-gcc -Wall -O2 -shared -o libtiff.dll -Wl,-out-implib,libtiff.dll.a -DFILLODER_LSB2MSB -DCCITT_SUPPORT -DPACKBITS_SUPPORT -DLZW_SUPPORT -DTHUNDER_SUPPORT -DNEXT_SUPPORT -DLOGLUV_SUPPORT -DJPEG_SUPPORT -DZIP_SUPPORT -DPIXARLOG_SUPPORT -DSTRIPCHOP_DEFAULT=TIFF_STRIPCHOP -DSTRIP_SIZE_DEFAULT=8192 -DDEFAULT_EXTRASAMPLE_AS_ALPHA -DCHECK_JPEG_YCBCR_SUBSAMPLING -DAVOID_WIN32_FILEIO -I/devel/dist/${ARCH}/${JPEG}/include -I/devel/dist/${ARCH}/${ZLIB}/include tif_aux.c tif_close.c tif_codec.c tif_color.c tif_compress.c tif_dir.c tif_dirinfo.c tif_dirread.c tif_dirwrite.c tif_dumpmode.c tif_error.c tif_extension.c tif_fax3.c tif_fax3sm.c tif_getimage.c tif_jpeg.c tif_ojpeg.c tif_flush.c tif_luv.c tif_lzw.c tif_next.c tif_open.c tif_packbits.c tif_pixarlog.c tif_predict.c tif_print.c tif_read.c tif_swab.c tif_strip.c tif_thunder.c tif_tile.c tif_version.c tif_warning.c tif_write.c tif_zip.c tif_unix.c libtiff.def -L/devel/dist/${ARCH}/${JPEG}/lib -ljpeg -L/devel/dist/${ARCH}/${ZLIB}/lib -lz &&

mkdir -p /devel/target/$HEX/bin &&
mkdir -p /devel/target/$HEX/lib &&
mkdir -p /devel/target/$HEX/include &&

cp libtiff.dll /devel/target/$HEX/bin &&
lib -machine:X64 -name:libtiff.dll -def:libtiff.def -out:tiff.lib &&
cp libtiff.dll.a libtiff.def tiff.lib  /devel/target/$HEX/lib &&
cp tiff.h tiffconf.h tiffio.h tiffvers.h /devel/target/$HEX/include &&

rm -f /tmp/$RUNZIP /tmp/$DEVZIP &&

cd /devel/target/$HEX &&
zip /tmp/$RUNZIP bin/libtiff.dll &&
zip -r -D /tmp/$DEVZIP lib include

) 2>&1 | tee /devel/src/tml/make/$THIS.log

(cd /devel && zip /tmp/$DEVZIP src/tml/make/$THIS.{sh,log}) &&
manifestify /tmp/$RUNZIP /tmp/$DEVZIP
