# This is a shell script that calls functions and scripts from
# tml@iki.fi's personal work environment. It is not expected to be
# usable unmodified by others, and is included only for reference.

MOD=evolution
VER=2.22.2
THIS=$MOD-$VER
HEX=`echo $THIS | md5sum | cut -d' ' -f1`

DEPS=`/devel/src/tml/latest.sh gnome-doc-utils intltool glib atk pixman cairo pango gtk+ libglade libIDL ORBit2 libbonobo GConf libbonoboui gnome-mime-data libgnome libgnomeui gnome-vfs gnutls libsoup evolution-data-server gnome-icon-theme libgnomeprint libgnomeprintui libart_lgpl libgnomecanvas gail gtkhtml`
POPT=`/devel/src/tml/latest.sh popt`
NSPR=`/devel/src/tml/latest.sh mozilla-nspr`
NSS=`/devel/src/tml/latest.sh mozilla-nss`

sed -e 's/need_relink=yes/need_relink=no # no way --tml/' <ltmain.sh >ltmain.temp && mv ltmain.temp ltmain.sh
sed -e 's/--image-base=0x10000000/--enable-auto-image-base/' <configure >configure.temp && mv configure.temp configure

# Avoid using "file" in libtool. Otherwise libtool won't create a
# shared library, and give the extremely confusing and annoying
# warning "Trying to link with static lib archive [...] But I can only
# do this if you have shared version of the library, which you do not
# appear to have." Screw libtool. I know what I am doing. Yes, I do
# want to link with a static libintl now. (The proxy-libintl libintl
# wrapper.)

sed -e 's!file /!dont-want-to-use-file!' <configure >configure.temp && mv configure.temp configure

usedev

MY_PKG_CONFIG_PATH=""
for D in $DEPS; do
    PATH=/devel/dist/$D/bin:$PATH
    MY_PKG_CONFIG_PATH=/devel/dist/$D/lib/pkgconfig:$MY_PKG_CONFIG_PATH
done

PKG_CONFIG_PATH=$MY_PKG_CONFIG_PATH:$PKG_CONFIG_PATH CC='gcc -mtune=pentium3 -mms-bitfields -mthreads' CPPFLAGS='-I/opt/win_iconv/include -I/opt/proxy-libintl/include -I/opt/gnuwin32/include -I/opt/misc/include -I/devel/dist/$POPT/include -I/opt/pthread/include' LDFLAGS='-L/opt/win_iconv/lib -L/opt/proxy-libintl/lib -Wl,--exclude-libs=libintl.a -L/opt/gnuwin32/lib -L/opt/misc/lib -L/devel/dist/$POPT/lib -L/opt/pthread/lib -Wl,--enable-auto-image-base' CFLAGS=-O2 ./configure --disable-gtk-doc --disable-scrollkeeper --disable-help --disable-static --enable-exchange=yes --enable-plugins=base --with-nspr-includes=/devel/dist/$NSPR/include --with-nspr-libs=/devel/dist/$NSPR/lib --with-nss-includes=/devel/dist/$NSS/include --with-nss-libs=/devel/dist/$NSS/lib --with-gconf-source='xml::${sysconfdir}/gconf/gconf.xml.defaults' --prefix=c:/devel/target/$HEX &&
libtoolcacheize &&
mkdir -p /devel/target/$HEX/etc/gconf/gconf.xml.defaults &&
PKG_CONFIG_PATH=$MY_PKG_CONFIG_PATH:$PKG_CONFIG_PATH PATH=/devel/target/$HEX/bin:.libs:$PATH make -j3 install
(cd po; make install; true) &&
make install-am &&

./evolution-zip &&

(cd /devel/src/tml && zip /tmp/$MOD-dev-$VER.zip make/$THIS.sh) &&
manifestify /tmp/$MOD-$VER.zip /tmp/$MOD-dev-$VER.zip
