
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001-2004 World Wide Web Consortium, 
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All 
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the 
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level3.core;

import org.w3c.dom.*;


import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;



/**
 *  The method insertBefore inserts the node newChild before the existing child node refChild. 
 *  If refChild is null, insert newChild at the end of the list of children.
 *  
 *  Using insertBefore on an Element node attempt to insert new Comment/PI and CDATA nodes
 *  before each other and verify the names of the newly inserted nodes.
* @author IBM
* @author Neil Delima
* @see <a href="http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#ID-952280727">http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#ID-952280727</a>
*/
public final class nodeinsertbefore18 extends DOMTestCase {

   /**
    * Constructor.
    * @param factory document factory, may not be null
    * @throws org.w3c.domts.DOMTestIncompatibleException Thrown if test is not compatible with parser configuration
    */
   public nodeinsertbefore18(final DOMTestDocumentBuilderFactory factory)  throws org.w3c.domts.DOMTestIncompatibleException {

      org.w3c.domts.DocumentBuilderSetting[] settings = 
          new org.w3c.domts.DocumentBuilderSetting[] {
org.w3c.domts.DocumentBuilderSetting.namespaceAware,
org.w3c.domts.DocumentBuilderSetting.notExpandEntityReferences
        };
        DOMTestDocumentBuilderFactory testFactory = factory.newInstance(settings);
        setFactory(testFactory);

    //
    //   check if loaded documents are supported for content type
    //
    String contentType = getContentType();
    preload(contentType, "hc_staff", false);
    }

   /**
    * Runs the test case.
    * @throws Throwable Any uncaught exception causes test to fail
    */
   public void runTest() throws Throwable {
      Document doc;
      Element element;
      Element newElem;
      Comment newComment;
      ProcessingInstruction newPI;
      CDATASection newCDATA;
      Comment insertedNode;
      String data;
      String target;
      Node appendedChild;
      Node inserted;
      doc = (Document) load("hc_staff", false);
      element = doc.createElement("element");
      newElem = doc.createElementNS("http://www.w3.org/DOM", "dom3:elem");
      newComment = doc.createComment("Comment");
      newCDATA = doc.createCDATASection("CDATASection");
      newPI = doc.createProcessingInstruction("target", "data");
      appendedChild = element.appendChild(newElem);
      appendedChild = element.appendChild(newComment);
      appendedChild = element.appendChild(newPI);
      appendedChild = element.appendChild(newCDATA);
      inserted = element.insertBefore(newComment, newElem);
      insertedNode = (Comment) element.getFirstChild();
      data = insertedNode.getData();
      assertEquals("nodeinsertbefore18", "Comment", data);
      }
   /**
    *  Gets URI that identifies the test.
    *  @return uri identifier of test
    */
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level3/core/nodeinsertbefore18";
   }
   /**
    * Runs this test from the command line.
    * @param args command line arguments
    */
   public static void main(final String[] args) {
        DOMTestCase.doMain(nodeinsertbefore18.class, args);
   }
}

