
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001-2004 World Wide Web Consortium, 
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All 
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the 
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level3.core;

import org.w3c.dom.*;


import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;



/**
 *  Invoke the renameNode method to attempt to rename new Text, Comment, CDataSection,
 *  ProcessingInstruction and EntityReference nodes of a new Document.
 *  Check if a NOT_SUPPORTED_ERR is thrown.
* @author IBM
* @author Neil Delima
* @see <a href="http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#Document3-renameNode">http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#Document3-renameNode</a>
*/
public final class documentrenamenode27 extends DOMTestCase {

   /**
    * Constructor.
    * @param factory document factory, may not be null
    * @throws org.w3c.domts.DOMTestIncompatibleException Thrown if test is not compatible with parser configuration
    */
   public documentrenamenode27(final DOMTestDocumentBuilderFactory factory)  throws org.w3c.domts.DOMTestIncompatibleException {
      super(factory);

    //
    //   check if loaded documents are supported for content type
    //
    String contentType = getContentType();
    preload(contentType, "hc_staff", true);
    }

   /**
    * Runs the test case.
    * @throws Throwable Any uncaught exception causes test to fail
    */
   public void runTest() throws Throwable {
      Document doc;
      Document newDoc;
      DOMImplementation domImpl;
      Text text;
      Comment comment;
      CDATASection cdata;
      ProcessingInstruction pi;
      EntityReference entref;
      Node renamedTxt;
      Node renamedComment;
      Node renamedCdata;
      Node renamedPi;
      Node renamedEntRef;
      DocumentType nullDocType = null;

      Element docElem;
      String rootNS;
      String rootName;
      doc = (Document) load("hc_staff", true);
      docElem = doc.getDocumentElement();
      rootNS = docElem.getNamespaceURI();
      rootName = docElem.getTagName();
      domImpl = doc.getImplementation();
      newDoc = domImpl.createDocument(rootNS, rootName, nullDocType);
      text = newDoc.createTextNode("text");
      comment = newDoc.createComment("comment");
      cdata = newDoc.createCDATASection("cdata");
      pi = newDoc.createProcessingInstruction("pit", "pid");
      entref = newDoc.createEntityReference("alpha");
      
      {
         boolean success = false;
         try {
            renamedTxt = newDoc.renameNode(text, "http://www.w3.org/DOM/Test", "text");
          } catch (DOMException ex) {
            success = (ex.code == DOMException.NOT_SUPPORTED_ERR);
         }
         assertTrue("throw_NOT_SUPPORTED_ERR_1", success);
      }

      {
         boolean success = false;
         try {
            renamedComment = newDoc.renameNode(comment, "http://www.w3.org/DOM/Test", "comment");
          } catch (DOMException ex) {
            success = (ex.code == DOMException.NOT_SUPPORTED_ERR);
         }
         assertTrue("throw_NOT_SUPPORTED_ERR_2", success);
      }

      {
         boolean success = false;
         try {
            renamedCdata = newDoc.renameNode(cdata, "http://www.w3.org/DOM/Test", "cdata");
          } catch (DOMException ex) {
            success = (ex.code == DOMException.NOT_SUPPORTED_ERR);
         }
         assertTrue("throw_NOT_SUPPORTED_ERR_3", success);
      }

      {
         boolean success = false;
         try {
            renamedPi = newDoc.renameNode(pi, "http://www.w3.org/DOM/Test", "pi");
          } catch (DOMException ex) {
            success = (ex.code == DOMException.NOT_SUPPORTED_ERR);
         }
         assertTrue("throw_NOT_SUPPORTED_ERR_4", success);
      }

      {
         boolean success = false;
         try {
            renamedEntRef = newDoc.renameNode(entref, "http://www.w3.org/DOM/Test", "entref");
          } catch (DOMException ex) {
            success = (ex.code == DOMException.NOT_SUPPORTED_ERR);
         }
         assertTrue("throw_NOT_SUPPORTED_ERR_5", success);
      }
}
   /**
    *  Gets URI that identifies the test.
    *  @return uri identifier of test
    */
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level3/core/documentrenamenode27";
   }
   /**
    * Runs this test from the command line.
    * @param args command line arguments
    */
   public static void main(final String[] args) {
        DOMTestCase.doMain(documentrenamenode27.class, args);
   }
}

