/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cpe.model;

import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.metadata.AnalysisEngineMetaData;
import org.apache.uima.collection.CasConsumerDescription;
import org.apache.uima.collection.metadata.CasProcessorConfigurationParameterSettings;
import org.apache.uima.collection.metadata.CasProcessorDeploymentParams;
import org.apache.uima.collection.metadata.CasProcessorErrorHandling;
import org.apache.uima.collection.metadata.CpeCasProcessor;
import org.apache.uima.collection.metadata.CpeCheckpoint;
import org.apache.uima.cpe.model.ConfigParametersModel;
import org.apache.uima.cpe.model.CpeDescriptorModel;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.metadata.ConfigurationParameterDeclarations;
import org.apache.uima.resource.metadata.ConfigurationParameterSettings;
import org.apache.uima.tools.debug.util.Trace;

public class CpeCasProcessorModel {
    private CpeCasProcessor cpeCasProcessor;
    private ConfigParametersModel configParamsModel;
    private ConfigurationParameterDeclarations configParamDecls = null;
    private ConfigurationParameterSettings configParamSettings = null;

    public CpeCasProcessorModel(CpeDescriptorModel parentModel, CpeCasProcessor cpeCasProcessor, ResourceSpecifier specifier) {
        this.cpeCasProcessor = cpeCasProcessor;
        if (specifier instanceof AnalysisEngineDescription) {
            AnalysisEngineMetaData a = ((AnalysisEngineDescription)specifier).getAnalysisEngineMetaData();
            this.configParamDecls = a.getConfigurationParameterDeclarations();
            this.configParamSettings = a.getConfigurationParameterSettings();
        } else if (specifier instanceof CasConsumerDescription) {
            this.configParamDecls = ((CasConsumerDescription)specifier).getCasConsumerMetaData().getConfigurationParameterDeclarations();
            this.configParamSettings = ((CasConsumerDescription)specifier).getCasConsumerMetaData().getConfigurationParameterSettings();
        }
        Trace.trace("Create CpeCasProcessorModel for " + cpeCasProcessor.getName());
        this.configParamsModel = new ConfigParametersModel(this.configParamDecls, this.configParamSettings, cpeCasProcessor.getConfigurationParameterSettings());
    }

    public ConfigParametersModel getConfigParamsModel() {
        return this.configParamsModel;
    }

    public void setConfigParamsModel(ConfigParametersModel configParamsModel) {
        this.configParamsModel = configParamsModel;
    }

    public ConfigurationParameterDeclarations getConfigurationParameterDeclarations() {
        return this.configParamDecls;
    }

    public ConfigurationParameterSettings getConfigurationParameterSettings() {
        return this.configParamSettings;
    }

    public CasProcessorConfigurationParameterSettings getCasProcessorConfigurationParameterSettings() {
        return this.cpeCasProcessor.getConfigurationParameterSettings();
    }

    public String getDescriptor() {
        return this.cpeCasProcessor.getDescriptor();
    }

    public String getName() {
        return this.cpeCasProcessor.getName();
    }

    public String getActionOnMaxError() {
        return this.cpeCasProcessor.getActionOnMaxError();
    }

    public String getActionOnMaxRestart() {
        return this.cpeCasProcessor.getActionOnMaxRestart();
    }

    public int getBatchSize() {
        return this.cpeCasProcessor.getBatchSize();
    }

    public String getCasProcessorFilter() {
        return this.cpeCasProcessor.getCasProcessorFilter();
    }

    public CpeCheckpoint getCheckpoint() {
        return this.cpeCasProcessor.getCheckpoint();
    }

    public String getDeployment() {
        return this.cpeCasProcessor.getDeployment();
    }

    public CasProcessorDeploymentParams getDeploymentParams() {
        return this.cpeCasProcessor.getDeploymentParams();
    }

    public CasProcessorErrorHandling getErrorHandling() {
        return this.cpeCasProcessor.getErrorHandling();
    }

    public int getMaxErrorCount() {
        return this.cpeCasProcessor.getMaxErrorCount();
    }

    public int getMaxErrorSampleSize() {
        return this.cpeCasProcessor.getMaxErrorSampleSize();
    }

    public int getMaxRestartCount() {
        return this.cpeCasProcessor.getMaxRestartCount();
    }

    public int getTimeout() {
        return this.cpeCasProcessor.getTimeout();
    }
}

