/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.textruler.learner.wien;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.textruler.TextRulerPlugin;
import org.apache.uima.ruta.textruler.core.TextRulerAnnotation;
import org.apache.uima.ruta.textruler.core.TextRulerBasicLearner;
import org.apache.uima.ruta.textruler.core.TextRulerExample;
import org.apache.uima.ruta.textruler.core.TextRulerExampleDocument;
import org.apache.uima.ruta.textruler.core.TextRulerRuleItem;
import org.apache.uima.ruta.textruler.core.TextRulerRulePattern;
import org.apache.uima.ruta.textruler.core.TextRulerSlotPattern;
import org.apache.uima.ruta.textruler.core.TextRulerTarget;
import org.apache.uima.ruta.textruler.core.TextRulerToolkit;
import org.apache.uima.ruta.textruler.extension.TextRulerLearner;
import org.apache.uima.ruta.textruler.extension.TextRulerLearnerDelegate;
import org.apache.uima.ruta.textruler.learner.wien.WienRule;
import org.apache.uima.ruta.textruler.learner.wien.WienRuleItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Wien
extends TextRulerBasicLearner {
    TextRulerRulePattern hPattern;
    TextRulerRulePattern tPattern;
    Map<String, PatternPair> headTailCache = new HashMap<String, PatternPair>();
    Map<String, List<TextRulerRulePattern>> interTupelSeparatorsCache = new HashMap<String, List<TextRulerRulePattern>>();
    ArrayList<PatternPair> patternPairs = new ArrayList();
    WienRule theRule;

    public Wien(String inputDir, String prePropTmFile, String tmpDir, String[] slotNames, Set<String> filterSet, TextRulerLearnerDelegate delegate) {
        super(inputDir, prePropTmFile, tmpDir, slotNames, filterSet, delegate);
    }

    @Override
    public boolean collectNegativeCoveredInstancesWhenTesting() {
        return false;
    }

    @Override
    protected void doRun() {
        TextRulerToolkit.log("-- WIEN START");
        this.headTailCache.clear();
        this.interTupelSeparatorsCache.clear();
        for (int i = 0; i < this.slotNames.length; ++i) {
            this.patternPairs.add(new PatternPair());
        }
        TextRulerTarget target = new TextRulerTarget(this.slotNames, (TextRulerBasicLearner)this);
        this.exampleDocuments.createExamplesForTarget(target);
        for (TextRulerExample e : this.exampleDocuments.getAllPositiveExamples()) {
            TextRulerToolkit.log("Example found: " + e);
        }
        try {
            boolean allOk = true;
            this.sendStatusUpdateToDelegate("Searching for right patterns...", TextRulerLearner.TextRulerLearnerState.ML_RUNNING, false);
            if (!this.findRightPatterns()) {
                allOk = false;
            }
            this.sendStatusUpdateToDelegate("Searching for left patterns...", TextRulerLearner.TextRulerLearnerState.ML_RUNNING, false);
            if (!this.findLeftPatterns()) {
                allOk = false;
            }
            this.sendStatusUpdateToDelegate("Searching for head, tail and left1 patterns...", TextRulerLearner.TextRulerLearnerState.ML_RUNNING, false);
            if (!this.findHeadTailAndL1Patterns()) {
                allOk = false;
            }
            if (allOk) {
                this.sendStatusUpdateToDelegate("Building multi-slot rule.", TextRulerLearner.TextRulerLearnerState.ML_RUNNING, false);
                this.theRule = new WienRule(this, target);
                List<TextRulerSlotPattern> rPatterns = this.theRule.getPatterns();
                int totalItemCount = 0;
                for (int k = 0; k < this.slotNames.length; ++k) {
                    WienRuleItem item;
                    int i;
                    WienRuleItem slotItem = new WienRuleItem((TextRulerAnnotation)null);
                    TextRulerSlotPattern rP = new TextRulerSlotPattern();
                    rPatterns.add(rP);
                    PatternPair p = this.patternPairs.get(k);
                    for (i = 0; i < p.l.size(); ++i) {
                        item = (WienRuleItem)p.l.get(i);
                        if (k == 0 && i == 0) {
                            item = item.copy();
                            item.addCondition("-AFTER(wien_tail)");
                            item.addCondition("-PARTOF(wien_rulemark)");
                        }
                        rP.preFillerPattern.add(item);
                        ++totalItemCount;
                    }
                    rP.fillerPattern.add(slotItem.copy());
                    ++totalItemCount;
                    for (i = 0; i < p.r.size(); ++i) {
                        item = (WienRuleItem)p.r.get(i);
                        ++totalItemCount;
                        if (k == this.slotNames.length - 1 && i == p.r.size() - 1) {
                            item = item.copy();
                            item.addAction("MARK(wien_rulemark, 1, " + totalItemCount + ")");
                        }
                        rP.postFillerPattern.add(item);
                    }
                    ++totalItemCount;
                }
                this.sendStatusUpdateToDelegate("Done", TextRulerLearner.TextRulerLearnerState.ML_DONE, true);
            } else {
                this.sendStatusUpdateToDelegate("Done - Not all patterns could be learned!", TextRulerLearner.TextRulerLearnerState.ML_DONE, true);
            }
        }
        catch (Exception e) {
            TextRulerPlugin.error(e);
            this.sendStatusUpdateToDelegate("Aborted due to Exception!", TextRulerLearner.TextRulerLearnerState.ML_ERROR, true);
        }
        this.headTailCache.clear();
        this.interTupelSeparatorsCache.clear();
        TextRulerToolkit.log("-- WIEN END");
    }

    protected boolean findRightPatterns() {
        TextRulerExampleDocument doc = this.exampleDocuments.getDocuments().get(0);
        boolean allFound = true;
        for (int k = 0; k < this.slotNames.length; ++k) {
            List<TextRulerRulePattern> rightContexts = this.getRightContextForSlot(doc, k);
            System.out.println(rightContexts.get(0));
            int shortest = Integer.MAX_VALUE;
            for (TextRulerRulePattern p : rightContexts) {
                shortest = p.size() < shortest ? p.size() : shortest;
            }
            boolean found = false;
            for (int len = 1; len <= shortest; ++len) {
                TextRulerRulePattern subPattern = rightContexts.get(0).subPattern(0, len);
                if (!this.testConstraint1(subPattern, k)) continue;
                this.patternPairs.get((int)k).r = subPattern;
                TextRulerToolkit.log("right " + k + ": " + subPattern);
                found = true;
                break;
            }
            if (found) continue;
            allFound = false;
        }
        return allFound;
    }

    protected boolean findLeftPatterns() {
        TextRulerExampleDocument doc = this.exampleDocuments.getDocuments().get(0);
        if (this.slotNames.length < 2) {
            return true;
        }
        boolean allFound = true;
        for (int k = 1; k < this.slotNames.length; ++k) {
            List<TextRulerRulePattern> leftContexts = this.getLeftContextForSlot(doc, k);
            int shortest = Integer.MAX_VALUE;
            for (TextRulerRulePattern p : leftContexts) {
                shortest = p.size() < shortest ? p.size() : shortest;
            }
            TextRulerRulePattern sourcePattern = leftContexts.get(0);
            boolean found = false;
            for (int len = 1; len <= shortest; ++len) {
                TextRulerRulePattern subPattern = sourcePattern.subPattern(sourcePattern.size() - len, len);
                if (!this.testConstraint2(subPattern, k)) continue;
                this.patternPairs.get((int)k).l = subPattern;
                for (TextRulerRuleItem i : subPattern) {
                    ((WienRuleItem)i).getWordConstraint().setGeneralizeLinkMarkUp(true);
                }
                TextRulerToolkit.log("left " + k + ": " + subPattern);
                found = true;
                break;
            }
            if (found) continue;
            allFound = false;
        }
        return allFound;
    }

    protected boolean findHeadTailAndL1Patterns() {
        List<TextRulerExampleDocument> docs = this.exampleDocuments.getDocuments();
        TextRulerExampleDocument doc0 = docs.get(0);
        TextRulerRulePattern head = new TextRulerRulePattern();
        TextRulerRulePattern tail = new TextRulerRulePattern();
        this.getPageHeadAndTailPortion(doc0, head, tail);
        List<TextRulerRulePattern> interTupleSeparators = this.getInterTupleSepatators(doc0);
        int shortestL1 = head.size() - 1;
        for (TextRulerRulePattern its : interTupleSeparators) {
            shortestL1 = its.size() < shortestL1 ? its.size() : shortestL1;
        }
        final class HLCandidate {
            public TextRulerRulePattern head = new TextRulerRulePattern();
            public TextRulerRulePattern l1 = new TextRulerRulePattern();

            HLCandidate() {
            }
        }
        ArrayList<HLCandidate> hlCandidates = new ArrayList<HLCandidate>();
        for (int separator = head.size() - 1; separator > 0; --separator) {
            HLCandidate c = new HLCandidate();
            for (int i = 0; i < head.size(); ++i) {
                if (i < separator) {
                    c.head.add(head.get(i));
                    continue;
                }
                WienRuleItem it = (WienRuleItem)((TextRulerRuleItem)head.get(i)).copy();
                it.getWordConstraint().setGeneralizeLinkMarkUp(true);
                c.l1.add(it);
            }
            hlCandidates.add(c);
            TextRulerToolkit.log(c.head.size() + " vs. " + c.l1.size());
            if (c.l1.size() >= shortestL1) break;
        }
        long total = 0L;
        long tCand = tail.size() * (tail.size() + 1) / 2;
        for (HLCandidate c : hlCandidates) {
            total += (long)((c.head.size() - 1) * c.head.size() / 2);
        }
        total *= tCand;
        long current = 0L;
        int oldPercent = -1;
        block4: for (HLCandidate c : hlCandidates) {
            TextRulerRulePattern l1 = c.l1;
            TextRulerRulePattern h = null;
            boolean l1Sucks = false;
            for (int endI = c.head.size() - 1; endI > 0; --endI) {
                for (int startI = endI; startI > 0; --startI) {
                    h = new TextRulerRulePattern();
                    for (int i = startI; i <= endI; ++i) {
                        h.add(c.head.get(i));
                    }
                    TextRulerRulePattern t = null;
                    for (int tstartI = 0; tstartI < tail.size(); ++tstartI) {
                        for (int tendI = tstartI; tendI < tail.size(); ++tendI) {
                            int percent = Math.round((float)current * 100.0f / (float)total);
                            if (percent != oldPercent) {
                                oldPercent = percent;
                                if (percent > 100) {
                                    percent = 100;
                                }
                                this.sendStatusUpdateToDelegate("Testing C3, " + percent + "%", TextRulerLearner.TextRulerLearnerState.ML_RUNNING, false);
                            }
                            if (this.shouldAbort()) {
                                return false;
                            }
                            ++current;
                            t = new TextRulerRulePattern();
                            for (int i = tstartI; i <= tendI; ++i) {
                                t.add(tail.get(i));
                            }
                            constraint3ReturnType c3Result = this.testConstraint3(h, t, l1);
                            if (c3Result == constraint3ReturnType.C3_SUCCESS) {
                                this.hPattern = h;
                                this.tPattern = t;
                                this.patternPairs.get((int)0).l = l1;
                                return true;
                            }
                            if (c3Result == constraint3ReturnType.C3_L1CandidateSuffixError || c3Result == constraint3ReturnType.C3_L1CandidateInterTupleSeparatorSuffixError) {
                                l1Sucks = true;
                                current += (long)(tail.size() - tendI - 1);
                                break;
                            }
                            if (c3Result == constraint3ReturnType.C3_TailCandidateH_L1Error || c3Result == constraint3ReturnType.C3_TailCandidateSucceedsL1InTailError) continue;
                            if (c3Result == constraint3ReturnType.C3_TailCandidateRK_PrefixError || c3Result == constraint3ReturnType.C3_TailCandidateNotFoundError) {
                                current += (long)(tail.size() - tendI - 1);
                                break;
                            }
                            if (c3Result != constraint3ReturnType.C3_TailCandidatePrecedesL1InterTupleSeparatorError) continue;
                        }
                        if (!l1Sucks) continue;
                        current += (long)((tail.size() - tstartI - 1) * (tail.size() - tstartI) / 2);
                        break;
                    }
                    if (!l1Sucks) continue;
                    if (startI <= 0) break;
                    current += (long)(startI - 1) * tCand;
                    break;
                }
                if (!l1Sucks) continue;
                current += (long)(endI * (endI + 1) / 2) * tCand;
                continue block4;
            }
        }
        return false;
    }

    protected void getPageHeadAndTailPortion(TextRulerExampleDocument doc, TextRulerRulePattern head, TextRulerRulePattern tail) {
        String key = doc.getCasFileName();
        if (this.headTailCache.containsKey(key)) {
            PatternPair p = this.headTailCache.get(key);
            head.addAll(p.l);
            tail.addAll(p.r);
        } else {
            CAS cas = doc.getCAS();
            TextRulerExample firstExample = doc.getPositiveExamples().get(0);
            TextRulerExample lastExample = doc.getPositiveExamples().get(doc.getPositiveExamples().size() - 1);
            TypeSystem ts = cas.getTypeSystem();
            Type tokenType = ts.getType("org.apache.uima.ruta.type.ALL");
            List<AnnotationFS> headTokens = TextRulerToolkit.getAnnotationsBeforePosition(cas, firstExample.getAnnotations()[0].getBegin(), 0, TextRulerToolkit.getFilterSetWithSlotNames(this.slotNames, this.filterSet), tokenType);
            TextRulerAnnotation[] lastExampleAnnotations = lastExample.getAnnotations();
            List<AnnotationFS> tailTokens = TextRulerToolkit.getAnnotationsAfterPosition(cas, lastExampleAnnotations[lastExampleAnnotations.length - 1].getEnd(), 0, TextRulerToolkit.getFilterSetWithSlotNames(this.slotNames, this.filterSet), tokenType);
            for (AnnotationFS afs : headTokens) {
                head.add(new WienRuleItem(new TextRulerAnnotation(afs, doc)));
            }
            for (AnnotationFS afs : tailTokens) {
                tail.add(new WienRuleItem(new TextRulerAnnotation(afs, doc)));
            }
            PatternPair p = new PatternPair();
            p.l.addAll(head);
            p.r.addAll(tail);
            this.headTailCache.put(key, p);
        }
    }

    protected List<TextRulerRulePattern> getInterTupleSepatators(TextRulerExampleDocument doc) {
        String key = doc.getCasFileName();
        if (this.interTupelSeparatorsCache.containsKey(key)) {
            return this.interTupelSeparatorsCache.get(key);
        }
        ArrayList<TextRulerRulePattern> result = new ArrayList<TextRulerRulePattern>();
        CAS cas = doc.getCAS();
        TypeSystem ts = cas.getTypeSystem();
        Type tokenType = ts.getType("org.apache.uima.ruta.type.ALL");
        List<TextRulerExample> examples = doc.getPositiveExamples();
        for (int i = 0; i < examples.size() - 1; ++i) {
            TextRulerAnnotation[] exampleAnnotations1 = examples.get(i).getAnnotations();
            TextRulerAnnotation[] exampleAnnotations2 = examples.get(i + 1).getAnnotations();
            TextRulerAnnotation lastOf1 = exampleAnnotations1[exampleAnnotations1.length - 1];
            TextRulerAnnotation firstOf2 = exampleAnnotations2[0];
            List<AnnotationFS> theTokens = TextRulerToolkit.getAnnotationsWithinBounds(cas, lastOf1.getEnd(), firstOf2.getBegin(), TextRulerToolkit.getFilterSetWithSlotNames(this.slotNames, this.filterSet), tokenType);
            TextRulerRulePattern thePattern = new TextRulerRulePattern();
            for (AnnotationFS afs : theTokens) {
                thePattern.add(new WienRuleItem(new TextRulerAnnotation(afs, doc)));
            }
            if (thePattern.size() <= 0) continue;
            result.add(thePattern);
        }
        this.interTupelSeparatorsCache.put(key, result);
        return result;
    }

    protected List<TextRulerRulePattern> getRightContextForSlot(TextRulerExampleDocument doc, int slotIndex) {
        ArrayList<TextRulerRulePattern> result = new ArrayList<TextRulerRulePattern>();
        CAS cas = doc.getCAS();
        TypeSystem ts = cas.getTypeSystem();
        Type tokenType = ts.getType("org.apache.uima.ruta.type.ALL");
        List<TextRulerExample> examples = doc.getPositiveExamples();
        boolean isLastSlot = slotIndex >= this.slotNames.length - 1;
        for (int ei = 0; ei < examples.size(); ++ei) {
            boolean isLastExample = ei == examples.size() - 1;
            TextRulerExample e = examples.get(ei);
            TextRulerAnnotation slotAnnotation = e.getAnnotations()[slotIndex];
            TextRulerAnnotation nextSlotAnnotation = !isLastSlot ? e.getAnnotations()[slotIndex + 1] : (!isLastExample ? examples.get(ei + 1).getAnnotations()[0] : null);
            List<AnnotationFS> theTokens = nextSlotAnnotation == null ? TextRulerToolkit.getAnnotationsAfterPosition(cas, slotAnnotation.getEnd(), 0, TextRulerToolkit.getFilterSetWithSlotNames(this.slotNames, this.filterSet), tokenType) : TextRulerToolkit.getAnnotationsWithinBounds(cas, slotAnnotation.getEnd(), nextSlotAnnotation.getBegin(), TextRulerToolkit.getFilterSetWithSlotNames(this.slotNames, this.filterSet), tokenType);
            TextRulerRulePattern thePattern = new TextRulerRulePattern();
            for (AnnotationFS afs : theTokens) {
                thePattern.add(new WienRuleItem(new TextRulerAnnotation(afs, doc)));
            }
            if (thePattern.size() <= 0) continue;
            result.add(thePattern);
        }
        return result;
    }

    protected List<TextRulerRulePattern> getLeftContextForSlot(TextRulerExampleDocument doc, int slotIndex) {
        if (slotIndex == 0) {
            return null;
        }
        ArrayList<TextRulerRulePattern> result = new ArrayList<TextRulerRulePattern>();
        CAS cas = doc.getCAS();
        TypeSystem ts = cas.getTypeSystem();
        Type tokenType = ts.getType("org.apache.uima.ruta.type.ALL");
        List<TextRulerExample> examples = doc.getPositiveExamples();
        boolean isFirstSlot = slotIndex == 0;
        for (int ei = 0; ei < examples.size(); ++ei) {
            boolean isFirstExample = ei == 0;
            TextRulerExample e = examples.get(ei);
            TextRulerAnnotation slotAnnotation = e.getAnnotations()[slotIndex];
            TextRulerAnnotation prevSlotAnnotation = !isFirstSlot ? e.getAnnotations()[slotIndex - 1] : (!isFirstExample ? examples.get(ei - 1).getAnnotations()[this.slotNames.length - 1] : null);
            List<AnnotationFS> theTokens = prevSlotAnnotation == null ? TextRulerToolkit.getAnnotationsBeforePosition(cas, slotAnnotation.getBegin(), 0, TextRulerToolkit.getFilterSetWithSlotNames(this.slotNames, this.filterSet), tokenType) : TextRulerToolkit.getAnnotationsWithinBounds(cas, prevSlotAnnotation.getEnd(), slotAnnotation.getBegin(), TextRulerToolkit.getFilterSetWithSlotNames(this.slotNames, this.filterSet), tokenType);
            TextRulerRulePattern thePattern = new TextRulerRulePattern();
            for (AnnotationFS afs : theTokens) {
                thePattern.add(new WienRuleItem(new TextRulerAnnotation(afs, doc), true));
            }
            if (thePattern.size() <= 0) continue;
            result.add(thePattern);
        }
        return result;
    }

    protected List<TextRulerRulePattern> getSlotFillerPatterns(TextRulerExampleDocument doc, int slotIndex) {
        ArrayList<TextRulerRulePattern> result = new ArrayList<TextRulerRulePattern>();
        CAS cas = doc.getCAS();
        TypeSystem ts = cas.getTypeSystem();
        Type tokenType = ts.getType("org.apache.uima.ruta.type.ALL");
        List<TextRulerExample> examples = doc.getPositiveExamples();
        for (TextRulerExample e : examples) {
            TextRulerAnnotation slotAnnotation = e.getAnnotations()[slotIndex];
            List<AnnotationFS> theTokens = TextRulerToolkit.getAnnotationsWithinBounds(cas, slotAnnotation.getBegin(), slotAnnotation.getEnd(), TextRulerToolkit.getFilterSetWithSlotNames(this.slotNames, this.filterSet), tokenType);
            TextRulerRulePattern thePattern = new TextRulerRulePattern();
            for (AnnotationFS afs : theTokens) {
                thePattern.add(new WienRuleItem(new TextRulerAnnotation(afs, doc)));
            }
            if (thePattern.size() <= 0) continue;
            result.add(thePattern);
        }
        return result;
    }

    protected constraint3ReturnType testConstraint3(TextRulerRulePattern h, TextRulerRulePattern t, TextRulerRulePattern l1) {
        for (TextRulerExampleDocument doc : this.exampleDocuments.getDocuments()) {
            constraint3ReturnType r = this.testConstraint3(doc, h, t, l1);
            if (r == constraint3ReturnType.C3_SUCCESS) continue;
            return r;
        }
        return constraint3ReturnType.C3_SUCCESS;
    }

    protected boolean testConstraint1(TextRulerExampleDocument doc, TextRulerRulePattern rk, int k) {
        List<TextRulerRulePattern> rightContexts = this.getRightContextForSlot(doc, k);
        for (TextRulerRulePattern rx : rightContexts) {
            if (rx.find(rk) == 0) continue;
            return false;
        }
        List<TextRulerRulePattern> contents = this.getSlotFillerPatterns(doc, k);
        for (TextRulerRulePattern c : contents) {
            if (c.find(rk) < 0) continue;
            return false;
        }
        return true;
    }

    protected boolean testConstraint1(TextRulerRulePattern rk, int k) {
        for (TextRulerExampleDocument doc : this.exampleDocuments.getDocuments()) {
            if (this.testConstraint1(doc, rk, k)) continue;
            return false;
        }
        return true;
    }

    protected boolean testConstraint2(TextRulerExampleDocument doc, TextRulerRulePattern lk, int k) {
        List<TextRulerRulePattern> leftContexts = this.getLeftContextForSlot(doc, k);
        for (TextRulerRulePattern lx : leftContexts) {
            if (lx.size() < lk.size()) {
                return false;
            }
            int pos = lx.find(lk);
            if (pos >= 0 && pos == lx.size() - lk.size()) continue;
            return false;
        }
        return true;
    }

    protected boolean testConstraint2(TextRulerRulePattern lk, int k) {
        for (TextRulerExampleDocument doc : this.exampleDocuments.getDocuments()) {
            if (this.testConstraint2(doc, lk, k)) continue;
            return false;
        }
        return true;
    }

    protected constraint3ReturnType testConstraint3(TextRulerExampleDocument doc, TextRulerRulePattern h, TextRulerRulePattern t, TextRulerRulePattern l1) {
        TextRulerRulePattern patternBetweenHandL1;
        boolean logReasons = false;
        TextRulerRulePattern head = new TextRulerRulePattern();
        TextRulerRulePattern tail = new TextRulerRulePattern();
        this.getPageHeadAndTailPortion(doc, head, tail);
        int hPos = head.find(h);
        TextRulerRulePattern restForL1 = head.subPattern(hPos + h.size(), -1).copy();
        for (TextRulerRuleItem it : restForL1) {
            ((WienRuleItem)it).getWordConstraint().setGeneralizeLinkMarkUp(true);
        }
        int l1Pos = restForL1.find(l1);
        if (l1Pos < 0 || l1Pos != restForL1.size() - l1.size()) {
            TextRulerToolkit.logIf(false, "REASON 1\n\tl1         \t" + l1 + "\n\trestforl1\t" + restForL1);
            return constraint3ReturnType.C3_L1CandidateSuffixError;
        }
        if (l1Pos > 0 && (patternBetweenHandL1 = restForL1.subPattern(0, l1Pos)).size() >= t.size() && patternBetweenHandL1.find(t) >= 0) {
            TextRulerToolkit.logIf(false, "REASON 2");
            return constraint3ReturnType.C3_TailCandidateH_L1Error;
        }
        TextRulerRulePattern lastSlotRightPattern = this.patternPairs.get((int)(this.slotNames.length - 1)).r;
        if (t.find(lastSlotRightPattern) == 0) {
            TextRulerToolkit.logIf(false, "REASON 3: " + lastSlotRightPattern + "\tTail: " + t);
            return constraint3ReturnType.C3_TailCandidateRK_PrefixError;
        }
        int tPos = tail.find(t);
        if (tPos < 0) {
            TextRulerToolkit.logIf(false, "REASON 4");
            return constraint3ReturnType.C3_TailCandidateNotFoundError;
        }
        int l1tPos = tail.find(l1);
        if (l1tPos >= 0 && l1tPos < tPos) {
            TextRulerToolkit.logIf(false, "REASON 5");
            return constraint3ReturnType.C3_TailCandidateSucceedsL1InTailError;
        }
        List<TextRulerRulePattern> interTupleSeparators = this.getInterTupleSepatators(doc);
        for (TextRulerRulePattern itSep : interTupleSeparators) {
            TextRulerRulePattern itSepCopy = itSep.copy();
            for (TextRulerRuleItem it : itSepCopy) {
                ((WienRuleItem)it).getWordConstraint().setGeneralizeLinkMarkUp(true);
            }
            int l1itsPos = itSepCopy.find(l1);
            if (l1itsPos < 0 || l1itsPos != itSepCopy.size() - l1.size()) {
                TextRulerToolkit.logIf(false, "REASON 6: \n\tl1\t" + l1 + "\n\titSep\t" + itSep);
                return constraint3ReturnType.C3_L1CandidateInterTupleSeparatorSuffixError;
            }
            int itstPos = itSep.find(t);
            if (itstPos < 0 || itstPos >= l1itsPos) continue;
            TextRulerToolkit.logIf(false, "REASON 7");
            return constraint3ReturnType.C3_TailCandidatePrecedesL1InterTupleSeparatorError;
        }
        return constraint3ReturnType.C3_SUCCESS;
    }

    @Override
    public String getResultString() {
        if (this.theRule == null) {
            return "<no results yet>";
        }
        String result = this.getTMFileHeaderString() + "DECLARE wien_tail;\n" + "DECLARE wien_rulemark;\n" + "DECLARE wien_content;\n" + "BOOLEAN wien_redo;\n\n" + "// tail/head/content area stuff:\n";
        TextRulerRulePattern hCopy = this.hPattern.copy();
        ((WienRuleItem)hCopy.get(0)).addCondition("-PARTOF(wien_content)");
        result = result + hCopy + " ALL*?{->MARK(wien_content)};\n";
        TextRulerRulePattern tCopy = this.tPattern.copy();
        ((WienRuleItem)tCopy.get(0)).addCondition("PARTOF(wien_content)");
        result = result + tCopy + "{->MARK(wien_tail";
        if (this.tPattern.size() > 1) {
            result = result + ", 1, " + this.tPattern.size();
        }
        result = result + ")};\n\n";
        result = result + "BLOCK(findData) wien_content {\n\t// find out if tail is before the next occurence of l1\n\t" + this.theRule.getRuleString() + "\n" + "\tDocument{->ASSIGN(wien_redo, false)};\n" + "\twien_tail{PARTOF(wien_rulemark)->UNMARK(wien_tail), ASSIGN(wien_redo, true)}; // remove tail marks that are no longer relevant for us after the last rule !\n" + "\tDocument{IF(wien_redo)->CALL(filename.findData)};\n" + "}\n";
        result = result + "\n// cleaning up:\nwien_tail{->UNMARK(wien_tail)};\nwien_rulemark{->UNMARK(wien_rulemark)};\nwien_content{->UNMARK(wien_content)};\n";
        return result;
    }

    @Override
    public void setParameters(Map<String, Object> params) {
    }

    public static class PatternPair {
        public TextRulerRulePattern l = new TextRulerRulePattern();
        public TextRulerRulePattern r = new TextRulerRulePattern();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum constraint3ReturnType {
        C3_SUCCESS,
        C3_L1CandidateSuffixError,
        C3_TailCandidateH_L1Error,
        C3_TailCandidateRK_PrefixError,
        C3_TailCandidateNotFoundError,
        C3_TailCandidateSucceedsL1InTailError,
        C3_L1CandidateInterTupleSeparatorSuffixError,
        C3_TailCandidatePrecedesL1InterTupleSeparatorError;

    }
}

