/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.ide.ui.text;

import java.util.HashSet;
import org.apache.uima.ruta.ide.RutaIdePlugin;
import org.apache.uima.ruta.ide.ui.text.Messages;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.InterpreterContainerHelper;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.dltk.ui.editor.IScriptAnnotation;
import org.eclipse.dltk.ui.text.IAnnotationResolution;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IMarkerResolution;

final class RutaRequirePackageMarkerResolution
implements IMarkerResolution,
IAnnotationResolution {
    private String pkgName;
    private IScriptProject project;

    public RutaRequirePackageMarkerResolution(String pkgName, IScriptProject scriptProject) {
        this.pkgName = pkgName;
        this.project = scriptProject;
    }

    public String getLabel() {
        String msg = Messages.RutaRequirePackageMarkerResolution_addPackageToBuildpath;
        return NLS.bind((String)msg, (Object)this.pkgName);
    }

    private boolean resolve() {
        try {
            IInterpreterInstall install = ScriptRuntime.getInterpreterInstall((IScriptProject)this.project);
            if (install != null) {
                HashSet<String> names = new HashSet<String>();
                HashSet autoNames = new HashSet();
                InterpreterContainerHelper.getInterpreterContainerDependencies((IScriptProject)this.project, names, autoNames);
                if (names.add(this.pkgName)) {
                    InterpreterContainerHelper.setInterpreterContainerDependencies((IScriptProject)this.project, names, autoNames);
                    return true;
                }
            }
        }
        catch (CoreException e) {
            RutaIdePlugin.error("require package resolve error", e);
        }
        return false;
    }

    public void run(IMarker marker) {
        block3: {
            if (this.resolve()) {
                try {
                    marker.delete();
                }
                catch (CoreException e) {
                    if (!DLTKCore.DEBUG) break block3;
                    e.printStackTrace();
                }
            }
        }
    }

    public void run(Annotation annotation, IDocument document) {
        this.resolve();
    }

    public void run(IScriptAnnotation annotation, IDocument document) {
        this.resolve();
    }
}

