/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.rule;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaBlock;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.expression.string.StringExpression;
import org.apache.uima.ruta.rule.RutaMatcher;
import org.apache.uima.ruta.rule.RutaRuleElement;
import org.apache.uima.ruta.type.RutaBasic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RutaLiteralMatcher
implements RutaMatcher {
    private final StringExpression expression;

    public RutaLiteralMatcher(StringExpression expression) {
        this.expression = expression;
    }

    public List<AnnotationFS> getMatchingAnnotations(RutaStream stream, RutaBlock parent) {
        ArrayList<AnnotationFS> result = new ArrayList<AnnotationFS>();
        AnnotationFS windowAnnotation = stream.getDocumentAnnotation();
        List<RutaBasic> list = stream.getBasicsInWindow(windowAnnotation);
        for (RutaBasic each : list) {
            if (!each.getCoveredText().equals(this.expression.getStringValue(parent))) continue;
            result.add((AnnotationFS)each);
        }
        return result;
    }

    @Override
    public boolean match(AnnotationFS annotation, RutaStream stream, RutaBlock parent) {
        if (annotation == null) {
            return false;
        }
        return annotation.getCoveredText().equals(this.expression.getStringValue(parent));
    }

    public String toString() {
        return "\"" + this.expression.toString() + "\"";
    }

    @Override
    public StringExpression getExpression() {
        return this.expression;
    }

    @Override
    public int estimateAnchors(RutaBlock parent, RutaStream stream) {
        return Integer.MAX_VALUE;
    }

    @Override
    public Collection<AnnotationFS> getAnnotationsAfter(RutaRuleElement ruleElement, AnnotationFS annotation, RutaStream stream, RutaBlock parent) {
        return this.getNextAnnotations(false, annotation, stream, parent);
    }

    @Override
    public Collection<AnnotationFS> getAnnotationsBefore(RutaRuleElement ruleElement, AnnotationFS annotation, RutaStream stream, RutaBlock parent) {
        return this.getNextAnnotations(true, annotation, stream, parent);
    }

    private Collection<AnnotationFS> getNextAnnotations(boolean before, AnnotationFS annotation, RutaStream stream, RutaBlock parent) {
        ArrayList<AnnotationFS> result = new ArrayList<AnnotationFS>(1);
        RutaBasic basicNextTo = stream.getBasicNextTo(before, annotation);
        if (basicNextTo == null) {
            return result;
        }
        String stringValue = this.expression.getStringValue(parent);
        if (stringValue.equals(basicNextTo.getCoveredText())) {
            result.add((AnnotationFS)basicNextTo);
        }
        return result;
    }

    @Override
    public List<Type> getTypes(RutaBlock parent, RutaStream stream) {
        return new ArrayList<Type>();
    }
}

