/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.condition;

import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaEnvironment;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.condition.AbstractRutaCondition;
import org.apache.uima.ruta.rule.EvaluatedCondition;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class ParseCondition
extends AbstractRutaCondition {
    private final String var;

    public ParseCondition(String var) {
        this.var = var;
    }

    public EvaluatedCondition eval(AnnotationFS annotation, RuleElement element, RutaStream stream, InferenceCrowd crowd) {
        String text = annotation.getCoveredText();
        RutaEnvironment env = element.getParent().getEnvironment();
        Class<?> type = env.getVariableType(this.var);
        try {
            if (Integer.class.equals(type)) {
                text = this.normalizeNumber(text);
                int value = Integer.valueOf(text);
                env.setVariableValue(this.var, value);
                return new EvaluatedCondition(this, true);
            }
            if (Double.class.equals(type)) {
                text = this.normalizeNumber(text);
                double value = Double.valueOf(text);
                env.setVariableValue(this.var, value);
                return new EvaluatedCondition(this, true);
            }
            if (String.class.equals(type)) {
                env.setVariableValue(this.var, text);
                return new EvaluatedCondition(this, true);
            }
            if (Boolean.class.equals(type)) {
                env.setVariableValue(this.var, Boolean.valueOf(text));
                return new EvaluatedCondition(this, true);
            }
            if (Type.class.equals(type)) {
                Type value = stream.getCas().getTypeSystem().getType(text);
                env.setVariableValue(this.var, value);
                return new EvaluatedCondition(this, true);
            }
            return new EvaluatedCondition(this, false);
        }
        catch (Exception e) {
            return new EvaluatedCondition(this, false);
        }
    }

    private String normalizeNumber(String text) {
        String[] split = text.split("[,]");
        if (split.length == 2) {
            return text.replaceAll(",", ".");
        }
        return text;
    }

    public String getVar() {
        return this.var;
    }
}

