/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.action;

import java.util.ArrayList;
import java.util.List;
import org.apache.uima.ruta.RutaBlock;
import org.apache.uima.ruta.RutaStatement;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.action.AbstractRutaAction;
import org.apache.uima.ruta.expression.RutaExpression;
import org.apache.uima.ruta.expression.bool.BooleanExpression;
import org.apache.uima.ruta.expression.list.ListExpression;
import org.apache.uima.ruta.expression.number.NumberExpression;
import org.apache.uima.ruta.expression.string.StringExpression;
import org.apache.uima.ruta.expression.type.TypeExpression;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.rule.RuleMatch;
import org.apache.uima.ruta.visitor.InferenceCrowd;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveAction
extends AbstractRutaAction {
    private String var;
    private List<RutaExpression> elements;

    public RemoveAction(String var, List<RutaExpression> list) {
        this.var = var;
        this.elements = list;
    }

    public String getListExpr() {
        return this.var;
    }

    public List<RutaExpression> getElements() {
        return this.elements;
    }

    @Override
    public void execute(RuleMatch match, RuleElement element, RutaStream stream, InferenceCrowd crowd) {
        RutaBlock parent = element.getParent();
        List list = ((RutaStatement)parent).getEnvironment().getVariableValue(this.var, List.class);
        ArrayList toRemove = new ArrayList();
        for (Object entry : list) {
            Object value1 = this.getValue(entry, parent);
            for (RutaExpression arg : this.elements) {
                if (arg instanceof ListExpression) {
                    ListExpression l = (ListExpression)arg;
                    List list2 = l.getList(parent);
                    for (Object object : list2) {
                        Object value2 = this.getValue(object, parent);
                        if (!value1.equals(value2)) continue;
                        toRemove.add(entry);
                    }
                    continue;
                }
                Object value2 = this.getValue(arg, parent);
                if (!value1.equals(value2)) continue;
                toRemove.add(entry);
            }
        }
        for (Object object : toRemove) {
            list.remove(object);
        }
        ((RutaStatement)parent).getEnvironment().setVariableValue(this.var, list);
    }

    private Object getValue(Object obj, RutaStatement parent) {
        if (obj instanceof NumberExpression) {
            return ((NumberExpression)obj).getDoubleValue(parent);
        }
        if (obj instanceof BooleanExpression) {
            return ((BooleanExpression)obj).getBooleanValue(parent);
        }
        if (obj instanceof TypeExpression) {
            return ((TypeExpression)obj).getType(parent);
        }
        if (obj instanceof StringExpression) {
            return ((StringExpression)obj).getStringValue(parent);
        }
        return null;
    }
}

