/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.testing.evaluator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.CASRuntimeException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.ruta.seed.DefaultSeeder;
import org.apache.uima.ruta.testing.evaluator.ICasEvaluator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WordTemplateCasEvaluator
implements ICasEvaluator {
    @Override
    public CAS evaluate(CAS test, CAS run, Collection<String> excludedTypes) throws CASRuntimeException, CASException {
        Type falsePositiveType = run.getTypeSystem().getType("org.apache.uima.ruta.type.FalsePositive");
        Type falseNegativeType = run.getTypeSystem().getType("org.apache.uima.ruta.type.FalseNegative");
        Type truePositveType = run.getTypeSystem().getType("org.apache.uima.ruta.type.TruePositive");
        Feature feature = falsePositiveType.getFeatureByBaseName("original");
        List allTypes = test.getTypeSystem().getProperlySubsumedTypes(test.getTypeSystem().getTopType());
        ArrayList<Type> types = new ArrayList<Type>();
        TypeSystem typeSystem = test.getTypeSystem();
        Type annotationType = test.getAnnotationType();
        block0: for (Type eachType : allTypes) {
            if (excludedTypes.contains(eachType.getName())) continue;
            List features = eachType.getFeatures();
            for (Feature f : features) {
                Type range = f.getRange();
                if (!typeSystem.subsumes(annotationType, range) || eachType.getName().startsWith("org.apache.uima.ruta.type")) continue;
                types.add(eachType);
                continue block0;
            }
        }
        List<Type> wordTypes = this.getWordTypes(run);
        Collection<FeatureStructure> testFSs = this.getFeatureStructures(types, test, wordTypes);
        Collection<FeatureStructure> runFSs = this.getFeatureStructures(types, run, wordTypes);
        HashSet<FeatureStructure> matched = new HashSet<FeatureStructure>();
        ArrayList<FeatureStructure> fp = new ArrayList<FeatureStructure>();
        ArrayList<FeatureStructure> fn = new ArrayList<FeatureStructure>();
        ArrayList<FeatureStructure> tp = new ArrayList<FeatureStructure>();
        if (test.getAnnotationIndex(test.getTypeSystem().getType("org.apache.uima.ruta.type.RutaBasic")).size() == 0) {
            DefaultSeeder scanner = new DefaultSeeder();
            scanner.seed(test.getDocumentText(), test);
        }
        for (FeatureStructure eachTest : testFSs) {
            FeatureStructure original;
            Type type;
            FeatureStructure createFS;
            boolean found = false;
            for (FeatureStructure eachRun : runFSs) {
                if (!this.match(eachTest, eachRun, wordTypes)) continue;
                matched.add(eachRun);
                found = true;
                break;
            }
            if (!found) {
                createFS = run.createFS(falseNegativeType);
                this.fillFS(eachTest, createFS, false);
                type = run.getTypeSystem().getType(eachTest.getType().getName());
                original = run.createFS(type);
                this.fillFS(eachTest, original, true);
                createFS.setFeatureValue(feature, original);
                fn.add(createFS);
                continue;
            }
            createFS = run.createFS(truePositveType);
            this.fillFS(eachTest, createFS, false);
            type = run.getTypeSystem().getType(eachTest.getType().getName());
            original = run.createFS(type);
            this.fillFS(eachTest, original, true);
            createFS.setFeatureValue(feature, original);
            tp.add(createFS);
        }
        for (FeatureStructure each : runFSs) {
            if (matched.contains(each)) continue;
            FeatureStructure createFS = run.createFS(falsePositiveType);
            this.fillFS(each, createFS, false);
            Type type = run.getTypeSystem().getType(each.getType().getName());
            FeatureStructure original = run.createFS(type);
            this.fillFS(each, original, true);
            createFS.setFeatureValue(feature, original);
            fp.add(createFS);
        }
        for (FeatureStructure fs : fn) {
            run.addFsToIndexes(fs);
        }
        for (FeatureStructure fs : fp) {
            run.addFsToIndexes(fs);
        }
        for (FeatureStructure fs : tp) {
            run.addFsToIndexes(fs);
        }
        return run;
    }

    private List<Type> getWordTypes(CAS test) {
        ArrayList<Type> result = new ArrayList<Type>();
        result.add(test.getTypeSystem().getType("org.apache.uima.ruta.type.W"));
        result.add(test.getTypeSystem().getType("org.apache.uima.ruta.type.NUM"));
        return result;
    }

    private void fillFS(FeatureStructure fs, FeatureStructure newFS, boolean withFeatures) {
        if (fs instanceof AnnotationFS) {
            Annotation a = (Annotation)newFS;
            a.setBegin(((AnnotationFS)fs).getBegin());
            a.setEnd(((AnnotationFS)fs).getEnd());
        }
        if (withFeatures) {
            CAS testCas = fs.getCAS();
            CAS runCas = newFS.getCAS();
            TypeSystem testTS = testCas.getTypeSystem();
            TypeSystem runTS = runCas.getTypeSystem();
            Type annotationType = testCas.getAnnotationType();
            List features = fs.getType().getFeatures();
            for (Feature feature : features) {
                FeatureStructure valueTest;
                Type range = feature.getRange();
                if (!testTS.subsumes(annotationType, range) || !((valueTest = fs.getFeatureValue(feature)) instanceof AnnotationFS)) continue;
                AnnotationFS a1 = (AnnotationFS)valueTest;
                Feature feature2 = newFS.getType().getFeatureByBaseName(feature.getShortName());
                if (feature == null) continue;
                Type range2 = runTS.getType(range.getName());
                AnnotationFS createAnnotation = runCas.createAnnotation(range2, a1.getBegin(), a1.getEnd());
                newFS.setFeatureValue(feature2, (FeatureStructure)createAnnotation);
            }
        }
    }

    private Collection<FeatureStructure> getFeatureStructures(List<Type> types, CAS cas, List<Type> basicTypes) {
        TypeSystem typeSystem = cas.getTypeSystem();
        Type annotationType = cas.getAnnotationType();
        HashSet<FeatureStructure> result = new HashSet<FeatureStructure>();
        for (Type type : types) {
            FSIterator iterator = cas.getIndexRepository().getAllIndexedFS(type);
            while (iterator.isValid()) {
                FeatureStructure fs = iterator.get();
                List features = fs.getType().getFeatures();
                for (Feature feature : features) {
                    Type range = feature.getRange();
                    if (!typeSystem.subsumes(annotationType, range)) continue;
                    result.add(fs);
                    break;
                }
                iterator.moveToNext();
            }
        }
        return result;
    }

    private List<AnnotationFS> expand(AnnotationFS a, CAS cas, List<Type> basicTypes) {
        LinkedList<AnnotationFS> result = new LinkedList<AnnotationFS>();
        for (Type basicType : basicTypes) {
            AnnotationFS window = cas.createAnnotation(basicType, a.getBegin(), a.getEnd());
            FSIterator iterator = cas.getAnnotationIndex(basicType).subiterator(window);
            while (iterator.isValid()) {
                AnnotationFS basic = (AnnotationFS)iterator.get();
                if (cas.getTypeSystem().subsumes(basicType, basic.getType()) && basic.getBegin() >= a.getBegin() && basic.getEnd() <= a.getEnd()) {
                    result.add(cas.createAnnotation(a.getType(), basic.getBegin(), basic.getEnd()));
                }
                iterator.moveToNext();
            }
        }
        return result;
    }

    private boolean match(FeatureStructure a1, FeatureStructure a2, List<Type> basicTypes) {
        Type type1 = a1.getType();
        Type type2 = a2.getType();
        if (!type1.getName().equals(type2.getName())) {
            return false;
        }
        if (a1 instanceof AnnotationFS && a2 instanceof AnnotationFS) {
            AnnotationFS a11 = (AnnotationFS)a1;
            AnnotationFS a22 = (AnnotationFS)a2;
            if (a11.getBegin() != a22.getBegin() || a11.getEnd() != a22.getEnd()) {
                return false;
            }
        }
        CAS cas = a1.getCAS();
        TypeSystem typeSystem = cas.getTypeSystem();
        Type annotationType = cas.getAnnotationType();
        List features1 = type1.getFeatures();
        boolean result = true;
        boolean allEmpty1 = true;
        boolean allEmpty2 = true;
        for (Feature eachFeature1 : features1) {
            Type range = eachFeature1.getRange();
            if (!typeSystem.subsumes(annotationType, range)) continue;
            String name = eachFeature1.getShortName();
            Feature eachFeature2 = type2.getFeatureByBaseName(name);
            FeatureStructure featureValue1 = a1.getFeatureValue(eachFeature1);
            FeatureStructure featureValue2 = a2.getFeatureValue(eachFeature2);
            allEmpty1 &= featureValue1 == null;
            allEmpty2 &= featureValue2 == null;
            if (featureValue1 instanceof AnnotationFS && featureValue2 instanceof AnnotationFS) {
                result &= this.matchAnnotations((AnnotationFS)featureValue1, (AnnotationFS)featureValue2, basicTypes);
                continue;
            }
            if (featureValue1 == null || featureValue1 == null && featureValue2 == null) continue;
            return false;
        }
        return result && allEmpty1 == allEmpty2;
    }

    private boolean matchAnnotations(AnnotationFS a1, AnnotationFS a2, List<Type> basicTypes) {
        List<AnnotationFS> w1 = this.expand(a1, a1.getCAS(), basicTypes);
        List<AnnotationFS> w2 = this.expand(a2, a2.getCAS(), basicTypes);
        boolean result = true;
        int i = 0;
        for (AnnotationFS each1 : w1) {
            if (w2.size() > i) {
                AnnotationFS each2 = w2.get(i);
                result &= this.matchWord(each1, each2);
            } else {
                return false;
            }
            ++i;
        }
        return result;
    }

    private boolean matchWord(AnnotationFS a1, AnnotationFS a2) {
        return a1 != null && a2 != null && a1.getBegin() == a2.getBegin() && a1.getEnd() == a2.getEnd() && a1.getType().getName().equals(a2.getType().getName());
    }
}

