/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.bundlesupport.fsresource;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.sling.commons.osgi.ManifestHeader;
import org.apache.sling.maven.bundlesupport.fsresource.FsMode;
import org.apache.sling.maven.bundlesupport.fsresource.FsMountHelper;
import org.apache.sling.maven.bundlesupport.fsresource.FsResourceConfiguration;

public final class SlingInitialContentMounter {
    private static final String HEADER_INITIAL_CONTENT = "Sling-Initial-Content";
    private final Log log;
    private final MavenProject project;
    private final FsMountHelper helper;

    public SlingInitialContentMounter(Log log, CloseableHttpClient httpClient, RequestConfig.Builder requestConfigBuilder, MavenProject project) {
        this.log = log;
        this.project = project;
        this.helper = new FsMountHelper(log, httpClient, requestConfigBuilder, project);
    }

    public void mount(URI consoleTargetUrl, File bundleFile) throws MojoExecutionException {
        ManifestHeader.Entry[] entries;
        ManifestHeader header = null;
        try {
            Manifest mf = this.getManifest(bundleFile);
            String value = mf.getMainAttributes().getValue(HEADER_INITIAL_CONTENT);
            if (value == null) {
                this.log.warn((CharSequence)"Bundle has no initial content - no file system provider config created.");
                return;
            }
            header = ManifestHeader.parse((String)value);
            if (header == null || header.getEntries().length == 0) {
                this.log.warn((CharSequence)("Unable to parse header or header is empty: " + value));
                return;
            }
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Unable to read manifest from file " + bundleFile, (Exception)ioe);
        }
        this.log.info((CharSequence)"Trying to configure file system provider for Sling initial content...");
        List resources = this.project.getResources();
        if (resources == null || resources.isEmpty()) {
            throw new MojoExecutionException("No resources configured for this project.");
        }
        ArrayList<FsResourceConfiguration> cfgs = new ArrayList<FsResourceConfiguration>();
        for (ManifestHeader.Entry entry : entries = header.getEntries()) {
            String ignoreValue;
            Object path = entry.getValue();
            if (path != null && !((String)path).endsWith("/")) {
                path = (String)path + "/";
            }
            if ((ignoreValue = entry.getDirectiveValue("maven:mount")) != null && ignoreValue.equalsIgnoreCase("false")) {
                this.log.debug((CharSequence)("Ignoring " + (String)path));
                continue;
            }
            String installPath = entry.getDirectiveValue("path");
            if (installPath == null) {
                installPath = "/";
            }
            File dir = null;
            Iterator i = resources.iterator();
            while (dir == null && i.hasNext()) {
                Resource rsrc = (Resource)i.next();
                Object child = path;
                Object targetPath = rsrc.getTargetPath();
                if (targetPath != null && !((String)targetPath).endsWith("/")) {
                    targetPath = (String)targetPath + "/";
                }
                this.log.debug((CharSequence)("Checking if project resource '" + rsrc.getDirectory() + "' with target path '" + (String)targetPath + "' is a potential mount point for " + (String)path + " ..."));
                if (targetPath != null && path != null && ((String)path).startsWith((String)targetPath)) {
                    child = ((String)child).substring(((String)targetPath).length());
                }
                if ((dir = new File(rsrc.getDirectory(), (String)child)).exists()) continue;
                dir = null;
            }
            if (dir == null) {
                throw new MojoExecutionException("No resource entry found containing " + (String)path);
            }
            if ("/".equals(installPath)) {
                throw new MojoExecutionException("Mapping to root path not supported by fs provider at the moment. Please adapt your initial content configuration.");
            }
            StringBuilder importOptions = new StringBuilder();
            String overwriteValue = entry.getDirectiveValue("overwrite");
            if (StringUtils.isNotBlank((CharSequence)overwriteValue)) {
                importOptions.append("overwrite:=" + overwriteValue);
            }
            String ignoreImportProvidersValue = entry.getDirectiveValue("ignoreImportProviders");
            if (StringUtils.isNotBlank((CharSequence)overwriteValue)) {
                if (importOptions.length() > 0) {
                    importOptions.append(";");
                }
                importOptions.append("ignoreImportProviders:=\"" + ignoreImportProvidersValue + "\"");
            }
            cfgs.add(new FsResourceConfiguration().fsMode(FsMode.INITIAL_CONTENT).fsRootPath(dir.getAbsoluteFile()).resourceRootPath(installPath).initialContentImportOptions(importOptions.toString()));
            this.log.info((CharSequence)("Created new configuration for resource path " + installPath));
        }
        if (!cfgs.isEmpty()) {
            this.helper.addConfigurations(consoleTargetUrl, cfgs);
        }
    }

    public void unmount(URI consoleTargetUrl) throws MojoExecutionException {
        this.log.info((CharSequence)"Removing file system provider configurations...");
        Map<String, FsResourceConfiguration> oldConfigs = this.helper.getCurrentConfigurations(consoleTargetUrl);
        this.helper.removeConfigurations(consoleTargetUrl, oldConfigs);
    }

    private Manifest getManifest(File bundleFile) throws IOException {
        try (JarFile file = new JarFile(bundleFile);){
            Manifest manifest = file.getManifest();
            return manifest;
        }
    }
}

