/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.xss.impl.xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import org.apache.sling.xss.impl.InvalidConfigException;
import org.apache.sling.xss.impl.xml.AntiSamyRules;
import org.apache.sling.xss.impl.xml.AntiSamyXmlParser;
import org.apache.sling.xss.impl.xml.Attribute;
import org.apache.sling.xss.impl.xml.IncludeExcludeMatcher;
import org.apache.sling.xss.impl.xml.MapBuilder;
import org.apache.sling.xss.impl.xml.Property;
import org.apache.sling.xss.impl.xml.Tag;

public class AntiSamyPolicy {
    protected final Map<String, Pattern> commonRegularExpressions = new HashMap<String, Pattern>();
    protected final Map<String, Attribute> commonAttributes = new HashMap<String, Attribute>();
    protected final Map<String, Tag> tagRules = new HashMap<String, Tag>();
    protected final Map<String, Property> cssRules = new HashMap<String, Property>();
    protected final Map<String, String> directives = new HashMap<String, String>();
    protected final Map<String, Attribute> globalAttributes = new HashMap<String, Attribute>();
    protected final Map<String, Attribute> dynamicAttributes = new HashMap<String, Attribute>();
    protected final List<String> requireClosingTags = new ArrayList<String>();
    protected List<String> allowedEmptyTags = new ArrayList<String>();

    public AntiSamyPolicy(InputStream input) throws InvalidConfigException, XMLStreamException, IOException {
        AntiSamyXmlParser xmlParser = new AntiSamyXmlParser();
        MapBuilder mapBuilder = new MapBuilder();
        AntiSamyRules root = xmlParser.createRules(input);
        mapBuilder.createRulesMap(this, root);
    }

    public Map<String, String> getDirectives() {
        return this.directives;
    }

    public List<String> getRequireClosingTags() {
        return this.requireClosingTags;
    }

    public Map<String, Pattern> getCommonRegularExpressions() {
        return this.commonRegularExpressions;
    }

    public Map<String, Attribute> getGlobalAttributes() {
        return this.globalAttributes;
    }

    public Map<String, Attribute> getCommonAttributes() {
        return this.commonAttributes;
    }

    public Map<String, Property> getCssRules() {
        return this.cssRules;
    }

    public List<String> getAllowedEmptyTags() {
        return this.allowedEmptyTags;
    }

    public Map<String, Tag> getTagRules() {
        return this.tagRules;
    }

    public Map<String, Attribute> getDynamicAttributes() {
        return this.dynamicAttributes;
    }

    public CssPolicy getCssPolicy() {
        return new CssPolicy(this.cssRules, this.commonRegularExpressions);
    }

    public static class CssPolicy {
        private final Map<String, Property> cssRules;
        private final IncludeExcludeMatcher elementMatcher;
        private final IncludeExcludeMatcher classMatcher;
        private final IncludeExcludeMatcher idMatcher;
        private final IncludeExcludeMatcher pseudoElementMatcher;
        private final IncludeExcludeMatcher attributeMatcher;

        public CssPolicy(Map<String, Property> cssrules, Map<String, Pattern> commonRegExps) {
            this.cssRules = Collections.unmodifiableMap(cssrules);
            this.elementMatcher = new IncludeExcludeMatcher(commonRegExps.get("cssElementSelector"), commonRegExps.get("cssElementExclusion"));
            this.classMatcher = new IncludeExcludeMatcher(commonRegExps.get("cssClassSelector"), commonRegExps.get("cssClassExclusion"));
            this.idMatcher = new IncludeExcludeMatcher(commonRegExps.get("cssIDSelector"), commonRegExps.get("cssIDExclusion"));
            this.pseudoElementMatcher = new IncludeExcludeMatcher(commonRegExps.get("cssPseudoElementSelector"), commonRegExps.get("cssPseudoElementExclusion"));
            this.attributeMatcher = new IncludeExcludeMatcher(commonRegExps.get("cssAttributeSelector"), commonRegExps.get("cssAttributeExclusion"));
        }

        public Map<String, Property> getCssRules() {
            return this.cssRules;
        }

        public boolean isValidElementName(String name) {
            return this.elementMatcher.matches(name);
        }

        public boolean isValidClassName(String name) {
            return this.classMatcher.matches(name);
        }

        public boolean isValidId(String name) {
            return this.idMatcher.matches(name);
        }

        public boolean isValidPseudoElementName(String name) {
            return this.pseudoElementMatcher.matches(name);
        }

        public boolean isValidAttributeSelector(String name) {
            return this.attributeMatcher.matches(name);
        }
    }
}

