/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Map;
import java.util.Objects;
import org.apache.sling.testing.mock.osgi.ComponentContextBuilder;
import org.apache.sling.testing.mock.osgi.DictionaryCollector;
import org.apache.sling.testing.mock.osgi.MapMergeUtil;
import org.apache.sling.testing.mock.osgi.MapUtil;
import org.apache.sling.testing.mock.osgi.MockBundleContext;
import org.apache.sling.testing.mock.osgi.MockComponentContext;
import org.apache.sling.testing.mock.osgi.MockLogService;
import org.apache.sling.testing.mock.osgi.OsgiMetadataUtil;
import org.apache.sling.testing.mock.osgi.OsgiServiceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.log.LogService;

public final class MockOsgi {
    private MockOsgi() {
    }

    @NotNull
    public static BundleContext newBundleContext() {
        return new MockBundleContext();
    }

    public static void sendBundleEvent(@NotNull BundleContext bundleContext, @NotNull BundleEvent bundleEvent) {
        ((MockBundleContext)bundleContext).sendBundleEvent(bundleEvent);
    }

    @NotNull
    public static ComponentContext newComponentContext() {
        return MockOsgi.componentContext().build();
    }

    @NotNull
    public static ComponentContext newComponentContext(@Nullable Dictionary<String, Object> properties) {
        return MockOsgi.componentContext().properties(properties).build();
    }

    @NotNull
    public static ComponentContext newComponentContext(@Nullable Map<String, Object> properties) {
        return MockOsgi.componentContext().properties(properties).build();
    }

    @NotNull
    public static ComponentContext newComponentContext(Object ... properties) {
        return MockOsgi.componentContext().properties(properties).build();
    }

    @NotNull
    public static ComponentContext newComponentContext(@NotNull BundleContext bundleContext, @Nullable Dictionary<String, Object> properties) {
        return MockOsgi.componentContext().bundleContext(bundleContext).properties(properties).build();
    }

    @NotNull
    public static ComponentContext newComponentContext(@NotNull BundleContext bundleContext, @Nullable Map<String, Object> properties) {
        return MockOsgi.componentContext().bundleContext(bundleContext).properties(properties).build();
    }

    @NotNull
    public static ComponentContext newComponentContext(@NotNull BundleContext bundleContext, Object ... properties) {
        return MockOsgi.componentContext().bundleContext(bundleContext).properties(properties).build();
    }

    @NotNull
    public static ComponentContextBuilder componentContext() {
        return new ComponentContextBuilder();
    }

    @NotNull
    public static LogService newLogService(@NotNull Class<?> loggerContext) {
        return new MockLogService(loggerContext);
    }

    public static boolean injectServices(@NotNull Object target, @NotNull BundleContext bundleContext) {
        return MockOsgi.injectServices(target, bundleContext, null);
    }

    public static boolean injectServices(@NotNull Object target, @NotNull BundleContext bundleContext, @Nullable Map<String, Object> properties) {
        return OsgiServiceUtil.injectServices(target, bundleContext, properties);
    }

    @NotNull
    public static <T> T activateInjectServices(@NotNull Class<T> targetClass, @NotNull BundleContext bundleContext) {
        return MockOsgi.activateInjectServices(targetClass, bundleContext, null);
    }

    @NotNull
    public static <T> T activateInjectServices(@NotNull Class<T> targetClass, @NotNull BundleContext bundleContext, @Nullable Map<String, Object> properties) {
        Map<String, Object> mergedProperties = MapMergeUtil.propertiesMergeWithOsgiMetadata(targetClass, MockOsgi.getConfigAdmin(bundleContext), properties);
        ComponentContext componentContext = MockOsgi.newComponentContext(bundleContext, mergedProperties);
        return OsgiServiceUtil.activateInjectServices(targetClass, (MockComponentContext)componentContext);
    }

    @NotNull
    public static <T> T activateInjectServices(@NotNull Class<T> targetClass, @NotNull BundleContext bundleContext, Object ... properties) {
        return MockOsgi.activateInjectServices(targetClass, bundleContext, MapUtil.toMap(properties));
    }

    @NotNull
    public static final <T> void registerInjectActivateService(@NotNull T component, @NotNull BundleContext bundleContext) {
        MockOsgi.registerInjectActivateService(component, bundleContext, (Map<String, Object>)null);
    }

    @NotNull
    public static final <T> void registerInjectActivateService(@NotNull T component, @NotNull BundleContext bundleContext, @Nullable Map<String, Object> properties) {
        Map<String, Object> mergedProperties = MapMergeUtil.propertiesMergeWithOsgiMetadata(component.getClass(), MockOsgi.getConfigAdmin(bundleContext), properties);
        MockOsgi.injectServices(component, bundleContext, mergedProperties);
        ComponentContext componentContext = MockOsgi.newComponentContext(bundleContext, mergedProperties);
        OsgiServiceUtil.activateDeactivate(component, (MockComponentContext)componentContext, true);
        MockOsgi.registerDSComponent(component, bundleContext, mergedProperties);
    }

    @NotNull
    public static final <T> void registerInjectActivateService(@NotNull T component, @NotNull BundleContext bundleContext, Object ... properties) {
        MockOsgi.registerInjectActivateService(component, bundleContext, MapUtil.toMap(properties));
    }

    @NotNull
    public static final <T> T registerInjectActivateService(@NotNull Class<T> dsComponentClass, @NotNull BundleContext bundleContext) {
        return MockOsgi.registerInjectActivateService(dsComponentClass, bundleContext, (Map<String, Object>)null);
    }

    @NotNull
    public static final <T> T registerInjectActivateService(@NotNull Class<T> dsComponentClass, @NotNull BundleContext bundleContext, @Nullable Map<String, Object> properties) {
        Map<String, Object> mergedProperties = MapMergeUtil.propertiesMergeWithOsgiMetadata(dsComponentClass, MockOsgi.getConfigAdmin(bundleContext), properties);
        ComponentContext componentContext = MockOsgi.newComponentContext(bundleContext, mergedProperties);
        T component = OsgiServiceUtil.activateInjectServices(dsComponentClass, (MockComponentContext)componentContext);
        MockOsgi.registerDSComponent(component, bundleContext, mergedProperties);
        return component;
    }

    private static <T> void registerDSComponent(@NotNull T component, @NotNull BundleContext bundleContext, Map<String, Object> mergedProperties) {
        OsgiMetadataUtil.OsgiMetadata metadata = Objects.requireNonNull(OsgiMetadataUtil.getMetadata(component.getClass()), "No metadata found for " + String.valueOf(component.getClass()));
        Dictionary serviceProperties = (Dictionary)mergedProperties.entrySet().stream().filter(e -> e.getKey() != null && !((String)e.getKey()).startsWith(".")).collect(new DictionaryCollector<String, Object>(Map.Entry::getKey, Map.Entry::getValue));
        bundleContext.registerService(metadata.getServiceInterfaces().toArray(new String[0]), component, serviceProperties);
    }

    @NotNull
    public static final <T> T registerInjectActivateService(@NotNull Class<T> dsComponentClass, @NotNull BundleContext bundleContext, Object ... properties) {
        return MockOsgi.registerInjectActivateService(dsComponentClass, bundleContext, MapUtil.toMap(properties));
    }

    public static boolean activate(@NotNull Object target, @NotNull BundleContext bundleContext) {
        return MockOsgi.activate(target, bundleContext, (Dictionary<String, Object>)null);
    }

    public static boolean activate(@NotNull Object target, @NotNull BundleContext bundleContext, @Nullable Dictionary<String, Object> properties) {
        Dictionary<String, Object> mergedProperties = MapMergeUtil.propertiesMergeWithOsgiMetadata(target.getClass(), MockOsgi.getConfigAdmin(bundleContext), properties);
        ComponentContext componentContext = MockOsgi.newComponentContext(bundleContext, mergedProperties);
        return OsgiServiceUtil.activateDeactivate(target, (MockComponentContext)componentContext, true);
    }

    public static boolean activate(@NotNull Object target, @NotNull BundleContext bundleContext, @Nullable Map<String, Object> properties) {
        return MockOsgi.activate(target, bundleContext, MapUtil.toDictionary(properties));
    }

    public static boolean activate(@NotNull Object target, @NotNull BundleContext bundleContext, Object ... properties) {
        return MockOsgi.activate(target, bundleContext, MapUtil.toDictionary(properties));
    }

    public static boolean deactivate(@NotNull Object target, @NotNull BundleContext bundleContext) {
        return MockOsgi.deactivate(target, bundleContext, (Dictionary<String, Object>)null);
    }

    public static boolean deactivate(@NotNull Object target, @NotNull BundleContext bundleContext, @Nullable Dictionary<String, Object> properties) {
        Dictionary<String, Object> mergedProperties = MapMergeUtil.propertiesMergeWithOsgiMetadata(target.getClass(), MockOsgi.getConfigAdmin(bundleContext), properties);
        ComponentContext componentContext = MockOsgi.newComponentContext(bundleContext, mergedProperties);
        return OsgiServiceUtil.activateDeactivate(target, (MockComponentContext)componentContext, false);
    }

    public static boolean deactivate(@NotNull Object target, @NotNull BundleContext bundleContext, @Nullable Map<String, Object> properties) {
        return MockOsgi.deactivate(target, bundleContext, MapUtil.toDictionary(properties));
    }

    public static boolean deactivate(@NotNull Object target, @NotNull BundleContext bundleContext, Object ... properties) {
        return MockOsgi.deactivate(target, bundleContext, MapUtil.toDictionary(properties));
    }

    public static boolean modified(@NotNull Object target, @NotNull BundleContext bundleContext, @Nullable Dictionary<String, Object> properties) {
        return MockOsgi.modified(target, bundleContext, MapUtil.toMap(properties));
    }

    public static boolean modified(@NotNull Object target, @NotNull BundleContext bundleContext, @Nullable Map<String, Object> properties) {
        Map<String, Object> mergedProperties = MapMergeUtil.propertiesMergeWithOsgiMetadata(target.getClass(), MockOsgi.getConfigAdmin(bundleContext), properties);
        ComponentContext componentContext = MockOsgi.newComponentContext(bundleContext, mergedProperties);
        return OsgiServiceUtil.modified(target, (MockComponentContext)componentContext, mergedProperties);
    }

    public static boolean modified(@NotNull Object target, @NotNull BundleContext bundleContext, Object ... properties) {
        return MockOsgi.modified(target, bundleContext, MapUtil.toDictionary(properties));
    }

    public static void setConfigForPid(@NotNull BundleContext bundleContext, @NotNull String pid, @Nullable Map<String, Object> properties) {
        MockOsgi.setConfigForPid(bundleContext, pid, MapUtil.toDictionary(properties));
    }

    public static void setConfigForPid(@NotNull BundleContext bundleContext, @NotNull String pid, Object ... properties) {
        MockOsgi.setConfigForPid(bundleContext, pid, MapUtil.toDictionary(properties));
    }

    private static void setConfigForPid(@NotNull BundleContext bundleContext, @NotNull String pid, @Nullable Dictionary<String, Object> properties) {
        ConfigurationAdmin configAdmin = MockOsgi.getConfigAdmin(bundleContext);
        if (configAdmin == null) {
            throw new RuntimeException("ConfigurationAdmin service is not registered in bundle context.");
        }
        try {
            Configuration config = configAdmin.getConfiguration(pid);
            config.update(properties);
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to update configuration for pid '" + pid + "'.", ex);
        }
    }

    public static void setFactoryConfigForPid(@NotNull BundleContext bundleContext, @NotNull String factoryPid, @NotNull String name, @Nullable Map<String, Object> properties) {
        MockOsgi.setFactoryConfigForPid(bundleContext, factoryPid, name, MapUtil.toDictionary(properties));
    }

    public static void setFactoryConfigForPid(@NotNull BundleContext bundleContext, @NotNull String factoryPid, @NotNull String name, Object ... properties) {
        MockOsgi.setFactoryConfigForPid(bundleContext, factoryPid, name, MapUtil.toDictionary(properties));
    }

    private static void setFactoryConfigForPid(@NotNull BundleContext bundleContext, @NotNull String factoryPid, @NotNull String name, @Nullable Dictionary<String, Object> properties) {
        ConfigurationAdmin configAdmin = MockOsgi.getConfigAdmin(bundleContext);
        if (configAdmin == null) {
            throw new RuntimeException("ConfigurationAdmin service is not registered in bundle context.");
        }
        try {
            Configuration config = configAdmin.getFactoryConfiguration(factoryPid, name);
            config.update(properties);
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to update factory configuration for factoryPid '" + factoryPid + " and name " + name + "'.", ex);
        }
    }

    public static void shutdown(@NotNull BundleContext bundleContext) {
        ((MockBundleContext)bundleContext).shutdown();
    }

    @Nullable
    private static ConfigurationAdmin getConfigAdmin(@NotNull BundleContext bundleContext) {
        ServiceReference ref = bundleContext.getServiceReference(ConfigurationAdmin.class.getName());
        if (ref != null) {
            return (ConfigurationAdmin)bundleContext.getService(ref);
        }
        return null;
    }
}

