/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.get.impl.helpers;

import jakarta.servlet.ServletException;
import java.io.IOException;
import java.io.OutputStream;
import javax.jcr.Node;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.SlingJakartaHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceNotFoundException;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.servlets.get.impl.helpers.Renderer;
import org.xml.sax.ContentHandler;

public class XMLRenderer
implements Renderer {
    private static final String SYSVIEW = "sysview";
    private static final String DOCVIEW = "docview";

    @Override
    public void render(SlingJakartaHttpServletRequest req, SlingJakartaHttpServletResponse resp) throws IOException {
        block15: {
            Resource r = req.getResource();
            if (ResourceUtil.isNonExistingResource((Resource)r)) {
                throw new ResourceNotFoundException("No data to render.");
            }
            resp.setContentType(req.getResponseContentType());
            resp.setCharacterEncoding("UTF-8");
            boolean isIncluded = req.getAttribute("org.apache.sling.api.include.jakarta.servlet") != null;
            try {
                Node node = (Node)r.adaptTo(Node.class);
                if (node != null) {
                    try {
                        if (req.getRequestPathInfo().getSelectorString() == null || req.getRequestPathInfo().getSelectorString().equals(DOCVIEW)) {
                            ContentHandler ch = (ContentHandler)resp.adaptTo(ContentHandler.class);
                            if (ch == null) {
                                node.getSession().exportDocumentView(node.getPath(), (OutputStream)resp.getOutputStream(), false, false);
                            } else {
                                node.getSession().exportDocumentView(node.getPath(), ch, false, false);
                            }
                        } else if (req.getRequestPathInfo().getSelectorString().equals(SYSVIEW)) {
                            ContentHandler ch = (ContentHandler)resp.adaptTo(ContentHandler.class);
                            if (ch == null) {
                                node.getSession().exportSystemView(node.getPath(), (OutputStream)resp.getOutputStream(), false, false);
                            } else {
                                node.getSession().exportSystemView(node.getPath(), ch, false, false);
                            }
                        } else {
                            resp.sendError(204);
                        }
                        break block15;
                    }
                    catch (Exception e) {
                        throw new ServletException("Unable to export resource as xml: " + String.valueOf(r), (Throwable)e);
                    }
                }
                if (!isIncluded) {
                    resp.sendError(204);
                }
            }
            catch (Throwable t) {
                if (isIncluded) break block15;
                resp.sendError(204);
            }
        }
    }
}

