/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl.legacy;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceProviderFactory;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.resourceresolver.impl.legacy.LegacyResourceProviderAdapter;
import org.apache.sling.spi.resource.provider.QueryLanguageProvider;
import org.apache.sling.spi.resource.provider.ResolveContext;
import org.apache.sling.spi.resource.provider.ResourceContext;
import org.apache.sling.spi.resource.provider.ResourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LegacyResourceProviderFactoryAdapter
extends ResourceProvider<LegacyResourceProviderAdapter> {
    private final ResourceProviderFactory rpFactory;
    private final String[] languages;
    private final boolean ownsRoot;

    public LegacyResourceProviderFactoryAdapter(ResourceProviderFactory rpFactory, String[] languages, boolean ownsRoot) {
        this.rpFactory = rpFactory;
        this.languages = languages;
        this.ownsRoot = ownsRoot;
    }

    @NotNull
    public LegacyResourceProviderAdapter authenticate(@NotNull Map<String, Object> authenticationInfo) throws LoginException {
        return new LegacyResourceProviderAdapter(this.rpFactory.getResourceProvider(authenticationInfo), this.languages, this.ownsRoot);
    }

    public void logout(@NotNull LegacyResourceProviderAdapter state) {
        state.logout(null);
    }

    public Resource getResource(ResolveContext<LegacyResourceProviderAdapter> ctx, String path, ResourceContext resourceContext, Resource parent) {
        return ((LegacyResourceProviderAdapter)ctx.getProviderState()).getResource(ctx, path, resourceContext, parent);
    }

    public Iterator<Resource> listChildren(ResolveContext<LegacyResourceProviderAdapter> ctx, Resource parent) {
        return ((LegacyResourceProviderAdapter)ctx.getProviderState()).listChildren(ctx, parent);
    }

    public void refresh(@NotNull ResolveContext<LegacyResourceProviderAdapter> ctx) {
        ((LegacyResourceProviderAdapter)ctx.getProviderState()).refresh(ctx);
    }

    @Nullable
    public QueryLanguageProvider<LegacyResourceProviderAdapter> getQueryLanguageProvider() {
        if (ArrayUtils.isEmpty((Object[])this.languages)) {
            return super.getQueryLanguageProvider();
        }
        return new JCRQueryProviderAdapter(this.languages);
    }

    public Collection<String> getAttributeNames(@NotNull ResolveContext<LegacyResourceProviderAdapter> ctx) {
        return ((LegacyResourceProviderAdapter)ctx.getProviderState()).getAttributeNames(ctx);
    }

    public Object getAttribute(@NotNull ResolveContext<LegacyResourceProviderAdapter> ctx, @NotNull String name) {
        return ((LegacyResourceProviderAdapter)ctx.getProviderState()).getAttribute(ctx, name);
    }

    public boolean isLive(@NotNull ResolveContext<LegacyResourceProviderAdapter> ctx) {
        return ((LegacyResourceProviderAdapter)ctx.getProviderState()).isLive(ctx);
    }

    public Resource create(@NotNull ResolveContext<LegacyResourceProviderAdapter> ctx, String path, Map<String, Object> properties) throws PersistenceException {
        return ((LegacyResourceProviderAdapter)ctx.getProviderState()).create(ctx, path, properties);
    }

    public void delete(@NotNull ResolveContext<LegacyResourceProviderAdapter> ctx, @NotNull Resource resource) throws PersistenceException {
        ((LegacyResourceProviderAdapter)ctx.getProviderState()).delete(ctx, resource);
    }

    public void revert(@NotNull ResolveContext<LegacyResourceProviderAdapter> ctx) {
        ((LegacyResourceProviderAdapter)ctx.getProviderState()).revert(ctx);
    }

    public void commit(@NotNull ResolveContext<LegacyResourceProviderAdapter> ctx) throws PersistenceException {
        ((LegacyResourceProviderAdapter)ctx.getProviderState()).commit(ctx);
    }

    public boolean hasChanges(@NotNull ResolveContext<LegacyResourceProviderAdapter> ctx) {
        return ((LegacyResourceProviderAdapter)ctx.getProviderState()).hasChanges(ctx);
    }

    public <AdapterType> AdapterType adaptTo(@NotNull ResolveContext<LegacyResourceProviderAdapter> ctx, @NotNull Class<AdapterType> type) {
        return ((LegacyResourceProviderAdapter)ctx.getProviderState()).adaptTo(ctx, type);
    }

    private static class JCRQueryProviderAdapter
    implements QueryLanguageProvider<LegacyResourceProviderAdapter> {
        private final String[] languages;

        public JCRQueryProviderAdapter(String[] languages) {
            this.languages = languages;
        }

        public String[] getSupportedLanguages(ResolveContext<LegacyResourceProviderAdapter> ctx) {
            return this.languages;
        }

        public Iterator<Resource> findResources(ResolveContext<LegacyResourceProviderAdapter> ctx, String query, String language) {
            return ((LegacyResourceProviderAdapter)ctx.getProviderState()).getQueryLanguageProvider().findResources(ctx, query, language);
        }

        public Iterator<ValueMap> queryResources(ResolveContext<LegacyResourceProviderAdapter> ctx, String query, String language) {
            return ((LegacyResourceProviderAdapter)ctx.getProviderState()).getQueryLanguageProvider().queryResources(ctx, query, language);
        }
    }
}

