/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl;

import jakarta.servlet.ServletException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.script.Bindings;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.SlingJakartaHttpServletResponse;
import org.apache.sling.api.scripting.LazyBindings;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.api.servlets.SlingJakartaSafeMethodsServlet;
import org.apache.sling.models.factory.ExportException;
import org.apache.sling.models.factory.MissingExporterException;
import org.apache.sling.models.factory.ModelFactory;
import org.apache.sling.models.impl.SlingModelsScriptEngineFactory;
import org.apache.sling.scripting.api.BindingsValuesProvidersByContext;
import org.apache.sling.scripting.core.ScriptHelper;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ExportServlet
extends SlingJakartaSafeMethodsServlet {
    private static final String APPLICATION_JSON = "application/json";
    private static final String UTF_8 = "UTF-8";
    private final Logger logger;
    private final String exporterName;
    private final String registeredSelector;
    private final BundleContext bundleContext;
    private final ModelFactory modelFactory;
    private final BindingsValuesProvidersByContext bindingsValuesProvidersByContext;
    private final SlingModelsScriptEngineFactory scriptEngineFactory;
    private final ExportedObjectAccessor accessor;
    private final Map<String, String> baseOptions;

    public ExportServlet(BundleContext bundleContext, ModelFactory modelFactory, BindingsValuesProvidersByContext bindingsValuesProvidersByContext, SlingModelsScriptEngineFactory scriptFactory, Class<?> annotatedClass, String registeredSelector, String exporterName, ExportedObjectAccessor accessor, Map<String, String> baseOptions) {
        this.bundleContext = bundleContext;
        this.modelFactory = modelFactory;
        this.bindingsValuesProvidersByContext = bindingsValuesProvidersByContext;
        this.scriptEngineFactory = scriptFactory;
        this.registeredSelector = registeredSelector;
        this.exporterName = exporterName;
        this.accessor = accessor;
        this.baseOptions = baseOptions;
        String loggerName = ExportServlet.class.getName() + "." + annotatedClass.getName();
        this.logger = LoggerFactory.getLogger((String)loggerName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void doGet(SlingJakartaHttpServletRequest request, SlingJakartaHttpServletResponse response) throws ServletException, IOException {
        block11: {
            String contentType = request.getResponseContentType();
            response.setContentType(contentType);
            if (APPLICATION_JSON.equals(contentType)) {
                response.setCharacterEncoding(UTF_8);
            }
            Map<String, String> options = this.createOptionMap(request);
            ScriptHelper scriptHelper = new ScriptHelper(this.bundleContext, null, request, response);
            try {
                String exported;
                this.addScriptBindings((SlingScriptHelper)scriptHelper, request, response);
                try {
                    exported = this.accessor.getExportedString(request, options, this.modelFactory, this.exporterName);
                }
                catch (ExportException e) {
                    this.logger.error("Could not perform export with " + this.exporterName + " requested by model.", (Throwable)e);
                    response.setStatus(500);
                    scriptHelper.cleanup();
                    return;
                }
                catch (MissingExporterException e) {
                    this.logger.error("Could not get exporter " + this.exporterName + " requested by model.", (Throwable)e);
                    response.setStatus(500);
                    scriptHelper.cleanup();
                    return;
                }
                if (exported == null) {
                    response.setStatus(404);
                    return;
                }
                response.getWriter().write(exported);
                break block11;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                scriptHelper.cleanup();
            }
        }
    }

    private void addScriptBindings(SlingScriptHelper scriptHelper, SlingJakartaHttpServletRequest request, SlingJakartaHttpServletResponse response) throws IOException {
        LazyBindings bindings = new LazyBindings();
        bindings.put("sling", (Object)scriptHelper);
        bindings.put("resource", (Object)request.getResource());
        bindings.put("resolver", (Object)request.getResource().getResourceResolver());
        bindings.put("jakartaRequest", (Object)request);
        bindings.put("jakartaResponse", (Object)response);
        try {
            bindings.put("reader", (Object)request.getReader());
        }
        catch (Exception e) {
            bindings.put("reader", (Object)new BufferedReader(new StringReader("")));
        }
        bindings.put("out", (Object)response.getWriter());
        bindings.put("log", (Object)this.logger);
        this.scriptEngineFactory.invokeBindingsValuesProviders(this.bindingsValuesProvidersByContext, (Bindings)bindings);
        SlingBindings slingBindings = new SlingBindings();
        slingBindings.putAll((Map)bindings);
        request.setAttribute(SlingBindings.class.getName(), (Object)slingBindings);
    }

    private Map<String, String> createOptionMap(SlingJakartaHttpServletRequest request) {
        Map parameterMap = request.getParameterMap();
        String[] selectors = request.getRequestPathInfo().getSelectors();
        HashMap<String, String> result = new HashMap<String, String>(this.baseOptions.size() + parameterMap.size() + selectors.length - 1);
        result.putAll(this.baseOptions);
        for (String selector : selectors) {
            if (selector.equals(this.registeredSelector)) continue;
            result.put(selector, "true");
        }
        for (Map.Entry entry : parameterMap.entrySet()) {
            if (((String[])entry.getValue()).length == 0) {
                result.put((String)entry.getKey(), Boolean.TRUE.toString());
                continue;
            }
            result.put((String)entry.getKey(), ((String[])entry.getValue())[0]);
        }
        return result;
    }

    public static interface ExportedObjectAccessor {
        public String getExportedString(SlingJakartaHttpServletRequest var1, Map<String, String> var2, ModelFactory var3, String var4) throws ExportException, MissingExporterException;
    }

    public static final class RequestAccessor
    implements ExportedObjectAccessor {
        private final Class<?> adapterClass;

        public RequestAccessor(Class<?> adapterClass) {
            this.adapterClass = adapterClass;
        }

        @Override
        public String getExportedString(SlingJakartaHttpServletRequest request, Map<String, String> options, ModelFactory modelFactory, String exporterName) throws ExportException, MissingExporterException {
            Object adapter = modelFactory.createModel((Object)request, this.adapterClass);
            return (String)modelFactory.exportModel(adapter, exporterName, String.class, options);
        }
    }

    public static final class ResourceAccessor
    implements ExportedObjectAccessor {
        private final Class<?> adapterClass;

        public ResourceAccessor(Class<?> adapterClass) {
            this.adapterClass = adapterClass;
        }

        @Override
        public String getExportedString(SlingJakartaHttpServletRequest request, Map<String, String> options, ModelFactory modelFactory, String exporterName) throws ExportException, MissingExporterException {
            Object adapter = modelFactory.createModel((Object)request.getResource(), this.adapterClass);
            return (String)modelFactory.exportModel(adapter, exporterName, String.class, options);
        }
    }
}

