/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.junit.impl.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.junit.Renderer;
import org.apache.sling.junit.RendererSelector;
import org.apache.sling.junit.RequestParser;
import org.apache.sling.junit.TestSelector;
import org.apache.sling.junit.TestsManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletProcessor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String CSS = "junit.css";
    public static final String FORCE_RELOAD_PARAM = "forceReload";
    private final TestsManager testsManager;
    private final RendererSelector rendererSelector;

    public ServletProcessor(TestsManager testsManager, RendererSelector rendererSelector) {
        this.testsManager = testsManager;
        this.rendererSelector = rendererSelector;
    }

    private void sendCss(HttpServletResponse response) throws IOException {
        InputStream str = this.getClass().getResourceAsStream("/junit.css");
        if (str == null) {
            response.sendError(404, CSS);
        } else {
            response.setContentType("text/css");
            ServletOutputStream out = response.getOutputStream();
            byte[] buffer = new byte[16384];
            int count = 0;
            while ((count = str.read(buffer)) > 0) {
                out.write(buffer, 0, count);
            }
            out.flush();
        }
    }

    private void logForceReloadOptionDeprecation(HttpServletRequest request) {
        String forceReloadParam = request.getParameter(FORCE_RELOAD_PARAM);
        if (forceReloadParam != null) {
            this.log.info("{} option is no longer necessary and its use is therefore deprecated", (Object)FORCE_RELOAD_PARAM);
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response, String servletPath) throws ServletException, IOException {
        this.logForceReloadOptionDeprecation(request);
        String pi = request.getPathInfo();
        if (pi == null) {
            response.sendRedirect(request.getContextPath() + servletPath + "/");
        } else if (pi.endsWith(CSS)) {
            this.sendCss(response);
            return;
        }
        TestSelector selector = this.getTestSelector(request);
        Collection<String> testNames = this.testsManager.getTestNames(selector);
        if (testNames.isEmpty()) {
            String msg = "WARNING: no test classes found for selector " + String.valueOf(selector) + ", check the requirements of the active TestsProvider services for how to supply tests.";
            response.sendError(404, msg);
            return;
        }
        Renderer renderer = this.rendererSelector.getRenderer(selector);
        if (renderer == null) {
            throw new ServletException("No Renderer found for " + String.valueOf(selector));
        }
        this.log.debug("GET request: {}", (Object)selector);
        renderer.setup(response, this.getClass().getSimpleName());
        renderer.info("info", "Test selector: " + String.valueOf(selector));
        try {
            this.testsManager.listTests(testNames, renderer);
            String postPath = this.getTestExecutionPath(request, selector, renderer.getExtension());
            renderer.link("Execute these tests", postPath, "POST");
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        renderer.cleanup();
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.logForceReloadOptionDeprecation(request);
        TestSelector selector = this.getTestSelector(request);
        this.log.info("POST request, executing tests: {}", (Object)selector);
        Renderer renderer = this.rendererSelector.getRenderer(selector);
        if (renderer == null) {
            throw new ServletException("No Renderer found for " + String.valueOf(selector));
        }
        renderer.setup(response, this.getClass().getSimpleName());
        try {
            this.testsManager.executeTests(renderer, selector);
        }
        catch (TestsManager.NoTestCasesFoundException e) {
            response.sendError(404, "No tests found for " + String.valueOf(selector));
            return;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        renderer.cleanup();
    }

    private TestSelector getTestSelector(HttpServletRequest request) {
        return new RequestParser(this.getTestSelectionPath(request));
    }

    protected String getTestSelectionPath(HttpServletRequest request) {
        return request.getPathInfo();
    }

    protected String getTestExecutionPath(HttpServletRequest request, TestSelector selector, String extension) {
        String path = Stream.of(request.getContextPath(), request.getServletPath(), selector.getTestSelectorString(), selector.getSelectedTestMethodName()).filter(StringUtils::isNotBlank).collect(Collectors.joining("/"));
        return path + "." + extension;
    }
}

