/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.repoinit.impl;

import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlManager;
import org.apache.jackrabbit.api.security.authorization.PrivilegeCollection;
import org.apache.sling.jcr.repoinit.impl.AclUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SessionContext {
    JackrabbitSession session;
    JackrabbitAccessControlManager acMgr;
    Map<String, Principal> nameToPrincipal = new HashMap<String, Principal>();

    public SessionContext(@NotNull Session session) {
        AclUtil.checkState(session instanceof JackrabbitSession, "A Jackrabbit Session is required", new Object[0]);
        this.session = (JackrabbitSession)session;
        try {
            AclUtil.checkState(session.getAccessControlManager() instanceof JackrabbitAccessControlManager, "A Jackrabbit AccessControlManager is required", new Object[0]);
            this.acMgr = (JackrabbitAccessControlManager)session.getAccessControlManager();
        }
        catch (RepositoryException e) {
            throw new IllegalStateException("Cannot retrieve the AccessControlManager");
        }
    }

    public JackrabbitSession getSession() {
        return this.session;
    }

    public JackrabbitAccessControlManager getAccessControlManager() {
        return this.acMgr;
    }

    @NotNull
    public PrivilegeCollection privilegeCollectionFromNames(String ... privilegeNames) throws RepositoryException {
        return this.acMgr.privilegeCollectionFromNames(privilegeNames);
    }

    @Nullable
    public Principal getPrincipal(@NotNull String principalName) throws RepositoryException {
        if (this.nameToPrincipal.containsKey(principalName)) {
            return this.nameToPrincipal.get(principalName);
        }
        Principal p = this.session.getPrincipalManager().getPrincipal(principalName);
        if (p != null) {
            this.nameToPrincipal.put(principalName, p);
        }
        return p;
    }

    @Nullable
    public Principal getPrincipalWithSave(@NotNull String principalName) throws RepositoryException {
        Principal principal = this.getPrincipal(principalName);
        if (principal == null) {
            this.session.save();
            principal = this.getPrincipal(principalName);
        }
        return principal;
    }
}

