/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.jackrabbit.accessmanager.impl;

import javax.jcr.security.AccessControlEntry;
import org.apache.jackrabbit.api.security.authorization.PrincipalAccessControlList;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrincipalAceHelper {
    public static final String RESOURCE_PATH_REPOSITORY = "/:repository";

    private PrincipalAceHelper() {
    }

    public static String getEffectivePath(SlingJakartaHttpServletRequest request) {
        String effectivePath = request.getResource().getPath();
        if (ResourceUtil.isNonExistingResource((Resource)request.getResource())) {
            String selectorString;
            @NotNull RequestPathInfo requestPathInfo = request.getRequestPathInfo();
            @NotNull String resourcePath = requestPathInfo.getResourcePath();
            @Nullable String extension = requestPathInfo.getExtension();
            if (extension != null) {
                resourcePath = resourcePath.substring(0, resourcePath.length() - extension.length() - 1);
            }
            if ((selectorString = requestPathInfo.getSelectorString()) != null) {
                resourcePath = resourcePath.substring(0, resourcePath.length() - selectorString.length() - 1);
            }
            effectivePath = RESOURCE_PATH_REPOSITORY.equals(resourcePath) ? null : resourcePath;
        }
        return effectivePath;
    }

    public static boolean matchesResourcePath(String resourcePath, AccessControlEntry entry) {
        boolean matches = false;
        if (entry instanceof PrincipalAccessControlList.Entry) {
            PrincipalAccessControlList.Entry paclEntry = (PrincipalAccessControlList.Entry)entry;
            String effectivePath = paclEntry.getEffectivePath();
            matches = resourcePath == null ? effectivePath == null : resourcePath.equals(effectivePath);
        }
        return matches;
    }
}

