/*
 * Decompiled with CFR 0.152.
 */
package relocated_for_contentpackage.org.apache.jackrabbit.vault.util.xml.serialize;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.util.QNameComparator;

public class NormalizingSaxFilter
extends XMLFilterImpl
implements LexicalHandler {
    private static final String SAX_PROPERTY_LEXICAL_HANDLER = "http://xml.org/sax/properties/lexical-handler";
    private LexicalHandler lexicalHandler = null;
    boolean hasReachedRootElement;

    public NormalizingSaxFilter(XMLReader parent) {
        super(parent);
    }

    @Override
    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name.equals(SAX_PROPERTY_LEXICAL_HANDLER)) {
            this.lexicalHandler = (LexicalHandler)value;
            super.setProperty(name, this);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public void parse(InputSource input) throws SAXException, IOException {
        this.hasReachedRootElement = false;
        super.parse(input);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.hasReachedRootElement = true;
        LinkedList<Attribute> attributeList = new LinkedList<Attribute>();
        for (int i = 0; i < atts.getLength(); ++i) {
            Attribute attribute = new Attribute(atts, i);
            attributeList.add(attribute);
        }
        Collections.sort(attributeList, new AttributeComparator());
        super.startElement(uri, localName, qName, this.getAttributesFromList(attributeList));
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    AttributesImpl getAttributesFromList(List<Attribute> attributeList) {
        AttributesImpl attributes = new AttributesImpl();
        for (Attribute attribute : attributeList) {
            attribute.addToAttributes(attributes);
        }
        return attributes;
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startDTD(name, publicId, systemId);
        }
    }

    @Override
    public void endDTD() throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.endDTD();
        }
    }

    @Override
    public void startEntity(String name) throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startEntity(name);
        }
    }

    @Override
    public void endEntity(String name) throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.endEntity(name);
        }
    }

    @Override
    public void startCDATA() throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startCDATA();
        }
    }

    @Override
    public void endCDATA() throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.endCDATA();
        }
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        if (!this.hasReachedRootElement) {
            return;
        }
        if (this.lexicalHandler != null) {
            this.lexicalHandler.comment(ch, start, length);
        }
    }

    private static final class Attribute {
        private final QName name;
        private final String value;
        private final String type;

        public Attribute(Attributes attributes, int i) {
            this(Attribute.getQNameFromAttribute(attributes, i), attributes.getValue(i), attributes.getType(i));
        }

        private static QName getQNameFromAttribute(Attributes attributes, int i) {
            String localPart;
            String qName = attributes.getQName(i);
            String prefix = "";
            String[] nameParts = qName.split(":", 2);
            if (nameParts.length > 1) {
                prefix = nameParts[0];
                localPart = nameParts[1];
            } else {
                localPart = nameParts[0];
            }
            return new QName(attributes.getURI(i), localPart, prefix);
        }

        public Attribute(QName name, String value, String type) {
            this.name = name;
            this.value = value;
            this.type = type;
        }

        public QName getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public String getType() {
            return this.type;
        }

        public void addToAttributes(AttributesImpl attributes) {
            StringBuilder qName = new StringBuilder();
            if (this.getName().getPrefix().length() > 0) {
                qName.append(this.getName().getPrefix()).append(":");
            }
            qName.append(this.getName().getLocalPart());
            attributes.addAttribute(this.getName().getNamespaceURI(), this.getName().getLocalPart(), qName.toString(), this.getType(), this.getValue());
        }
    }

    private final class AttributeComparator
    implements Comparator<Attribute> {
        private final QNameComparator nameComparator = new QNameComparator();

        @Override
        public int compare(Attribute o1, Attribute o2) {
            return this.nameComparator.compare(o1.getName(), o2.getName());
        }
    }
}

