/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl;

import java.io.IOException;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.request.RequestProgressTracker;
import org.apache.sling.api.request.builder.Builders;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.auth.core.AuthenticationSupport;
import org.apache.sling.commons.mime.MimeTypeService;
import org.apache.sling.engine.impl.parameters.ParameterSupport;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.http.context.ServletContextHelper;
import org.osgi.service.http.whiteboard.annotations.RequireHttpWhiteboard;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequireHttpWhiteboard
@Component(service={ServletContextHelper.class})
@HttpWhiteboardContext(name="org.apache.sling", path="/")
public class SlingHttpContext
extends ServletContextHelper {
    public static final String SERVLET_CONTEXT_NAME = "org.apache.sling";
    private final Logger log = LoggerFactory.getLogger(SlingHttpContext.class);
    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL)
    private volatile MimeTypeService mimeTypeService;
    private final AuthenticationSupport authenticationSupport;

    @Activate
    public SlingHttpContext(@Reference AuthenticationSupport support) {
        this.authenticationSupport = support;
    }

    public String getMimeType(String name) {
        MimeTypeService mtservice = this.mimeTypeService;
        if (mtservice != null) {
            return mtservice.getMimeType(name);
        }
        this.log.debug("getMimeType: MimeTypeService not available, cannot resolve mime type for {}", (Object)name);
        return null;
    }

    public URL getResource(String name) {
        return null;
    }

    public boolean handleSecurity(HttpServletRequest request, HttpServletResponse response) throws IOException {
        RequestProgressTracker t = Builders.newRequestProgressTracker();
        t.log("Method={0}, PathInfo={1}", new Object[]{request.getMethod(), request.getPathInfo()});
        request.setAttribute(RequestProgressTracker.class.getName(), (Object)t);
        String timerName = "handleSecurity";
        t.startTimer("handleSecurity");
        request = ParameterSupport.getParameterSupportRequestWrapper(request);
        boolean result = this.authenticationSupport.handleSecurity(request, response);
        t.logTimer("handleSecurity", "authenticator {0} returns {1}", new Object[]{this.authenticationSupport, result});
        return result;
    }

    public void finishSecurity(HttpServletRequest request, HttpServletResponse response) {
        ResourceResolver resolver;
        super.finishSecurity(request, response);
        Object resolverObject = request.getAttribute("org.apache.sling.auth.core.ResourceResolver");
        ResourceResolver resourceResolver = resolver = resolverObject instanceof ResourceResolver ? (ResourceResolver)resolverObject : null;
        if (resolver != null) {
            resolver.close();
        }
    }
}

