/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.trigger.impl;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.scheduler.Scheduler;
import org.apache.sling.distribution.DistributionRequest;
import org.apache.sling.distribution.DistributionRequestType;
import org.apache.sling.distribution.SimpleDistributionRequest;
import org.apache.sling.distribution.trigger.DistributionTrigger;
import org.apache.sling.distribution.trigger.impl.AbstractJcrEventTrigger;
import org.apache.sling.jcr.api.SlingRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistedJcrEventDistributionTrigger
extends AbstractJcrEventTrigger
implements DistributionTrigger {
    public static final String DEFAULT_NUGGETS_PATH = "/var/sling/distribution/nuggets";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String nuggetsPath;

    public PersistedJcrEventDistributionTrigger(SlingRepository repository, Scheduler scheduler, ResourceResolverFactory resolverFactory, String path, String servicename, String nuggetsPath) {
        super(repository, scheduler, resolverFactory, path, servicename);
        this.nuggetsPath = nuggetsPath == null || nuggetsPath.length() == 0 ? DEFAULT_NUGGETS_PATH : nuggetsPath;
    }

    @Override
    protected DistributionRequest processEvent(Event event) throws RepositoryException {
        this.log.debug("processing event {}", (Object)event);
        SimpleDistributionRequest distributionRequest = null;
        Session session = this.getSession();
        if (!session.nodeExists(this.nuggetsPath)) {
            this.initializeNuggetsPath(session);
        }
        if (session.hasPermission(this.nuggetsPath, "add_node")) {
            this.log.debug("persisting event under {}", (Object)this.nuggetsPath);
            Node nuggetsNode = session.getNode(this.nuggetsPath);
            if (nuggetsNode != null) {
                String nodeName = String.valueOf(System.nanoTime());
                Node createdNode = nuggetsNode.addNode(nodeName, "nt:unstructured");
                if (createdNode != null) {
                    String path = createdNode.getPath();
                    createdNode.setProperty("identifier", event.getIdentifier());
                    createdNode.setProperty("path", event.getPath());
                    createdNode.setProperty("date", event.getDate());
                    createdNode.setProperty("type", (long)event.getType());
                    createdNode.setProperty("userData", event.getUserData());
                    createdNode.setProperty("userID", event.getUserID());
                    Set set = event.getInfo().entrySet();
                    ArrayList<String> values = new ArrayList<String>();
                    for (Map.Entry entry : set) {
                        values.add(String.valueOf(entry.getKey()) + ":" + String.valueOf(entry.getValue()));
                    }
                    createdNode.setProperty("info", values.toArray(new String[values.size()]));
                    session.save();
                    this.log.info("event {}\u00a0persisted at {}", (Object)event, (Object)path);
                    distributionRequest = new SimpleDistributionRequest(DistributionRequestType.ADD, new String[]{path});
                } else {
                    this.log.warn("could not create node {}", (Object)(this.nuggetsPath + "/" + nodeName));
                }
            } else {
                this.log.warn("could not get node {}\u00a0to persist event", (Object)this.nuggetsPath);
            }
        } else {
            this.log.warn("not enough privileges to persist the event {}\u00a0under {}", (Object)event, (Object)this.nuggetsPath);
        }
        return distributionRequest;
    }

    private void initializeNuggetsPath(Session session) throws RepositoryException {
        Node parent;
        this.log.info("initializing nuggets path");
        if (session != null && session.hasPermission((parent = session.getRootNode()).getPath(), "add_node")) {
            for (String nodeName : this.nuggetsPath.split("/")) {
                if (nodeName.length() <= 0) continue;
                if (!parent.hasNode(nodeName)) {
                    this.log.info("creating {}", (Object)nodeName);
                    parent = parent.addNode(nodeName, "sling:Folder");
                    continue;
                }
                this.log.debug("{} exists", (Object)nodeName);
                parent = parent.getNode(nodeName);
            }
            session.save();
        }
    }

    @Override
    public void enable() {
        this.log.debug("enabling persisting jcr event listener");
        try {
            Session session = this.getSession();
            if (!session.nodeExists(this.nuggetsPath)) {
                this.initializeNuggetsPath(session);
            }
        }
        catch (RepositoryException e) {
            this.log.warn("could not create nuggets path {}", (Object)this.nuggetsPath, (Object)e);
        }
    }
}

