/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.transport.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.utils.URIBuilder;
import org.apache.sling.distribution.transport.impl.HttpConfiguration;

class HttpTransportUtils {
    HttpTransportUtils() {
    }

    public static InputStream fetchNextPackage(Executor executor, URI distributionURI, HttpConfiguration httpConfiguration) throws URISyntaxException, IOException {
        URI fetchUri = HttpTransportUtils.getFetchUri(distributionURI);
        Request fetchReq = Request.Post((URI)fetchUri).connectTimeout(httpConfiguration.getConnectTimeout().intValue()).socketTimeout(httpConfiguration.getSocketTimeout().intValue()).addHeader("Connection", "Close").useExpectContinue();
        HttpResponse httpResponse = executor.execute(fetchReq).returnResponse();
        if (httpResponse.getStatusLine().getStatusCode() != 200) {
            return null;
        }
        HttpEntity entity = httpResponse.getEntity();
        return entity.getContent();
    }

    public static boolean deletePackage(Executor executor, URI distributionURI, String remotePackageId) throws URISyntaxException, IOException {
        URI deleteUri = HttpTransportUtils.getDeleteUri(distributionURI, remotePackageId);
        Request deleteReq = Request.Post((URI)deleteUri).useExpectContinue();
        HttpResponse httpResponse = executor.execute(deleteReq).returnResponse();
        return httpResponse.getStatusLine().getStatusCode() == 200;
    }

    private static URI getFetchUri(URI uri) throws URISyntaxException {
        URIBuilder uriBuilder = new URIBuilder(uri);
        uriBuilder.addParameter("operation", "fetch");
        return uriBuilder.build();
    }

    private static URI getDeleteUri(URI uri, String id) throws URISyntaxException {
        URIBuilder uriBuilder = new URIBuilder(uri);
        uriBuilder.addParameter("operation", "delete");
        uriBuilder.addParameter("id", id);
        return uriBuilder.build();
    }
}

