/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.servlet;

import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.distribution.DistributionRequest;
import org.apache.sling.distribution.DistributionResponse;
import org.apache.sling.distribution.agent.spi.DistributionAgent;
import org.apache.sling.distribution.servlet.ServletJsonUtils;
import org.apache.sling.distribution.util.RequestUtils;
import org.apache.sling.servlets.annotations.SlingServletResourceTypes;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class})
@SlingServletResourceTypes(methods={"POST"}, resourceTypes={"sling/distribution/service/agent"})
public class DistributionAgentServlet
extends SlingAllMethodsServlet {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/json");
        DistributionRequest distributionRequest = RequestUtils.fromServletRequest((HttpServletRequest)request);
        this.log.debug("distribution request : {}", (Object)distributionRequest);
        DistributionAgent agent = (DistributionAgent)request.getResource().adaptTo(DistributionAgent.class);
        ResourceResolver resourceResolver = request.getResourceResolver();
        if (agent != null) {
            try {
                DistributionResponse distributionResponse = agent.execute(resourceResolver, distributionRequest);
                ServletJsonUtils.writeJson(response, distributionResponse);
                this.log.debug("distribution response : {}", (Object)distributionResponse);
            }
            catch (Throwable e) {
                this.log.error("an unexpected error has occurred", e);
                ServletJsonUtils.writeJson(response, 503, e.getMessage(), null);
            }
        } else {
            ServletJsonUtils.writeJson(response, 404, "agent not found", null);
        }
    }
}

