/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.packaging.impl.importer;

import java.io.InputStream;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.Privilege;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.distribution.common.DistributionException;
import org.apache.sling.distribution.packaging.DistributionPackage;
import org.apache.sling.distribution.packaging.DistributionPackageInfo;
import org.apache.sling.distribution.packaging.impl.DistributionPackageImporter;
import org.apache.sling.jcr.api.SlingRepository;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryDistributionPackageImporter
implements DistributionPackageImporter {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final SlingRepository repository;
    private final String serviceName;
    private final String path;
    private final String privilegeName;

    public RepositoryDistributionPackageImporter(SlingRepository repository, String serviceName, String path, String privilegeName) {
        this.repository = repository;
        this.serviceName = serviceName;
        this.path = path;
        this.privilegeName = privilegeName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void importPackage(@NotNull ResourceResolver resourceResolver, @NotNull DistributionPackage distributionPackage) throws DistributionException {
        block12: {
            Session session = null;
            try {
                session = this.authenticate();
                int lastSlash = distributionPackage.getId().lastIndexOf(47);
                String nodeName = Text.escape((String)(lastSlash < 0 ? distributionPackage.getId() : distributionPackage.getId().substring(lastSlash + 1)));
                this.log.debug("importing package {} in {}", (Object)distributionPackage.getId(), (Object)nodeName);
                if (session != null) {
                    Node addedNode = session.getNode(this.path).addNode(nodeName, "{http://www.jcp.org/jcr/nt/1.0}file");
                    Node contentNode = addedNode.addNode("jcr:content", "{http://www.jcp.org/jcr/nt/1.0}resource");
                    if (contentNode != null) {
                        InputStream inputStream = null;
                        try {
                            inputStream = distributionPackage.createInputStream();
                            contentNode.setProperty("jcr:data", session.getValueFactory().createBinary(inputStream));
                            contentNode.setProperty("package.type", distributionPackage.getType());
                            session.save();
                        }
                        finally {
                            IOUtils.closeQuietly((InputStream)inputStream);
                        }
                    }
                    this.log.debug("package {} imported into the repository as node {} ", (Object)distributionPackage.getId(), (Object)addedNode.getPath());
                    break block12;
                }
                throw new Exception("could not get a Session to deliver package to the repository");
            }
            catch (Exception e) {
                throw new DistributionException(e);
            }
            finally {
                if (session != null) {
                    session.logout();
                }
            }
        }
    }

    @Override
    @NotNull
    public DistributionPackageInfo importStream(@NotNull ResourceResolver resourceResolver, @NotNull InputStream stream) throws DistributionException {
        throw new DistributionException("not supported");
    }

    private Session authenticate() throws Exception {
        Session session = this.repository.loginService(this.serviceName, null);
        if (session != null) {
            AccessControlManager accessControlManager = session.getAccessControlManager();
            Privilege privilege = accessControlManager.privilegeFromName(this.privilegeName);
            if (!accessControlManager.hasPrivileges(this.path, new Privilege[]{privilege})) {
                session.logout();
                throw new Exception("failed to access path " + this.path + " with privilege " + privilege);
            }
        }
        this.log.debug("authenticated path {} with privilege {}", (Object)this.path, (Object)this.privilegeName);
        return session;
    }
}

