/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.oauth_client.impl;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.AuthorizationCodeGrant;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.AuthorizationResponse;
import com.nimbusds.oauth2.sdk.ErrorObject;
import com.nimbusds.oauth2.sdk.ErrorResponse;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.TokenResponse;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientSecretBasic;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.Identifier;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.oauth2.sdk.pkce.CodeVerifier;
import com.nimbusds.openid.connect.sdk.Nonce;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponseParser;
import com.nimbusds.openid.connect.sdk.UserInfoRequest;
import com.nimbusds.openid.connect.sdk.UserInfoResponse;
import com.nimbusds.openid.connect.sdk.claims.IDTokenClaimsSet;
import com.nimbusds.openid.connect.sdk.claims.UserInfo;
import com.nimbusds.openid.connect.sdk.validators.IDTokenValidator;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.oak.spi.security.authentication.credentials.CredentialsSupport;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentityProvider;
import org.apache.sling.auth.core.spi.AuthenticationHandler;
import org.apache.sling.auth.core.spi.AuthenticationInfo;
import org.apache.sling.auth.core.spi.DefaultAuthenticationFeedbackHandler;
import org.apache.sling.auth.oauth_client.ClientConnection;
import org.apache.sling.auth.oauth_client.impl.OAuthCookieValue;
import org.apache.sling.auth.oauth_client.impl.OidcConnectionImpl;
import org.apache.sling.auth.oauth_client.impl.OidcIdentityProvider;
import org.apache.sling.auth.oauth_client.impl.RedirectHelper;
import org.apache.sling.auth.oauth_client.impl.RedirectTarget;
import org.apache.sling.auth.oauth_client.impl.ResolvedConnection;
import org.apache.sling.auth.oauth_client.impl.ResolvedOidcConnection;
import org.apache.sling.auth.oauth_client.spi.LoginCookieManager;
import org.apache.sling.auth.oauth_client.spi.OidcAuthCredentials;
import org.apache.sling.auth.oauth_client.spi.UserInfoProcessor;
import org.apache.sling.commons.crypto.CryptoService;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={AuthenticationHandler.class}, immediate=true)
@Designate(ocd=Config.class, factory=true)
public class OidcAuthenticationHandler
extends DefaultAuthenticationFeedbackHandler
implements AuthenticationHandler {
    public static final String REDIRECT_ATTRIBUTE_NAME = "sling.redirect";
    private static final Logger logger = LoggerFactory.getLogger(OidcAuthenticationHandler.class);
    private static final String AUTH_TYPE = "oidc";
    private final Map<String, ClientConnection> connections;
    private final String idp;
    private final String callbackUri;
    private final LoginCookieManager loginCookieManager;
    private final String defaultConnectionName;
    private final UserInfoProcessor userInfoProcessor;
    private final boolean userInfoEnabled;
    private final boolean pkceEnabled;
    private final String[] path;
    private final CryptoService cryptoService;

    @Activate
    public OidcAuthenticationHandler(@NotNull BundleContext bundleContext, @Reference List<ClientConnection> connections, Config config, @Reference(policyOption=ReferencePolicyOption.GREEDY) LoginCookieManager loginCookieManager, @Reference(policyOption=ReferencePolicyOption.GREEDY) UserInfoProcessor userInfoProcessor, @Reference CryptoService cryptoService) {
        this.connections = connections.stream().collect(Collectors.toMap(ClientConnection::name, Function.identity()));
        this.idp = config.idp();
        this.callbackUri = config.callbackUri();
        this.loginCookieManager = loginCookieManager;
        this.defaultConnectionName = config.defaultConnectionName();
        this.userInfoProcessor = userInfoProcessor;
        this.userInfoEnabled = config.userInfoEnabled();
        this.pkceEnabled = config.pkceEnabled();
        this.path = config.path();
        this.cryptoService = cryptoService;
        logger.debug("activate: registering ExternalIdentityProvider");
        bundleContext.registerService(new String[]{ExternalIdentityProvider.class.getName(), CredentialsSupport.class.getName()}, (Object)new OidcIdentityProvider(this.idp), null);
        logger.info("OidcAuthenticationHandler successfully activated");
    }

    public AuthenticationInfo extractCredentials(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response) {
        AuthorizationResponse authResponse;
        logger.debug("inside extractCredentials");
        AuthenticationInfo authInfo = this.loginCookieManager.verifyLoginCookie(request);
        if (authInfo != null) {
            return authInfo;
        }
        StringBuffer requestURL = request.getRequestURL();
        if (request.getQueryString() == null) {
            return null;
        }
        requestURL.append('?').append(request.getQueryString());
        try {
            authResponse = AuthorizationResponse.parse((URI)new URI(requestURL.toString()));
        }
        catch (ParseException | URISyntaxException e) {
            logger.debug("Failed to parse authorization response: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
        State clientState = authResponse.getState();
        if (clientState == null) {
            logger.debug("No state found in authorization response");
            return null;
        }
        String authCode = OidcAuthenticationHandler.extractAuthCode(authResponse);
        Cookie oauthCookie = OidcAuthenticationHandler.extractCookie(request, "sling.oauth-request-key");
        OAuthCookieValue oAuthCookieValue = new OAuthCookieValue(oauthCookie.getValue(), this.cryptoService);
        request.setAttribute(REDIRECT_ATTRIBUTE_NAME, (Object)oAuthCookieValue.redirect());
        String stateFromRequest = clientState.getValue();
        String stateFromCookie = oAuthCookieValue.getState().getValue();
        if (!stateFromRequest.equals(stateFromCookie)) {
            throw new IllegalStateException("Failed state check: request keys from client and server are not the same");
        }
        String desiredConnectionName = oAuthCookieValue.connectionName();
        ClientConnection connection = this.connections.get(desiredConnectionName);
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Requested unknown connection '%s'", desiredConnectionName));
        }
        ResolvedConnection conn = ResolvedOidcConnection.resolve(connection);
        TokenResponse tokenResponse = this.extractTokenResponse(authCode, conn, this.callbackUri, oAuthCookieValue.codeVerifier());
        Nonce nonce = oAuthCookieValue.nonce();
        IDTokenClaimsSet claims = OidcAuthenticationHandler.validateIdToken(tokenResponse, (ResolvedOidcConnection)conn, nonce);
        String subject = claims.getSubject().getValue();
        OidcAuthCredentials credentials = this.extractCredentials((OidcConnectionImpl)connection, subject, tokenResponse);
        authInfo = new AuthenticationInfo(AUTH_TYPE, subject);
        authInfo.put("user.jcr.credentials", (Object)credentials);
        logger.info("User {} authenticated", (Object)subject);
        return authInfo;
    }

    @NotNull
    private OidcAuthCredentials extractCredentials(@NotNull OidcConnectionImpl connection, @NotNull String subject, @NotNull TokenResponse tokenResponse) {
        if (this.userInfoEnabled) {
            try {
                HTTPResponse httpResponseUserInfo = new UserInfoRequest(new URI(connection.userInfoUrl()), tokenResponse.toSuccessResponse().getTokens().getAccessToken()).toHTTPRequest().send();
                UserInfoResponse userInfoResponse = UserInfoResponse.parse((HTTPResponse)httpResponseUserInfo);
                if (!userInfoResponse.indicatesSuccess()) {
                    logger.debug("UserInfo error. Received code: {}, message: {}", (Object)userInfoResponse.toErrorResponse().getErrorObject().getCode(), (Object)userInfoResponse.toErrorResponse().getErrorObject().getDescription());
                    throw new RuntimeException(OidcAuthenticationHandler.toErrorMessage("Error in userinfo response", (ErrorResponse)userInfoResponse.toErrorResponse()));
                }
                UserInfo userInfo = userInfoResponse.toSuccessResponse().getUserInfo();
                return this.userInfoProcessor.process(userInfo.toJSONObject().toJSONString(), tokenResponse.toSuccessResponse().toJSONObject().toJSONString(), subject, this.idp);
            }
            catch (ParseException | IOException | URISyntaxException e) {
                logger.error("Error while processing UserInfo: {}", (Object)e.getMessage(), (Object)e);
                throw new RuntimeException(e);
            }
        }
        return this.userInfoProcessor.process(null, tokenResponse.toSuccessResponse().toSuccessResponse().toJSONObject().toJSONString(), subject, this.idp);
    }

    @NotNull
    private static String extractAuthCode(@NotNull AuthorizationResponse authResponse) {
        if (authResponse.indicatesSuccess()) {
            AuthorizationCode authCode = authResponse.toSuccessResponse().getAuthorizationCode();
            if (authCode == null) {
                throw new IllegalStateException("No authorization code found in authorization response");
            }
            return authCode.getValue();
        }
        throw new IllegalStateException(authResponse.toErrorResponse().getErrorObject().getDescription());
    }

    @NotNull
    private TokenResponse extractTokenResponse(@NotNull String authCode, @NotNull ResolvedConnection conn, @NotNull String callbackUri, CodeVerifier codeVerifierCookie) {
        if (this.pkceEnabled && codeVerifierCookie == null) {
            throw new IllegalStateException("PKCE is enabled but no code verifier cookie found");
        }
        try {
            TokenRequest tokenRequest;
            ClientSecretBasic clientCredentials;
            Secret clientSecret;
            URI tokenEndpoint = new URI(conn.tokenEndpoint());
            ClientID clientId = new ClientID(conn.clientId());
            AuthorizationCode code = new AuthorizationCode(authCode);
            if (this.pkceEnabled && conn.clientSecret() != null) {
                clientSecret = new Secret(conn.clientSecret());
                clientCredentials = new ClientSecretBasic(clientId, clientSecret);
                tokenRequest = new TokenRequest.Builder(tokenEndpoint, (ClientAuthentication)clientCredentials, (AuthorizationGrant)new AuthorizationCodeGrant(code, new URI(callbackUri), codeVerifierCookie)).build();
            } else if (this.pkceEnabled) {
                tokenRequest = new TokenRequest.Builder(tokenEndpoint, clientId, (AuthorizationGrant)new AuthorizationCodeGrant(code, new URI(callbackUri), new CodeVerifier(codeVerifierCookie.getValue()))).build();
            } else {
                clientSecret = new Secret(conn.clientSecret());
                clientCredentials = new ClientSecretBasic(clientId, clientSecret);
                tokenRequest = new TokenRequest.Builder(tokenEndpoint, (ClientAuthentication)clientCredentials, (AuthorizationGrant)new AuthorizationCodeGrant(code, new URI(callbackUri))).build();
            }
            HTTPRequest httpRequest = tokenRequest.toHTTPRequest();
            httpRequest.setAccept("application/json");
            HTTPResponse httpResponse = httpRequest.send();
            TokenResponse tokenResponse = OIDCTokenResponseParser.parse((HTTPResponse)httpResponse);
            if (!tokenResponse.indicatesSuccess()) {
                logger.debug("Token error. Received code: {}, message: {}", (Object)tokenResponse.toErrorResponse().getErrorObject().getCode(), (Object)tokenResponse.toErrorResponse().getErrorObject().getDescription());
                throw new RuntimeException(OidcAuthenticationHandler.toErrorMessage("Error in token response", (ErrorResponse)tokenResponse.toErrorResponse()));
            }
            return tokenResponse.toSuccessResponse();
        }
        catch (URISyntaxException e) {
            logger.error("Token Endpoint is not a valid URI: {} Error: {}", (Object)conn.tokenEndpoint(), (Object)e.getMessage());
            throw new RuntimeException(String.format("Token Endpoint is not a valid URI: %s", conn.tokenEndpoint()));
        }
        catch (IOException e) {
            logger.error("Failed to exchange authorization code for access token: {}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException(e);
        }
        catch (ParseException e) {
            logger.error("Failed to parse token response: {}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException(e.getMessage());
        }
    }

    @NotNull
    private static Cookie extractCookie(@NotNull HttpServletRequest request, String cookieName) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            throw new IllegalStateException("Failed state check: No cookies found");
        }
        for (Cookie cookie : cookies) {
            if (!cookieName.equals(cookie.getName())) continue;
            return cookie;
        }
        throw new IllegalStateException(String.format("Failed state check: No request cookie named %s found", cookieName));
    }

    @NotNull
    private static IDTokenClaimsSet validateIdToken(@NotNull TokenResponse tokenResponse, @NotNull ResolvedOidcConnection conn, Nonce nonce) {
        Issuer issuer = new Issuer(conn.issuer());
        ClientID clientID = new ClientID(conn.clientId());
        try {
            JWSAlgorithm jwsAlg = JWSAlgorithm.RS256;
            URL jwkSetURL = conn.jwkSetURL().toURL();
            IDTokenValidator validator = new IDTokenValidator(issuer, clientID, jwsAlg, jwkSetURL);
            return validator.validate(tokenResponse.toSuccessResponse().getTokens().toOIDCTokens().getIDToken(), nonce);
        }
        catch (JOSEException | BadJOSEException | MalformedURLException e) {
            logger.error("Failed to validate token: {}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException(e.getMessage());
        }
    }

    @NotNull
    private static String toErrorMessage(@NotNull String context, @NotNull ErrorResponse error) {
        ErrorObject errorObject = error.getErrorObject();
        StringBuilder message = new StringBuilder();
        message.append(context).append(": ").append(errorObject.getCode());
        message.append(". Status code: ").append(errorObject.getHTTPStatusCode());
        String description = errorObject.getDescription();
        if (description != null) {
            message.append(". ").append(description);
        }
        return message.toString();
    }

    public boolean requestCredentials(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response) {
        logger.debug("inside requestCredentials");
        AuthenticationInfo authInfo = this.loginCookieManager.verifyLoginCookie(request);
        if (authInfo != null) {
            return true;
        }
        String desiredConnectionName = request.getParameter("c");
        if (desiredConnectionName == null) {
            logger.debug("Missing mandatory request parameter 'c' using default connection");
            desiredConnectionName = this.defaultConnectionName;
        }
        try {
            ClientConnection connection = this.connections.get(desiredConnectionName);
            if (connection == null) {
                logger.debug("Client requested unknown connection");
                response.sendError(400, "Client requested unknown connection");
                return false;
            }
            RedirectTarget redirect = this.getAuthenticationRequestUri(connection, request, URI.create(this.callbackUri));
            response.addCookie(redirect.cookie());
            response.sendRedirect(redirect.uri().toString());
            return true;
        }
        catch (IOException e) {
            logger.error("Error while redirecting to default redirect: {}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException(e);
        }
    }

    @NotNull
    private RedirectTarget getAuthenticationRequestUri(@NotNull ClientConnection connection, @NotNull HttpServletRequest request, @NotNull URI callbackUri) {
        ResolvedConnection conn = ResolvedOidcConnection.resolve(connection);
        String redirect = request.getRequestURI();
        String perRequestKey = new Identifier().getValue();
        Nonce nonce = new Nonce(new Identifier().getValue());
        CodeVerifier codeVerifier = null;
        if (this.pkceEnabled) {
            codeVerifier = new CodeVerifier();
        }
        OAuthCookieValue oAuthCookieValue = new OAuthCookieValue(perRequestKey, connection.name(), redirect, nonce, codeVerifier);
        return RedirectHelper.buildRedirectTarget(this.path, callbackUri, conn, oAuthCookieValue, this.cryptoService);
    }

    public void dropCredentials(HttpServletRequest request, HttpServletResponse response) {
    }

    public boolean authenticationSucceeded(HttpServletRequest request, HttpServletResponse response, AuthenticationInfo authInfo) {
        if (this.loginCookieManager == null) {
            logger.debug("TokenUpdate service is not available");
            return super.authenticationSucceeded(request, response, authInfo);
        }
        if (this.loginCookieManager.getLoginCookie(request) != null) {
            this.deleteAuthenticationCookies(request.getRequestURI(), response);
            return false;
        }
        Object creds = authInfo.get((Object)"user.jcr.credentials");
        if (creds instanceof OidcAuthCredentials) {
            String token;
            OidcAuthCredentials oidcAuthCredentials = (OidcAuthCredentials)creds;
            Object tokenValueObject = oidcAuthCredentials.getAttribute(".token");
            if (tokenValueObject != null && !tokenValueObject.toString().isEmpty() && !(token = tokenValueObject.toString()).isEmpty()) {
                logger.debug("Calling TokenUpdate service to update token cookie");
                this.loginCookieManager.setLoginCookie(request, response, oidcAuthCredentials);
            }
            String redirectUrl = (String)request.getAttribute(REDIRECT_ATTRIBUTE_NAME);
            this.deleteAuthenticationCookies(request.getRequestURL().toString(), response);
            try {
                response.sendRedirect(redirectUrl);
            }
            catch (IOException e) {
                logger.error("Error while redirecting to redirect url '{}': {}", new Object[]{redirectUrl, e.getMessage(), e});
                throw new RuntimeException(e);
            }
        }
        return true;
    }

    private void deleteAuthenticationCookies(@NotNull String requestUri, @NotNull HttpServletResponse response) {
        this.deleteCookie(requestUri, response, "sling.oauth-request-key");
    }

    private void deleteCookie(@NotNull String requestUri, @NotNull HttpServletResponse response, @NotNull String cookieName) {
        Cookie cookie = new Cookie(cookieName, null);
        cookie.setMaxAge(0);
        cookie.setHttpOnly(true);
        cookie.setSecure(true);
        cookie.setPath(RedirectHelper.findLongestPathMatching(this.path, requestUri));
        response.addCookie(cookie);
    }

    @ObjectClassDefinition(name="Apache Sling Oidc Authentication Handler", description="Apache Sling Oidc Authentication Handler Service")
    static @interface Config {
        @AttributeDefinition(name="Path", description="Repository path for which this authentication handler should be used by Sling. If this is empty, the authentication handler will be disabled. By default this is set to \"/\".")
        public String[] path() default {"/"};

        @AttributeDefinition(name="Sync Handler Configuration Name", description="Name of Sync Handler Configuration")
        public String idp() default "oidc";

        @AttributeDefinition(name="Callback URI", description="Callback URI")
        public String callbackUri() default "callbackUri";

        @AttributeDefinition(name="Default Connection Name", description="Default Connection Name")
        public String defaultConnectionName() default "";

        @AttributeDefinition(name="PKCE Enabled", description="PKCE Enabled")
        public boolean pkceEnabled() default false;

        @AttributeDefinition(name="UserInfo Enabled", description="UserInfo Enabled")
        public boolean userInfoEnabled() default true;
    }
}

