/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.identification;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Collection;
import java.util.List;
import org.apache.sis.metadata.TitleProperty;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.xml.bind.metadata.code.DCPList;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.citation.OnlineResource;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.util.CodeList;
import org.opengis.util.InternationalString;

@TitleProperty(name="operationName")
@XmlType(name="SV_OperationMetadata_Type", namespace="http://standards.iso.org/iso/19115/-3/srv/2.0", propOrder={"operationName", "distributedComputingPlatforms", "operationDescription", "invocationName", "connectPoints", "parameters", "dependsOn"})
@XmlRootElement(name="SV_OperationMetadata", namespace="http://standards.iso.org/iso/19115/-3/srv/2.0")
@UML(identifier="SV_OperationMetadata", specification=Specification.ISO_19115)
public class DefaultOperationMetadata
extends ISOMetadata {
    private static final long serialVersionUID = -3513177609655567627L;
    private String operationName;
    private Collection<CodeList<?>> distributedComputingPlatforms;
    private InternationalString operationDescription;
    private InternationalString invocationName;
    private Collection<OnlineResource> connectPoints;
    private Collection<ParameterDescriptor<?>> parameters;
    private List<DefaultOperationMetadata> dependsOn;

    public DefaultOperationMetadata() {
    }

    public DefaultOperationMetadata(DefaultOperationMetadata object) {
        super(object);
        if (object != null) {
            this.operationName = object.getOperationName();
            this.distributedComputingPlatforms = DefaultOperationMetadata.copyCollection(object.getDistributedComputingPlatforms(), CodeList.class);
            this.operationDescription = object.getOperationDescription();
            this.invocationName = object.getInvocationName();
            this.connectPoints = DefaultOperationMetadata.copyCollection(object.getConnectPoints(), OnlineResource.class);
            this.parameters = DefaultOperationMetadata.copySet(object.getParameters(), ParameterDescriptor.class);
            this.dependsOn = DefaultOperationMetadata.copyList(object.getDependsOn(), DefaultOperationMetadata.class);
        }
    }

    @XmlElement(name="operationName", required=true)
    @UML(identifier="operationName", obligation=Obligation.MANDATORY, specification=Specification.ISO_19115)
    public String getOperationName() {
        return this.operationName;
    }

    public void setOperationName(String newValue) {
        this.checkWritePermission(this.operationName);
        this.operationName = newValue;
    }

    @XmlJavaTypeAdapter(value=DCPList.class)
    @XmlElement(name="distributedComputingPlatform", required=true)
    @UML(identifier="distributedComputingPlatform", obligation=Obligation.MANDATORY, specification=Specification.ISO_19115)
    public Collection<CodeList<?>> getDistributedComputingPlatforms() {
        this.distributedComputingPlatforms = this.nonNullCollection(this.distributedComputingPlatforms, CodeList.class);
        return this.distributedComputingPlatforms;
    }

    public void setDistributedComputingPlatforms(Collection<? extends CodeList<?>> newValues) {
        this.distributedComputingPlatforms = this.writeCollection(newValues, this.distributedComputingPlatforms, CodeList.class);
    }

    @XmlElement(name="operationDescription")
    @UML(identifier="operationDescription", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public InternationalString getOperationDescription() {
        return this.operationDescription;
    }

    public void setOperationDescription(InternationalString newValue) {
        this.checkWritePermission(this.operationDescription);
        this.operationDescription = newValue;
    }

    @XmlElement(name="invocationName")
    @UML(identifier="invocationName", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public InternationalString getInvocationName() {
        return this.invocationName;
    }

    public void setInvocationName(InternationalString newValue) {
        this.checkWritePermission(this.invocationName);
        this.invocationName = newValue;
    }

    @XmlElement(name="connectPoint", required=true)
    @UML(identifier="connectPoint", obligation=Obligation.MANDATORY, specification=Specification.ISO_19115)
    public Collection<OnlineResource> getConnectPoints() {
        this.connectPoints = this.nonNullCollection(this.connectPoints, OnlineResource.class);
        return this.connectPoints;
    }

    public void setConnectPoints(Collection<? extends OnlineResource> newValue) {
        this.connectPoints = this.writeCollection(newValue, this.connectPoints, OnlineResource.class);
    }

    @XmlElement(name="parameter")
    @UML(identifier="parameters", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<ParameterDescriptor<?>> getParameters() {
        this.parameters = this.nonNullCollection(this.parameters, ParameterDescriptor.class);
        return this.parameters;
    }

    public void setParameters(Collection<? extends ParameterDescriptor<?>> newValues) {
        this.parameters = this.writeCollection(newValues, this.parameters, ParameterDescriptor.class);
    }

    @XmlElement(name="dependsOn")
    @UML(identifier="dependsOn", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public List<DefaultOperationMetadata> getDependsOn() {
        this.dependsOn = this.nonNullList(this.dependsOn, DefaultOperationMetadata.class);
        return this.dependsOn;
    }

    public void setDependsOn(List<? extends DefaultOperationMetadata> newValues) {
        this.dependsOn = this.writeList(newValues, this.dependsOn, DefaultOperationMetadata.class);
    }
}

