/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.charset.Charset;
import org.apache.sis.io.InvalidSeekException;
import org.apache.sis.storage.internal.InputStreamAdapter;
import org.apache.sis.util.resources.Errors;

public final class RewindableLineReader
extends LineNumberReader {
    private static final int BUFFER_SIZE = 8192;
    private InputStreamAdapter input;
    private final Charset encoding;
    private boolean isMarkProtected;

    public RewindableLineReader(InputStream input, Charset encoding) throws IOException {
        super(encoding != null ? new InputStreamReader(input, encoding) : new InputStreamReader(input), 8192);
        if (input instanceof InputStreamAdapter) {
            this.input = (InputStreamAdapter)input;
        }
        this.encoding = encoding;
        this.lock = input;
        super.mark(8192);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RewindableLineReader rewind() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                super.reset();
                return this;
            }
            catch (IOException e1) {
                InputStreamAdapter stream = this.input;
                if (stream == null) {
                    throw new InvalidSeekException();
                }
                this.input = null;
                assert (Thread.holdsLock(stream));
                try {
                    stream.keepOpen = true;
                    super.close();
                }
                finally {
                    stream.keepOpen = false;
                }
                try {
                    stream.input.seek(0L);
                }
                catch (IOException e2) {
                    e2.addSuppressed(e1);
                    throw e2;
                }
                return new RewindableLineReader(stream, this.encoding);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void protectedMark() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            super.mark(8192);
            this.isMarkProtected = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void protectedReset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.isMarkProtected = false;
            super.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean markSupported() {
        Object object = this.lock;
        synchronized (object) {
            return !this.isMarkProtected;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mark(int readlimit) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isMarkProtected) {
                throw new IOException(Errors.format((short)199, (Object)"mark"));
            }
            super.mark(readlimit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isMarkProtected) {
                throw new IOException(Errors.format((short)199, (Object)"reset"));
            }
            super.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.input = null;
            if (this.isMarkProtected) {
                super.reset();
            } else {
                super.close();
            }
        }
    }
}

