/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.connector.api.data;

import io.openmessaging.KeyValue;
import io.openmessaging.connector.api.data.RecordOffset;
import io.openmessaging.connector.api.data.RecordPartition;
import io.openmessaging.connector.api.data.RecordPosition;
import io.openmessaging.connector.api.data.Schema;
import io.openmessaging.internal.DefaultKeyValue;
import java.util.Objects;
import java.util.Set;

public class ConnectRecord {
    private Long timestamp;
    private Schema schema;
    private Object data;
    private RecordPosition position;
    private KeyValue extensions;

    public ConnectRecord(RecordPartition recordPartition, RecordOffset recordOffset, Long timestamp) {
        this(recordPartition, recordOffset, timestamp, null, null);
    }

    public ConnectRecord(RecordPartition recordPartition, RecordOffset recordOffset, Long timestamp, Schema schema, Object data) {
        this.position = new RecordPosition(recordPartition, recordOffset);
        this.schema = schema;
        this.timestamp = timestamp;
        this.data = data;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public KeyValue getExtensions() {
        return this.extensions;
    }

    public void setExtensions(KeyValue extensions) {
        this.extensions = extensions;
    }

    public void addExtension(KeyValue extensions) {
        if (this.extensions == null) {
            this.extensions = new DefaultKeyValue();
        }
        Set<String> keySet = extensions.keySet();
        for (String key : keySet) {
            this.extensions.put(key, extensions.getString(key));
        }
    }

    public void addExtension(String key, String value) {
        if (this.extensions == null) {
            this.extensions = new DefaultKeyValue();
        }
        this.extensions.put(key, value);
    }

    public String getExtension(String key) {
        if (this.extensions == null) {
            return null;
        }
        return this.extensions.getString(key);
    }

    public RecordPosition getPosition() {
        return this.position;
    }

    public void setPosition(RecordPosition position) {
        this.position = position;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConnectRecord)) {
            return false;
        }
        ConnectRecord that = (ConnectRecord)o;
        return Objects.equals(this.timestamp, that.timestamp) && Objects.equals(this.schema, that.schema) && Objects.equals(this.data, that.data) && Objects.equals(this.position, that.position) && Objects.equals(this.extensions, that.extensions);
    }

    public int hashCode() {
        return Objects.hash(this.timestamp, this.schema, this.data, this.position, this.extensions);
    }

    public String toString() {
        return "ConnectRecord{timestamp=" + this.timestamp + ", schema=" + this.schema + ", data=" + this.data + ", position=" + this.position + ", extensions=" + this.extensions + '}';
    }
}

